/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.codegen;

import java.util.List;
import org.eclipse.emf.codegen.ecore.generator.AbstractGeneratorAdapter;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenPackageGeneratorAdapter;
import org.eclipse.emf.codegen.jet.JETEmitter;

/**
 * A specialized {@link GenPackageGeneratorAdapter} that registers a specialized
 * JavaJet template for generated {@link EFactory} used for the generation of
 * {@link ModelType}s. Using this template, the generated factory will always
 * throw an exception when trying to create a new model element (via
 * {@code createX()} methods), as {@link ModelType} are inherently abstract
 * and it does not make sense to call the factory methods on them.
 */
@SuppressWarnings("all")
public class ModelTypeGenPackageGeneratorAdapter extends GenPackageGeneratorAdapter {
  public ModelTypeGenPackageGeneratorAdapter(final GeneratorAdapterFactory generatorAdapterFactory) {
    super(generatorAdapterFactory);
  }

  @Override
  public void addBaseTemplatePathEntries(final List<String> templatePath) {
    templatePath.add("platform:/plugin/fr.inria.diverse.melange/templates");
    super.addBaseTemplatePathEntries(templatePath);
  }

  @Override
  public JETEmitter getJETEmitter(final AbstractGeneratorAdapter.JETEmitterDescriptor[] jetEmitterDescriptors, final int id) {
    if ((id == GenPackageGeneratorAdapter.FACTORY_CLASS_ID)) {
      JETEmitter _get = this.jetEmitters[id];
      boolean _tripleEquals = (_get == null);
      if (_tripleEquals) {
        final AbstractGeneratorAdapter.JETEmitterDescriptor factoryClassJet = new AbstractGeneratorAdapter.JETEmitterDescriptor("model/FactoryClass.javajet", "");
        this.jetEmitters[id] = this.createJETEmitter(factoryClassJet);
      }
    }
    return super.getJETEmitter(jetEmitterDescriptors, id);
  }
}
