/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.console;

import java.util.function.Function;
import org.eclipse.jdt.internal.debug.ui.console.JavaConsoleTracker;
import org.eclipse.jdt.internal.debug.ui.console.JavaDebugStackTraceHyperlink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class JavaDebugStackTraceConsoleTracker
extends JavaConsoleTracker {
    @Override
    public void matchFound(PatternMatchEvent event) {
        try {
            this.addHyperlinkAtContent(event, line -> JavaDebugStackTraceHyperlink.extractLineText(line));
            this.addHyperlinkAtContent(event, line -> JavaDebugStackTraceHyperlink.extractTypeName(line));
        }
        catch (BadLocationException badLocationException) {}
    }

    private void addHyperlinkAtContent(PatternMatchEvent event, Function<String, JavaDebugStackTraceHyperlink.LinkSubstring> contentSupplier) throws BadLocationException {
        int offset = event.getOffset();
        int length = event.getLength();
        TextConsole console = this.getConsole();
        IDocument document = console.getDocument();
        String line = document.get(offset, length);
        JavaDebugStackTraceHyperlink.LinkSubstring linkSubstring = contentSupplier.apply(line);
        if (linkSubstring != null) {
            int hyperlinkStartIndex = offset + linkSubstring.startIndex;
            int hyperlinkLength = linkSubstring.substring.length();
            JavaDebugStackTraceHyperlink link = new JavaDebugStackTraceHyperlink(console);
            console.addHyperlink((IHyperlink)link, hyperlinkStartIndex, hyperlinkLength);
        }
    }
}

