/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.melange.lib;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import fr.inria.diverse.melange.lib.EcoreExtensions;
import fr.inria.diverse.melange.lib.MappingExtensions;
import fr.inria.diverse.melange.metamodel.melange.Mapping;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class MatchingHelper {
    private List<EPackage> pkgsA;
    private List<EPackage> pkgsB;
    private Map<Pair<ENamedElement, ENamedElement>, Boolean> matches;
    private Stack<EClass> currentMatching;
    private Map<EClass, Set<EClass>> presumedMatching;
    private Mapping mapping;
    private boolean debug;
    @Inject
    @Extension
    private EcoreExtensions _ecoreExtensions;
    @Inject
    @Extension
    private MappingExtensions _mappingExtensions;

    public boolean match(List<EPackage> l1, List<EPackage> l2, Mapping map) {
        this.pkgsA = l1;
        this.pkgsB = l2;
        this.mapping = map;
        this.matches = CollectionLiterals.newHashMap();
        Stack _stack = new Stack();
        this.currentMatching = _stack;
        this.presumedMatching = CollectionLiterals.newHashMap();
        Functions.Function1 _function = clsB -> {
            Functions.Function1 _function_1 = clsA -> this.internalMatch((EClass)clsA, (EClass)clsB, 0);
            return IterableExtensions.exists((Iterable)Iterables.filter(this._ecoreExtensions.getAllClassifiers(this.pkgsA), EClass.class), (Functions.Function1)_function_1);
        };
        boolean ret = IterableExtensions.forall((Iterable)Iterables.filter(this._ecoreExtensions.getAllClassifiers(this.pkgsB), EClass.class), (Functions.Function1)_function);
        Functions.Function1 _function_1 = clsA -> {
            boolean _xblockexpression = false;
            Set<EClass> matchings = this.presumedMatching.get(clsA);
            _xblockexpression = matchings.size() == 1 && this.internalMatch((EClass)clsA, (EClass)IterableExtensions.head(matchings), 0);
            return _xblockexpression;
        };
        boolean postValidation = IterableExtensions.forall(this.presumedMatching.keySet(), (Functions.Function1)_function_1);
        return ret && postValidation;
    }

    public void setDebug(boolean d) {
        this.debug = d;
    }

    public Set<ENamedElement> getUnmatchedElements() {
        Functions.Function1 _function = pair -> {
            Functions.Function1 _function_1 = it -> {
                ENamedElement _value = (ENamedElement)it.getValue();
                ENamedElement _value_1 = (ENamedElement)pair.getValue();
                return Objects.equal((Object)_value, (Object)_value_1);
            };
            Functions.Function1 _function_2 = p -> {
                Boolean _get = this.matches.get(p);
                return _get == false;
            };
            return IterableExtensions.forall((Iterable)IterableExtensions.filter(this.matches.keySet(), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        };
        Functions.Function1 _function_1 = it -> (ENamedElement)it.getValue();
        return IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(this.matches.keySet(), (Functions.Function1)_function), (Functions.Function1)_function_1));
    }

    private void p(String msg, int nesting) {
        if (this.debug) {
            if (nesting > 0) {
                Functions.Function1 _function = it -> "\t";
                InputOutput.print((Object)IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)new IntegerRange(1, nesting), (Functions.Function1)_function)));
            }
            InputOutput.println((Object)msg);
        }
    }

    private boolean internalMatch(EClass clsA, EClass clsB, int nesting) {
        boolean _not;
        Pair _mappedTo = Pair.of((Object)clsA, (Object)clsB);
        boolean _containsKey = this.matches.containsKey(_mappedTo);
        if (_containsKey) {
            Pair _mappedTo_1 = Pair.of((Object)clsA, (Object)clsB);
            return this.matches.get(_mappedTo_1);
        }
        boolean _contains = this.currentMatching.contains(clsB);
        boolean bl = _not = !_contains;
        if (_not) {
            boolean _namesMatch = this._mappingExtensions.namesMatch(this.mapping, (ENamedElement)clsA, (ENamedElement)clsB);
            if (_namesMatch) {
                this.p("Matching " + clsA, nesting);
            }
            this.currentMatching.push(clsB);
            boolean ret = this._mappingExtensions.namesMatch(this.mapping, (ENamedElement)clsA, (ENamedElement)clsB) && IterableExtensions.forall((Iterable)clsB.getEOperations(), opB -> {
                Functions.Function1 _function = opA -> this.internalMatch((EOperation)opA, (EOperation)opB, nesting + 1);
                return IterableExtensions.exists((Iterable)clsA.getEOperations(), (Functions.Function1)_function);
            }) && IterableExtensions.forall((Iterable)clsB.getEAttributes(), attrB -> {
                Functions.Function1 _function = attrA -> this.internalMatch((EAttribute)attrA, (EAttribute)attrB, nesting + 1);
                return IterableExtensions.exists((Iterable)clsA.getEAttributes(), (Functions.Function1)_function);
            }) && IterableExtensions.forall((Iterable)clsB.getEReferences(), refB -> {
                Functions.Function1 _function = refA -> this.internalMatch((EReference)refA, (EReference)refB, nesting + 1);
                return IterableExtensions.exists((Iterable)clsA.getEReferences(), (Functions.Function1)_function);
            }) && IterableExtensions.forall((Iterable)clsB.getESuperTypes(), sB -> {
                Functions.Function1 _function = sA -> this.internalMatch((EClass)sA, (EClass)sB, nesting + 1);
                return IterableExtensions.exists((Iterable)clsA.getESuperTypes(), (Functions.Function1)_function);
            });
            this.currentMatching.pop();
            Pair _mappedTo_2 = Pair.of((Object)clsA, (Object)clsB);
            this.matches.put((Pair<ENamedElement, ENamedElement>)_mappedTo_2, ret);
            boolean _namesMatch_1 = this._mappingExtensions.namesMatch(this.mapping, (ENamedElement)clsA, (ENamedElement)clsB);
            if (_namesMatch_1) {
                this.p("Done = " + Boolean.valueOf(ret), nesting);
            }
            return ret;
        }
        boolean _namesMatch_2 = this._mappingExtensions.namesMatch(this.mapping, (ENamedElement)clsA, (ENamedElement)clsB);
        if (_namesMatch_2) {
            boolean _tripleEquals;
            Set<EClass> _get = this.presumedMatching.get(clsA);
            boolean bl2 = _tripleEquals = _get == null;
            if (_tripleEquals) {
                this.presumedMatching.put(clsA, CollectionLiterals.newHashSet());
            }
            Set<EClass> _get_1 = this.presumedMatching.get(clsA);
            _get_1.add(clsB);
            return true;
        }
        return false;
    }

    private boolean internalMatch(EOperation opA, EOperation opB, int nesting) {
        Pair _mappedTo = Pair.of((Object)opA, (Object)opB);
        boolean _containsKey = this.matches.containsKey(_mappedTo);
        if (_containsKey) {
            Pair _mappedTo_1 = Pair.of((Object)opA, (Object)opB);
            return this.matches.get(_mappedTo_1);
        }
        boolean _namesMatch = this._mappingExtensions.namesMatch(this.mapping, (ENamedElement)opA, (ENamedElement)opB);
        if (_namesMatch) {
            this.p("Matching " + opA, nesting);
        }
        boolean _and = false;
        boolean _namesMatch_1 = this._mappingExtensions.namesMatch(this.mapping, (ENamedElement)opA, (ENamedElement)opB);
        if (!_namesMatch_1) {
            _and = false;
        } else {
            boolean _xifexpression = false;
            _xifexpression = opA.getEType() instanceof EDataType || opB.getEType() instanceof EDataType ? this._mappingExtensions.namesMatch(this.mapping, (ENamedElement)opA.getEType(), (ENamedElement)opB.getEType()) : this._ecoreExtensions.getAllClassifiers(this.pkgsA).contains(opA.getEType()) && this._ecoreExtensions.getAllClassifiers(this.pkgsB).contains(opB.getEType()) && opA.getEType() != null && opB.getEType() != null && this.internalMatch((EClass)opA.getEType(), (EClass)opB.getEType(), nesting + 1) || opA.getEType() == null && opB.getEType() == null || opA.getEType() instanceof EClass && ((EClass)opA.getEType()).getEAllSuperTypes().contains((Object)opB.getEType()) || Objects.equal((Object)opA.getEType().getEPackage().getNsURI(), (Object)"http://www.eclipse.org/emf/2002/Ecore") && Objects.equal((Object)opA.getEType(), (Object)opB.getEType()) && this.internalMatch((List<EParameter>)opA.getEParameters(), (List<EParameter>)opB.getEParameters(), nesting + 1) && IterableExtensions.forall((Iterable)opA.getEExceptions(), excA -> {
                Functions.Function1 _function = excB -> {
                    boolean _xifexpression_1 = false;
                    _xifexpression_1 = excA instanceof EDataType || excB instanceof EDataType ? this._mappingExtensions.namesMatch(this.mapping, (ENamedElement)excA, (ENamedElement)excB) : this._ecoreExtensions.getAllClassifiers(this.pkgsA).contains(excA) && this._ecoreExtensions.getAllClassifiers(this.pkgsB).contains(excB) && this.internalMatch((EClass)excA, (EClass)excB, nesting + 1) || ((EClass)excA).getEAllSuperTypes().contains(excB);
                    return _xifexpression_1;
                };
                return IterableExtensions.exists((Iterable)opB.getEExceptions(), (Functions.Function1)_function);
            });
            _and = _xifexpression;
        }
        boolean ret = _and;
        boolean _namesMatch_2 = this._mappingExtensions.namesMatch(this.mapping, (ENamedElement)opA, (ENamedElement)opB);
        if (_namesMatch_2) {
            this.p("Done = " + Boolean.valueOf(ret), nesting);
        }
        Pair _mappedTo_2 = Pair.of((Object)opA, (Object)opB);
        this.matches.put((Pair<ENamedElement, ENamedElement>)_mappedTo_2, ret);
        return ret;
    }

    private boolean internalMatch(EAttribute attrA, EAttribute attrB, int nesting) {
        Pair _mappedTo = Pair.of((Object)attrA, (Object)attrB);
        boolean _containsKey = this.matches.containsKey(_mappedTo);
        if (_containsKey) {
            Pair _mappedTo_1 = Pair.of((Object)attrA, (Object)attrB);
            return this.matches.get(_mappedTo_1);
        }
        boolean _namesMatch = this._mappingExtensions.namesMatch(this.mapping, (ENamedElement)attrA, (ENamedElement)attrB);
        if (_namesMatch) {
            this.p("Matching " + attrA, nesting);
        }
        boolean ret = this._mappingExtensions.namesMatch(this.mapping, (ENamedElement)attrA, (ENamedElement)attrB) && (attrB.isChangeable() || !attrA.isChangeable()) && attrA.isUnique() == attrB.isUnique() && (!attrA.isOrdered() || attrB.isOrdered()) && (Objects.equal((Object)attrA.getEAttributeType().getInstanceClassName(), (Object)attrB.getEAttributeType().getInstanceClassName()) && attrA.getEAttributeType().getInstanceClassName() != null || Objects.equal((Object)attrA.getEAttributeType().getInstanceTypeName(), (Object)attrB.getEAttributeType().getInstanceTypeName()) && attrA.getEAttributeType().getInstanceTypeName() != null || attrA.getEAttributeType() instanceof EEnum && attrB.getEAttributeType() instanceof EEnum && this._mappingExtensions.namesMatch(this.mapping, (ENamedElement)attrA.getEAttributeType(), (ENamedElement)attrB.getEAttributeType())) && attrA.getLowerBound() == attrB.getLowerBound() && attrA.getUpperBound() == attrB.getUpperBound();
        boolean _namesMatch_1 = this._mappingExtensions.namesMatch(this.mapping, (ENamedElement)attrA, (ENamedElement)attrB);
        if (_namesMatch_1) {
            this.p("Done = " + Boolean.valueOf(ret), nesting);
        }
        Pair _mappedTo_2 = Pair.of((Object)attrA, (Object)attrB);
        this.matches.put((Pair<ENamedElement, ENamedElement>)_mappedTo_2, ret);
        return ret;
    }

    private boolean internalMatch(EReference refA, EReference refB, int nesting) {
        Pair _mappedTo = Pair.of((Object)refA, (Object)refB);
        boolean _containsKey = this.matches.containsKey(_mappedTo);
        if (_containsKey) {
            Pair _mappedTo_1 = Pair.of((Object)refA, (Object)refB);
            return this.matches.get(_mappedTo_1);
        }
        boolean _namesMatch = this._mappingExtensions.namesMatch(this.mapping, (ENamedElement)refA, (ENamedElement)refB);
        if (_namesMatch) {
            this.p("Matching " + refA, nesting);
        }
        boolean ret = !(!this._mappingExtensions.namesMatch(this.mapping, (ENamedElement)refA, (ENamedElement)refB) || !refB.isChangeable() && refA.isChangeable() || refA.isContainment() != refB.isContainment() || refA.isUnique() != refB.isUnique() || refA.isOrdered() && !refB.isOrdered() || refA.getLowerBound() != refB.getLowerBound() || refA.getUpperBound() != refB.getUpperBound() || refB.getEOpposite() != null && (refA.getEOpposite() == null || !this._mappingExtensions.namesMatch(this.mapping, (ENamedElement)refA, (ENamedElement)refB)) || !this.internalMatch(refA.getEReferenceType(), refB.getEReferenceType(), nesting + 1));
        boolean _namesMatch_1 = this._mappingExtensions.namesMatch(this.mapping, (ENamedElement)refA, (ENamedElement)refB);
        if (_namesMatch_1) {
            this.p("Done = " + Boolean.valueOf(ret), nesting);
        }
        Pair _mappedTo_2 = Pair.of((Object)refA, (Object)refB);
        this.matches.put((Pair<ENamedElement, ENamedElement>)_mappedTo_2, ret);
        return ret;
    }

    private boolean internalMatch(List<EParameter> paramsA, List<EParameter> paramsB, int nesting) {
        int rank = 0;
        for (EParameter paramB : paramsB) {
            boolean _greaterEqualsThan;
            int _size = paramsA.size();
            boolean bl = _greaterEqualsThan = rank >= _size;
            if (_greaterEqualsThan) {
                return false;
            }
            EParameter paramA = paramsA.get(rank);
            if (paramA.getEType() instanceof EDataType || paramB.getEType() instanceof EDataType) {
                boolean _not;
                boolean _namesMatch = this._mappingExtensions.namesMatch(this.mapping, (ENamedElement)paramA.getEType(), (ENamedElement)paramB.getEType());
                boolean bl2 = _not = !_namesMatch;
                if (_not) {
                    return false;
                }
                if (this._ecoreExtensions.getAllClassifiers(this.pkgsA).contains(paramA.getEType()) && this._ecoreExtensions.getAllClassifiers(this.pkgsB).contains(paramB.getEType())) {
                    boolean _not_2;
                    boolean _not_1;
                    EClassifier _eType_1;
                    EClassifier _eType = paramA.getEType();
                    boolean _internalMatch = this.internalMatch((EClass)_eType, (EClass)(_eType_1 = paramB.getEType()), nesting + 1);
                    boolean bl3 = _not_1 = !_internalMatch;
                    if (_not_1) {
                        return false;
                    }
                    EClassifier _eType_2 = paramA.getEType();
                    boolean _contains = ((EClass)_eType_2).getEAllSuperTypes().contains((Object)paramB.getEType());
                    boolean bl4 = _not_2 = !_contains;
                    if (_not_2) {
                        return false;
                    }
                }
            }
            if (paramA.getLowerBound() != paramB.getLowerBound() || paramA.getUpperBound() != paramB.getUpperBound() || paramA.isUnique() != paramB.isUnique() || paramA.isOrdered() && !paramB.isOrdered()) {
                return false;
            }
            ++rank;
        }
        return true;
    }
}

