/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.StepRequest;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IStepFilter;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.jdi.hcr.EventRequestManager;
import org.eclipse.jdi.hcr.ReenterStepRequest;
import org.eclipse.jdi.hcr.ThreadReference;
import org.eclipse.jdt.debug.core.IEvaluationRunnable;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaThreadGroup;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.IJDIEventListener;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.breakpoints.ConditionalBreakpointHandler;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaBreakpoint;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaExceptionBreakpoint;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaLineBreakpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugElement;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIMethod;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;
import org.eclipse.jdt.internal.debug.core.model.LambdaUtils;
import org.eclipse.jdt.internal.debug.core.model.MethodResult;

public class JDIThread
extends JDIDebugElement
implements IJavaThread {
    private static final String JAVA_STRATUM_CONSTANT = "Java";
    private static final String MAIN_THREAD_GROUP = "main";
    public static final int RESUME_QUIET = 500;
    public static final int SUSPEND_QUIET = 501;
    public static final int SUSPEND_TIMEOUT = 161;
    private com.sun.jdi.ThreadReference fThread;
    private String fPreviousName;
    private volatile List<IJavaStackFrame> fStackFrames;
    private ThreadGroupReference fThreadGroup;
    private String fThreadGroupName;
    private boolean fRefreshChildren = true;
    private volatile StepHandler fStepHandler;
    private volatile boolean fRunning;
    private volatile boolean fTerminated;
    private boolean fIsSystemThread;
    private boolean fIsDaemon;
    private final Object breakpointAcessLock = new Object();
    private final List<IBreakpoint> fCurrentBreakpoints = new Vector<IBreakpoint>(2);
    private volatile IEvaluationRunnable fEvaluationRunnable;
    private volatile boolean fEvaluationInterrupted;
    private volatile boolean fClientSuspendRequest;
    private volatile boolean fIsInvokingMethod;
    private final Object fInvocationLock = new Object();
    private final Object fEvaluationLock = new Object();
    private volatile boolean fHonorBreakpoints = true;
    private volatile boolean fSuspendVoteInProgress;
    private volatile int fOriginalStepKind;
    private volatile Location fOriginalStepLocation;
    private volatile int fOriginalStepStackDepth;
    private volatile boolean fIsSuspending;
    private final ThreadJob fAsyncJob;
    private volatile boolean fRunningAsyncJob;
    private volatile MethodExitRequest fCurrentMethodExitRequest;
    private volatile Thread fCurrentMethodExitRequestDisabler;
    private volatile ExceptionRequest fCurrentExceptionRequest;
    private volatile MethodEntryRequest fCurrentMethodEntryRequest;
    private volatile Method fStepResultMethod;
    private volatile Location fStepOverLocation;
    private volatile int fStepOverFrameCount;
    private volatile int fStepReturnTargetFrameCount;
    private volatile MethodResult fStepResultCandidate;
    private final AtomicBoolean fStepResultTimeoutTriggered = new AtomicBoolean();
    private volatile MethodResult fMethodResult;
    private volatile IJavaObject fPreviousException;

    public JDIThread(JDIDebugTarget target, com.sun.jdi.ThreadReference thread) throws ObjectCollectedException {
        super(target);
        this.setUnderlyingThread(thread);
        this.fAsyncJob = new ThreadJob();
        this.initialize();
    }

    protected void initialize() throws ObjectCollectedException {
        Throwable underlyingException;
        this.fStackFrames = new Vector<IJavaStackFrame>();
        try {
            this.determineIfSystemThread();
        }
        catch (DebugException e) {
            underlyingException = e.getStatus().getException();
            if (underlyingException instanceof VMDisconnectedException) {
                this.disconnected();
                return;
            }
            if (underlyingException instanceof ObjectCollectedException) {
                throw (ObjectCollectedException)underlyingException;
            }
            this.logError((Exception)((Object)e));
        }
        try {
            this.determineIfDaemonThread();
        }
        catch (DebugException e) {
            underlyingException = e.getStatus().getException();
            if (underlyingException instanceof VMDisconnectedException) {
                this.disconnected();
                return;
            }
            this.logError((Exception)((Object)e));
        }
        try {
            ThreadGroupReference group = this.getUnderlyingThreadGroup();
            if (group != null) {
                this.getJavaDebugTarget().addThreadGroup(group);
            }
        }
        catch (DebugException debugException) {}
        this.setTerminated(false);
        this.setRunning(false);
        try {
            if (this.fThread.status() == -1) {
                this.setRunning(true);
                return;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.disconnected();
            return;
        }
        catch (ObjectCollectedException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.logError(e);
        }
        try {
            this.setRunning(!this.fThread.isSuspended());
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.disconnected();
            return;
        }
        catch (ObjectCollectedException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.logError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCurrentBreakpoint(IBreakpoint bp) {
        Object object = this.breakpointAcessLock;
        synchronized (object) {
            this.fCurrentBreakpoints.add(bp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCurrentBreakpoint(IBreakpoint bp) {
        Object object = this.breakpointAcessLock;
        synchronized (object) {
            this.fCurrentBreakpoints.remove(bp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBreakpoint[] getBreakpoints() {
        Object object = this.breakpointAcessLock;
        synchronized (object) {
            return this.fCurrentBreakpoints.toArray(new IBreakpoint[this.fCurrentBreakpoints.size()]);
        }
    }

    public boolean canResume() {
        return this.isSuspended() && (!this.isPerformingEvaluation() || this.isInvokingMethod()) && !this.isSuspendVoteInProgress() || this.getDebugTarget().isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended() || this.isPerformingEvaluation() && !this.isInvokingMethod() || this.isSuspendVoteInProgress();
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean canStepInto() {
        return this.canStep();
    }

    public boolean canStepOver() {
        return this.canStep();
    }

    public boolean canStepReturn() {
        return this.canStep();
    }

    protected boolean canStep() {
        try {
            return this.isSuspended() && (!this.isPerformingEvaluation() || this.isInvokingMethod()) && !this.isSuspendVoteInProgress() && !this.isStepping() && this.getTopStackFrame() != null && !this.getJavaDebugTarget().isPerformingHotCodeReplace();
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    protected void determineIfSystemThread() throws DebugException {
        this.fIsSystemThread = false;
        ThreadGroupReference tgr = this.getUnderlyingThreadGroup();
        this.fIsSystemThread = tgr != null;
        while (tgr != null) {
            String tgn = null;
            try {
                tgn = tgr.name();
                tgr = tgr.parent();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.fIsSystemThread = false;
                break;
            }
            catch (RuntimeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_determining_if_system_thread, e.toString()), e);
                return;
            }
            if (tgn == null || !tgn.equals(MAIN_THREAD_GROUP)) continue;
            this.fIsSystemThread = false;
            break;
        }
    }

    protected void determineIfDaemonThread() throws DebugException {
        this.fIsDaemon = false;
        try {
            Value value;
            ReferenceType referenceType = this.getUnderlyingThread().referenceType();
            Field field = referenceType.fieldByName("daemon");
            if (field == null) {
                field = referenceType.fieldByName("isDaemon");
            }
            if (field != null && field.signature().equals("Z") && (value = this.getUnderlyingThread().getValue(field)) instanceof BooleanValue) {
                this.fIsDaemon = ((BooleanValue)value).booleanValue();
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(JDIDebugModelMessages.JDIThread_47, e);
        }
    }

    public synchronized IStackFrame[] getStackFrames() throws DebugException {
        List<IJavaStackFrame> list = this.computeStackFrames();
        return list.toArray(new IStackFrame[list.size()]);
    }

    protected synchronized List<IJavaStackFrame> computeStackFrames(boolean refreshChildren) throws DebugException {
        if (this.isSuspended()) {
            if (this.isTerminated()) {
                this.fStackFrames.clear();
            } else if (refreshChildren) {
                List<StackFrame> frames = this.getUnderlyingFrames();
                int oldSize = this.fStackFrames.size();
                if (oldSize > 0) {
                    ((JDIStackFrame)this.fStackFrames.get(0)).setIsTop(false);
                }
                int newSize = frames.size();
                int discard = oldSize - newSize;
                int i = 0;
                while (i < discard) {
                    JDIStackFrame invalid = (JDIStackFrame)this.fStackFrames.remove(0);
                    invalid.bind(null, -1);
                    ++i;
                }
                int newFrames = newSize - oldSize;
                int depth = oldSize;
                int i2 = newFrames - 1;
                while (i2 >= 0) {
                    this.fStackFrames.add(0, new JDIStackFrame(this, frames.get(i2), depth));
                    ++depth;
                    --i2;
                }
                int numToRebind = Math.min(newSize, oldSize);
                int offset = newSize - 1;
                depth = 0;
                while (depth < numToRebind) {
                    StackFrame frame;
                    JDIStackFrame oldFrame = (JDIStackFrame)this.fStackFrames.get(offset);
                    JDIStackFrame newFrame = oldFrame.bind(frame = frames.get(offset), depth);
                    if (newFrame != oldFrame) {
                        this.fStackFrames.set(offset, newFrame);
                    }
                    --offset;
                    ++depth;
                }
                if (newSize > 0) {
                    ((JDIStackFrame)this.fStackFrames.get(0)).setIsTop(true);
                }
            }
        } else {
            return Collections.EMPTY_LIST;
        }
        this.fRefreshChildren = false;
        return this.fStackFrames;
    }

    public synchronized List<IJavaStackFrame> computeStackFrames() throws DebugException {
        return this.computeStackFrames(this.fRefreshChildren);
    }

    public List<IJavaStackFrame> computeNewStackFrames() throws DebugException {
        return this.computeStackFrames(true);
    }

    private List<StackFrame> getUnderlyingFrames() throws DebugException {
        if (!this.isSuspended()) {
            this.requestFailed(JDIDebugModelMessages.JDIThread_Unable_to_retrieve_stack_frame___thread_not_suspended__1, null, 100);
        }
        try {
            return this.fThread.frames();
        }
        catch (IncompatibleThreadStateException e) {
            this.requestFailed(JDIDebugModelMessages.JDIThread_Unable_to_retrieve_stack_frame___thread_not_suspended__1, e, 100);
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_retrieving_stack_frames_2, e.toString()), e);
        }
        catch (InternalError e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_retrieving_stack_frames_2, e.toString()), e);
        }
        return null;
    }

    protected int getUnderlyingFrameCount() throws DebugException {
        try {
            return this.fThread.frameCount();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_retrieving_frame_count, e.toString()), e);
        }
        catch (IncompatibleThreadStateException e) {
            this.requestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_retrieving_frame_count, e.toString()), e, 100);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void runEvaluation(IEvaluationRunnable evaluation, IProgressMonitor monitor, int evaluationDetail, boolean hitBreakpoints) throws DebugException {
        block31: {
            block32: {
                if (this.isPerformingEvaluation()) {
                    this.requestFailed(JDIDebugModelMessages.JDIThread_Cannot_perform_nested_evaluations, null, 101);
                }
                if (!this.canRunEvaluation()) {
                    this.requestFailed(JDIDebugModelMessages.JDIThread_Evaluation_failed___thread_not_suspended, null, 100);
                }
                var5_5 = this.fEvaluationLock;
                synchronized (var5_5) {
                    this.fEvaluationRunnable = evaluation;
                    this.fHonorBreakpoints = hitBreakpoints;
                }
                quiet = this.isSuspendVoteInProgress();
                if (quiet) {
                    this.fireEvent(new DebugEvent((Object)this, 32, 500));
                } else {
                    this.fireResumeEvent(evaluationDetail);
                }
                breakpoints = this.getBreakpoints();
                rule = null;
                if (evaluationDetail == 128) {
                    rule = this.getThreadRule();
                }
                try {
                    if (rule != null) {
                        Job.getJobManager().beginRule(rule, monitor);
                    }
                    if (monitor == null || !monitor.isCanceled()) {
                        evaluation.run(this, monitor);
                    }
                    break block31;
                }
                catch (Throwable var9_10) {
                    if (rule != null) {
                        Job.getJobManager().endRule(rule);
                    }
                    var10_11 = this.fEvaluationLock;
                    synchronized (var10_11) {
                        this.fEvaluationRunnable = null;
                        this.fHonorBreakpoints = true;
                        this.fEvaluationLock.notifyAll();
                    }
                    if (this.getBreakpoints().length != 0 || breakpoints.length <= 0) break block32;
                    var13_13 = breakpoints;
                    var12_15 = breakpoints.length;
                    var11_17 = 0;
                    ** while (var11_17 < var12_15)
                }
lbl-1000:
                // 1 sources

                {
                    breakpoint = var13_13[var11_17];
                    this.addCurrentBreakpoint(breakpoint);
                    ++var11_17;
                    continue;
                }
            }
            if (quiet) {
                this.fireEvent(new DebugEvent((Object)this, 32, 501));
            } else {
                this.fireSuspendEvent(evaluationDetail);
            }
            if (this.fEvaluationInterrupted && this.fAsyncJob.isEmpty() && !this.fRunningAsyncJob) {
                this.fEvaluationInterrupted = false;
                this.fireChangeEvent(512);
            }
            throw var9_10;
        }
        if (rule != null) {
            Job.getJobManager().endRule(rule);
        }
        breakpoint = this.fEvaluationLock;
        synchronized (breakpoint) {
            this.fEvaluationRunnable = null;
            this.fHonorBreakpoints = true;
            this.fEvaluationLock.notifyAll();
        }
        if (this.getBreakpoints().length == 0 && breakpoints.length > 0) {
            var13_14 = breakpoints;
            var12_16 = breakpoints.length;
            var11_18 = 0;
            while (var11_18 < var12_16) {
                breakpoint = var13_14[var11_18];
                this.addCurrentBreakpoint((IBreakpoint)breakpoint);
                ++var11_18;
            }
        }
        if (quiet) {
            this.fireEvent(new DebugEvent((Object)this, 32, 501));
        } else {
            this.fireSuspendEvent(evaluationDetail);
        }
        if (this.fEvaluationInterrupted && this.fAsyncJob.isEmpty() && !this.fRunningAsyncJob) {
            this.fEvaluationInterrupted = false;
            this.fireChangeEvent(512);
        }
    }

    protected boolean canRunEvaluation() {
        try {
            return this.isSuspended() && !this.isPerformingEvaluation() && !this.isInvokingMethod() && this.getTopStackFrame() != null && !this.getJavaDebugTarget().isPerformingHotCodeReplace();
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    @Override
    public void queueRunnable(Runnable evaluation) {
        this.fAsyncJob.addRunnable(evaluation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateEvaluation() throws DebugException {
        Object object = this.fEvaluationLock;
        synchronized (object) {
            if (this.canTerminateEvaluation()) {
                this.fEvaluationInterrupted = true;
                ((ITerminate)this.fEvaluationRunnable).terminate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canTerminateEvaluation() {
        Object object = this.fEvaluationLock;
        synchronized (object) {
            return this.fEvaluationRunnable instanceof ITerminate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Value invokeMethod(ClassType receiverClass, ObjectReference receiverObject, Method method, List<? extends Value> args, boolean invokeNonvirtual) throws DebugException {
        if (receiverClass != null && receiverObject != null) {
            throw new IllegalArgumentException(JDIDebugModelMessages.JDIThread_can_only_specify_one_receiver_for_a_method_invocation);
        }
        Value result = null;
        int timeout = this.getRequestTimeout();
        try {
            JDIThread jDIThread = this;
            synchronized (jDIThread) {
                if (!this.isSuspended()) {
                    this.requestFailed(JDIDebugModelMessages.JDIThread_Evaluation_failed___thread_not_suspended, null, 100);
                }
                if (this.isInvokingMethod()) {
                    this.requestFailed(JDIDebugModelMessages.JDIThread_Cannot_perform_nested_evaluations, null, 101);
                }
                this.setRequestTimeout(Integer.MAX_VALUE);
                this.setRunning(true);
                this.setInvokingMethod(true);
            }
            this.preserveStackFrames();
            int flags = 1;
            if (invokeNonvirtual) {
                flags |= 2;
            }
            result = receiverClass == null ? receiverObject.invokeMethod(this.fThread, method, args, flags) : receiverClass.invokeMethod(this.fThread, method, args, flags);
        }
        catch (InvalidTypeException e) {
            this.invokeFailed(e, timeout);
        }
        catch (ClassNotLoadedException e) {
            this.invokeFailed(e, timeout);
        }
        catch (IncompatibleThreadStateException e) {
            this.invokeFailed(JDIDebugModelMessages.JDIThread_Thread_must_be_suspended_by_step_or_breakpoint_to_perform_method_invocation_1, 102, e, timeout);
        }
        catch (InvocationException e) {
            this.invokeFailed(e, timeout);
        }
        catch (RuntimeException e) {
            this.invokeFailed(e, timeout);
        }
        this.invokeComplete(timeout);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Value invokeMethod(InterfaceType receiverInterface, Method method, List<? extends Value> args) throws DebugException {
        Value result = null;
        int timeout = this.getRequestTimeout();
        try {
            JDIThread jDIThread = this;
            synchronized (jDIThread) {
                if (!this.isSuspended()) {
                    this.requestFailed(JDIDebugModelMessages.JDIThread_Evaluation_failed___thread_not_suspended, null, 100);
                }
                if (this.isInvokingMethod()) {
                    this.requestFailed(JDIDebugModelMessages.JDIThread_Cannot_perform_nested_evaluations, null, 101);
                }
                this.setRequestTimeout(Integer.MAX_VALUE);
                this.setRunning(true);
                this.setInvokingMethod(true);
            }
            this.preserveStackFrames();
            int flags = 1;
            result = receiverInterface.invokeMethod(this.fThread, method, args, flags);
        }
        catch (InvalidTypeException e) {
            this.invokeFailed(e, timeout);
        }
        catch (ClassNotLoadedException e) {
            this.invokeFailed(e, timeout);
        }
        catch (IncompatibleThreadStateException e) {
            this.invokeFailed(JDIDebugModelMessages.JDIThread_Thread_must_be_suspended_by_step_or_breakpoint_to_perform_method_invocation_1, 102, e, timeout);
        }
        catch (InvocationException e) {
            this.invokeFailed(e, timeout);
        }
        catch (RuntimeException e) {
            this.invokeFailed(e, timeout);
        }
        this.invokeComplete(timeout);
        return result;
    }

    protected ObjectReference newInstance(ClassType receiverClass, Method constructor, List<? extends Value> args) throws DebugException {
        if (this.isInvokingMethod()) {
            this.requestFailed(JDIDebugModelMessages.JDIThread_Cannot_perform_nested_evaluations_2, null);
        }
        ObjectReference result = null;
        int timeout = this.getRequestTimeout();
        try {
            this.setRequestTimeout(Integer.MAX_VALUE);
            this.setRunning(true);
            this.setInvokingMethod(true);
            this.preserveStackFrames();
            result = receiverClass.newInstance(this.fThread, constructor, args, 1);
        }
        catch (InvalidTypeException e) {
            this.invokeFailed(e, timeout);
        }
        catch (ClassNotLoadedException e) {
            this.invokeFailed(e, timeout);
        }
        catch (IncompatibleThreadStateException e) {
            this.invokeFailed(e, timeout);
        }
        catch (InvocationException e) {
            this.invokeFailed(e, timeout);
        }
        catch (RuntimeException e) {
            this.invokeFailed(e, timeout);
        }
        this.invokeComplete(timeout);
        return result;
    }

    protected void invokeFailed(Throwable e, int restoreTimeout) throws DebugException {
        this.invokeFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_invoking_method, e.toString()), 5010, e, restoreTimeout);
    }

    protected void invokeFailed(String message, int code, Throwable e, int restoreTimeout) throws DebugException {
        this.invokeComplete(restoreTimeout);
        this.requestFailed(message, e, code);
    }

    protected synchronized void invokeComplete(int restoreTimeout) {
        this.setInvokingMethod(false);
        this.setRunning(false);
        this.setRequestTimeout(restoreTimeout);
        try {
            this.computeStackFrames();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
    }

    public String getName() throws DebugException {
        try {
            this.fPreviousName = this.fThread.name();
        }
        catch (RuntimeException e) {
            if (e instanceof ObjectCollectedException) {
                if (this.fPreviousName == null) {
                    this.fPreviousName = JDIDebugModelMessages.JDIThread_garbage_collected_1;
                }
            }
            if (e instanceof VMDisconnectedException) {
                if (this.fPreviousName == null) {
                    this.fPreviousName = JDIDebugModelMessages.JDIThread_42;
                }
            }
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_retrieving_thread_name, e.toString()), e);
        }
        return this.fPreviousName;
    }

    public int getPriority() throws DebugException {
        Field p = null;
        try {
            Value v;
            p = this.fThread.referenceType().fieldByName("priority");
            if (p == null) {
                this.requestFailed(JDIDebugModelMessages.JDIThread_no_priority_field, null);
            }
            if ((v = this.fThread.getValue(p)) instanceof IntegerValue) {
                return ((IntegerValue)v).value();
            }
            this.requestFailed(JDIDebugModelMessages.JDIThread_priority_not_an_integer, null);
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_retrieving_thread_priority, e.toString()), e);
        }
        return -1;
    }

    public synchronized IStackFrame getTopStackFrame() throws DebugException {
        List<IJavaStackFrame> c = this.computeStackFrames();
        if (c.isEmpty()) {
            return null;
        }
        return c.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleSuspendForBreakpoint(JavaBreakpoint breakpoint, boolean suspendVote) {
        JavaLineBreakpoint lbp;
        int policy = 2;
        JDIThread jDIThread = this;
        synchronized (jDIThread) {
            block31: {
                if (!this.fClientSuspendRequest) break block31;
                return true;
            }
            this.fSuspendVoteInProgress = true;
            this.addCurrentBreakpoint(breakpoint);
            try {
                policy = breakpoint.getSuspendPolicy();
            }
            catch (CoreException e) {
                this.logError((Exception)((Object)e));
                this.setRunning(true);
                return false;
            }
            if (policy == 1) {
                ((JDIDebugTarget)this.getDebugTarget()).prepareToSuspendByBreakpoint(breakpoint);
            } else {
                this.setRunning(false);
            }
        }
        try {
            if (!breakpoint.isTriggerPoint() && DebugPlugin.getDefault().getBreakpointManager().hasActiveTriggerPoints()) {
                this.fSuspendVoteInProgress = false;
                return false;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (breakpoint instanceof JavaLineBreakpoint && (lbp = (JavaLineBreakpoint)breakpoint).hasCondition() && !this.isPerformingEvaluation()) {
            ConditionalBreakpointHandler handler = new ConditionalBreakpointHandler();
            int vote = handler.breakpointHit(this, breakpoint);
            if (vote == 2) {
                JDIThread jDIThread2 = this;
                synchronized (jDIThread2) {
                    this.fSuspendVoteInProgress = false;
                    return false;
                }
            }
            if (handler.hasErrors()) {
                JDIThread jDIThread3 = this;
                synchronized (jDIThread3) {
                    this.fSuspendVoteInProgress = false;
                    return true;
                }
            }
            DebugPlugin.getDefault().getBreakpointManager().enableTriggerPoints(null, false);
        }
        boolean suspend = true;
        try {
            suspend = JDIDebugPlugin.getDefault().fireBreakpointHit(this, breakpoint);
        }
        catch (Throwable throwable) {
            JDIThread jDIThread4 = this;
            synchronized (jDIThread4) {
                this.fSuspendVoteInProgress = false;
                if (this.fClientSuspendRequest) {
                    suspend = true;
                }
            }
            throw throwable;
        }
        JDIThread jDIThread5 = this;
        synchronized (jDIThread5) {
            this.fSuspendVoteInProgress = false;
            if (this.fClientSuspendRequest) {
                suspend = true;
            }
        }
        return suspend;
    }

    public IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy shouldSkipExceptionRecurrence(IJavaExceptionBreakpoint breakpoint) {
        if (breakpoint instanceof JavaExceptionBreakpoint) {
            JavaExceptionBreakpoint exceptionBreakpoint = (JavaExceptionBreakpoint)breakpoint;
            try {
                IJavaObject lastException = exceptionBreakpoint.getLastException();
                IJavaObject previousException = this.fPreviousException;
                if (previousException != null && previousException.equals(lastException)) {
                    return exceptionBreakpoint.getSuspendOnRecurrenceStrategy();
                }
                this.fPreviousException = lastException;
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeBreakpointHandling(JavaBreakpoint breakpoint, boolean suspend, boolean queue, EventSet set) {
        JDIThread jDIThread = this;
        synchronized (jDIThread) {
            try {
                int policy = breakpoint.getSuspendPolicy();
                if (suspend) {
                    if (policy == 1) {
                        ((JDIDebugTarget)this.getDebugTarget()).suspendedByBreakpoint(breakpoint, false, set);
                    }
                    this.abortStep();
                    if (queue) {
                        this.queueSuspendEvent(16, set);
                    } else {
                        this.fireSuspendEvent(16);
                    }
                } else if (policy == 1) {
                    ((JDIDebugTarget)this.getDebugTarget()).cancelSuspendByBreakpoint(breakpoint);
                } else {
                    this.setRunning(true);
                    this.preserveStackFrames();
                }
            }
            catch (CoreException e) {
                this.logError((Exception)((Object)e));
                this.setRunning(true);
            }
        }
    }

    public boolean isStepping() {
        return this.getPendingStepHandler() != null;
    }

    public boolean isSuspended() {
        return !this.fRunning && !this.fTerminated;
    }

    @Override
    public boolean isSystemThread() {
        return this.fIsSystemThread;
    }

    @Override
    public boolean isDaemon() throws DebugException {
        return this.fIsDaemon;
    }

    @Override
    public String getThreadGroupName() throws DebugException {
        if (this.fThreadGroupName == null) {
            ThreadGroupReference tgr = this.getUnderlyingThreadGroup();
            if (tgr == null) {
                return null;
            }
            try {
                this.fThreadGroupName = tgr.name();
            }
            catch (RuntimeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_retrieving_thread_group_name, e.toString()), e);
                return null;
            }
        }
        return this.fThreadGroupName;
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    @Override
    public synchronized boolean isOutOfSynch() throws DebugException {
        if (this.isSuspended() && ((JDIDebugTarget)this.getDebugTarget()).hasHCRFailed()) {
            List<IJavaStackFrame> frames = this.computeStackFrames();
            for (IJavaStackFrame frame : frames) {
                if (!((JDIStackFrame)frame).isOutOfSynch()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean mayBeOutOfSynch() {
        if (!this.isSuspended()) {
            return ((JDIDebugTarget)this.getDebugTarget()).hasHCRFailed();
        }
        return false;
    }

    protected void setTerminated(boolean terminated) {
        this.fTerminated = terminated;
    }

    public synchronized void resume() throws DebugException {
        if (!this.isSuspended() && this.getDebugTarget().isSuspended()) {
            this.getDebugTarget().resume();
        } else {
            this.fClientSuspendRequest = false;
            this.resumeThread(true);
        }
    }

    private synchronized void resumeThread(boolean fireNotification) throws DebugException {
        if (!this.isSuspended() || this.isPerformingEvaluation() && !this.isInvokingMethod()) {
            return;
        }
        try {
            this.setRunning(true);
            this.clearMethodResult();
            if (fireNotification) {
                this.fireResumeEvent(32);
            }
            this.preserveStackFrames();
            this.fThread.resume();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.disconnected();
        }
        catch (RuntimeException e) {
            this.setRunning(false);
            this.fireSuspendEvent(32);
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_resuming, e.toString()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRunning(boolean running) {
        this.fRunning = running;
        if (running) {
            Object object = this.breakpointAcessLock;
            synchronized (object) {
                this.fCurrentBreakpoints.clear();
            }
        }
    }

    private void clearMethodResult() {
        this.setMethodResult(null);
    }

    protected synchronized void preserveStackFrames() {
        this.fRefreshChildren = true;
        for (IJavaStackFrame frame : this.fStackFrames) {
            ((JDIStackFrame)frame).setUnderlyingStackFrame(null);
        }
    }

    protected synchronized void disposeStackFrames() {
        this.fStackFrames.clear();
        this.fRefreshChildren = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepInto() throws DebugException {
        JDIThread jDIThread = this;
        synchronized (jDIThread) {
            if (!this.canStepInto()) {
                return;
            }
        }
        StepIntoHandler handler = this.createStepIntoHandler();
        handler.step();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepOver() throws DebugException {
        JDIThread jDIThread = this;
        synchronized (jDIThread) {
            if (!this.canStepOver()) {
                return;
            }
        }
        StepOverHandler handler = this.createStepOverHandler();
        handler.step();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepReturn() throws DebugException {
        JDIThread jDIThread = this;
        synchronized (jDIThread) {
            if (!this.canStepReturn()) {
                return;
            }
        }
        StepReturnHandler handler = this.createStepReturnHandler();
        handler.step();
    }

    protected void setOriginalStepKind(int stepKind) {
        this.fOriginalStepKind = stepKind;
    }

    protected int getOriginalStepKind() {
        return this.fOriginalStepKind;
    }

    protected void setOriginalStepLocation(Location location) {
        this.fOriginalStepLocation = location;
    }

    protected Location getOriginalStepLocation() {
        return this.fOriginalStepLocation;
    }

    protected void setOriginalStepStackDepth(int depth) {
        this.fOriginalStepStackDepth = depth;
    }

    protected int getOriginalStepStackDepth() {
        return this.fOriginalStepStackDepth;
    }

    protected boolean shouldDoExtraStepInto(Location location) throws DebugException {
        Method currMethod;
        if (this.getOriginalStepKind() != 1) {
            return false;
        }
        if (this.getOriginalStepStackDepth() != this.getUnderlyingFrameCount()) {
            return false;
        }
        Location origLocation = this.getOriginalStepLocation();
        if (origLocation == null) {
            return false;
        }
        Method origMethod = origLocation.method();
        if (!origMethod.equals(currMethod = location.method())) {
            return false;
        }
        return origLocation.lineNumber() == location.lineNumber();
    }

    protected boolean shouldDoStepReturn() throws DebugException {
        return this.getOriginalStepKind() == 1 && this.getOriginalStepStackDepth() + 1 < this.getUnderlyingFrameCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws DebugException {
        this.prepareForClientSuspend();
        JDIThread jDIThread = this;
        synchronized (jDIThread) {
            try {
                this.abortStep();
                this.suspendUnderlyingThread();
            }
            catch (RuntimeException e) {
                this.fClientSuspendRequest = false;
                this.setRunning(true);
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_suspending, e.toString()), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareForClientSuspend() throws DebugException {
        int timeout;
        Object object = this;
        synchronized (object) {
            this.fClientSuspendRequest = true;
        }
        object = this.fEvaluationLock;
        synchronized (object) {
            if (this.fEvaluationRunnable != null) {
                if (this.canTerminateEvaluation()) {
                    this.fEvaluationInterrupted = true;
                    ((ITerminate)this.fEvaluationRunnable).terminate();
                }
                timeout = Platform.getPreferencesService().getInt(JDIDebugPlugin.getUniqueIdentifier(), JDIDebugModel.PREF_REQUEST_TIMEOUT, 3000, null);
                try {
                    this.fEvaluationLock.wait(timeout);
                }
                catch (InterruptedException interruptedException) {}
                if (this.fEvaluationRunnable != null) {
                    this.fClientSuspendRequest = false;
                    this.targetRequestFailed(JDIDebugModelMessages.JDIThread_1, null);
                }
            }
        }
        object = this.fInvocationLock;
        synchronized (object) {
            if (this.isInvokingMethod()) {
                timeout = Platform.getPreferencesService().getInt(JDIDebugPlugin.getUniqueIdentifier(), JDIDebugModel.PREF_REQUEST_TIMEOUT, 3000, null);
                try {
                    this.fInvocationLock.wait(timeout);
                }
                catch (InterruptedException interruptedException) {}
                if (this.isInvokingMethod()) {
                    this.fClientSuspendRequest = false;
                    this.targetRequestFailed(JDIDebugModelMessages.JDIThread_1, null);
                }
            }
        }
    }

    protected synchronized void suspendUnderlyingThread() {
        if (this.fIsSuspending) {
            return;
        }
        if (this.isSuspended()) {
            this.fireSuspendEvent(32);
            return;
        }
        this.fIsSuspending = true;
        Thread thread = new Thread(() -> {
            try {
                try {
                    this.fThread.suspend();
                    int timeout = Platform.getPreferencesService().getInt(JDIDebugPlugin.getUniqueIdentifier(), JDIDebugModel.PREF_REQUEST_TIMEOUT, 3000, null);
                    long stop = System.currentTimeMillis() + (long)timeout;
                    boolean suspended = this.isUnderlyingThreadSuspended();
                    while (System.currentTimeMillis() < stop && !suspended) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                        suspended = this.isUnderlyingThreadSuspended();
                        if (suspended) break;
                    }
                    if (!suspended) {
                        Status status = new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 161, MessageFormat.format(JDIDebugModelMessages.JDIThread_suspend_timeout, timeout), null);
                        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                        if (handler != null) {
                            try {
                                handler.handleStatus((IStatus)status, (Object)this);
                            }
                            catch (CoreException coreException) {}
                        }
                    }
                    this.setRunning(false);
                    this.fireSuspendEvent(32);
                }
                catch (RuntimeException runtimeException) {
                    this.fIsSuspending = false;
                }
            }
            finally {
                this.fIsSuspending = false;
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public boolean isUnderlyingThreadSuspended() {
        return this.fThread.isSuspended();
    }

    protected synchronized void suspendedByVM() {
        this.setRunning(false);
    }

    protected synchronized void resumedByVM() throws DebugException {
        this.fClientSuspendRequest = false;
        this.setRunning(true);
        this.clearMethodResult();
        this.preserveStackFrames();
        com.sun.jdi.ThreadReference thread = this.fThread;
        try {
            while (thread.suspendCount() > 1) {
                thread.resume();
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.disconnected();
        }
        catch (RuntimeException e) {
            this.setRunning(false);
            this.fireSuspendEvent(32);
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_resuming, e.toString()), e);
        }
    }

    public void terminate() throws DebugException {
        this.terminateEvaluation();
        this.getDebugTarget().terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropToFrame(IStackFrame frame) throws DebugException {
        JDIDebugTarget target = (JDIDebugTarget)this.getDebugTarget();
        if (target.canPopFrames()) {
            try {
                this.popFrame(frame);
                this.stepInto();
            }
            catch (RuntimeException exception) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_dropping_to_frame, exception.toString()), exception);
            }
        } else {
            JDIThread jDIThread = this;
            synchronized (jDIThread) {
                DropToFrameHandler handler = this.createDropToFrameHandler(frame);
                handler.step();
            }
        }
    }

    protected void popFrame(IStackFrame frame) throws DebugException {
        JDIDebugTarget target = (JDIDebugTarget)this.getDebugTarget();
        if (target.canPopFrames()) {
            try {
                StackFrame jdiFrame = null;
                int desiredSize = this.fStackFrames.size() - this.fStackFrames.indexOf(frame) - 1;
                int lastSize = this.fStackFrames.size() + 1;
                int size = this.fStackFrames.size();
                while (size < lastSize && size > desiredSize) {
                    jdiFrame = ((JDIStackFrame)frame).getUnderlyingStackFrame();
                    this.preserveStackFrames();
                    this.fThread.popFrames(jdiFrame);
                    lastSize = size;
                    size = this.computeStackFrames().size();
                }
            }
            catch (IncompatibleThreadStateException exception) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_popping, exception.toString()), exception);
            }
            catch (InvalidStackFrameException exception) {
                this.fireChangeEvent(512);
                this.targetRequestFailed(exception.toString(), exception);
            }
            catch (RuntimeException exception) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_popping, exception.toString()), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stepToFrame(IStackFrame frame) throws DebugException {
        JDIThread jDIThread = this;
        synchronized (jDIThread) {
            if (!this.canStepReturn()) {
                return;
            }
        }
        StepToFrameHandler handler = this.createStepToFrameHandler(frame);
        handler.step();
    }

    protected void abortStep() {
        StepHandler handler = this.getPendingStepHandler();
        if (handler != null) {
            handler.abort();
        }
    }

    @Override
    public IJavaVariable findVariable(String varName) throws DebugException {
        block5: {
            if (this.isSuspended()) {
                try {
                    IStackFrame[] stackFrames;
                    IStackFrame[] iStackFrameArray = stackFrames = this.getStackFrames();
                    int n = stackFrames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStackFrame stackFrame = iStackFrameArray[n2];
                        IJavaStackFrame sf = (IJavaStackFrame)stackFrame;
                        IJavaVariable var = sf.findVariable(varName);
                        if (var != null) {
                            return var;
                        }
                        ++n2;
                    }
                }
                catch (DebugException e) {
                    if (e.getStatus().getCode() == 100) break block5;
                    throw e;
                }
            }
        }
        return null;
    }

    protected void terminated() {
        this.setTerminated(true);
        this.setRunning(false);
        this.fireTerminateEvent();
    }

    public com.sun.jdi.ThreadReference getUnderlyingThread() {
        return this.fThread;
    }

    protected void setUnderlyingThread(com.sun.jdi.ThreadReference thread) {
        this.fThread = thread;
    }

    protected ThreadGroupReference getUnderlyingThreadGroup() throws DebugException {
        if (this.fThreadGroup == null) {
            try {
                this.fThreadGroup = this.fThread.threadGroup();
            }
            catch (UnsupportedOperationException e) {
                this.requestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_retrieving_thread_group, e.toString()), e);
                return null;
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                return null;
            }
            catch (ObjectCollectedException objectCollectedException) {
                return null;
            }
            catch (RuntimeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_retrieving_thread_group, e.toString()), e);
                return null;
            }
        }
        return this.fThreadGroup;
    }

    @Override
    public boolean isPerformingEvaluation() {
        return this.fEvaluationRunnable != null;
    }

    public boolean isInvokingMethod() {
        return this.fIsInvokingMethod;
    }

    public boolean isIgnoringBreakpoints() {
        return !this.fHonorBreakpoints || this.fSuspendVoteInProgress || this.hasClientRequestedSuspend();
    }

    public boolean hasClientRequestedSuspend() {
        return this.fClientSuspendRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInvokingMethod(boolean invoking) {
        Object object = this.fInvocationLock;
        synchronized (object) {
            this.fIsInvokingMethod = invoking;
            if (!invoking) {
                this.fInvocationLock.notifyAll();
            }
        }
    }

    protected void setPendingStepHandler(StepHandler handler) {
        this.fStepHandler = handler;
    }

    protected StepHandler getPendingStepHandler() {
        return this.fStepHandler;
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IJavaThread.class) {
            return adapter.cast(this);
        }
        if (adapter == IJavaStackFrame.class) {
            try {
                return adapter.cast(this.getTopStackFrame());
            }
            catch (DebugException debugException) {}
        }
        return super.getAdapter(adapter);
    }

    @Override
    public boolean hasOwnedMonitors() throws DebugException {
        return this.isSuspended() && this.getOwnedMonitors().length > 0;
    }

    @Override
    public IJavaObject[] getOwnedMonitors() throws DebugException {
        try {
            JDIDebugTarget target = (JDIDebugTarget)this.getDebugTarget();
            List<ObjectReference> ownedMonitors = this.fThread.ownedMonitors();
            IJavaObject[] javaOwnedMonitors = new IJavaObject[ownedMonitors.size()];
            Iterator<ObjectReference> itr = ownedMonitors.iterator();
            int i = 0;
            while (itr.hasNext()) {
                ObjectReference element = itr.next();
                javaOwnedMonitors[i] = new JDIObjectValue(target, element);
                ++i;
            }
            return javaOwnedMonitors;
        }
        catch (IncompatibleThreadStateException e) {
            this.targetRequestFailed(JDIDebugModelMessages.JDIThread_43, e);
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(JDIDebugModelMessages.JDIThread_44, e);
        }
        return null;
    }

    @Override
    public IJavaObject getContendedMonitor() throws DebugException {
        try {
            ObjectReference monitor = this.fThread.currentContendedMonitor();
            if (monitor != null) {
                return new JDIObjectValue((JDIDebugTarget)this.getDebugTarget(), monitor);
            }
        }
        catch (IncompatibleThreadStateException e) {
            this.targetRequestFailed(JDIDebugModelMessages.JDIThread_45, e);
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(JDIDebugModelMessages.JDIThread_46, e);
        }
        return null;
    }

    public boolean canStepWithFilters() {
        if (this.canStepInto()) {
            String[] filters = this.getJavaDebugTarget().getStepFilters();
            return filters != null && filters.length > 0;
        }
        return false;
    }

    public void stepWithFilters() throws DebugException {
        if (!this.canStepWithFilters()) {
            return;
        }
        this.stepInto();
    }

    @Override
    public void stop(IJavaObject exception) throws DebugException {
        try {
            this.fThread.stop(((JDIObjectValue)exception).getUnderlyingObject());
        }
        catch (InvalidTypeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_stoping_thread, e.toString()), e);
        }
    }

    @Override
    public IJavaThreadGroup getThreadGroup() throws DebugException {
        ThreadGroupReference group = this.getUnderlyingThreadGroup();
        if (group != null) {
            return this.getJavaDebugTarget().findThreadGroup(group);
        }
        return null;
    }

    @Override
    public int getFrameCount() throws DebugException {
        return this.getUnderlyingFrameCount();
    }

    protected void forceReturn(IJavaValue value) throws DebugException {
        if (!this.isSuspended()) {
            return;
        }
        try {
            this.fThread.forceEarlyReturn(((JDIValue)value).getUnderlyingValue());
            this.stepReturn();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.disconnected();
        }
        catch (InvalidTypeException e) {
            this.targetRequestFailed(JDIDebugModelMessages.JDIThread_48, e);
        }
        catch (ClassNotLoadedException e) {
            this.targetRequestFailed(JDIDebugModelMessages.JDIThread_48, e);
        }
        catch (IncompatibleThreadStateException e) {
            this.targetRequestFailed(JDIDebugModelMessages.JDIThread_48, e);
        }
        catch (UnsupportedOperationException e) {
            this.requestFailed(JDIDebugModelMessages.JDIThread_48, e);
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(JDIDebugModelMessages.JDIThread_48, e);
        }
    }

    public ISchedulingRule getThreadRule() {
        return new SerialPerObjectRule(this);
    }

    public synchronized void resumedFromClassPrepare() {
        if (this.isSuspended()) {
            this.setRunning(true);
            this.fireResumeEvent(32);
        }
    }

    public boolean isSuspendVoteInProgress() {
        return this.fSuspendVoteInProgress;
    }

    @Override
    public IJavaObject getThreadObject() throws DebugException {
        return (IJavaObject)((Object)JDIValue.createValue(this.getJavaDebugTarget(), this.fThread));
    }

    protected StepIntoHandler createStepIntoHandler() {
        return new StepIntoHandler();
    }

    protected StepOverHandler createStepOverHandler() {
        return new StepOverHandler();
    }

    protected StepReturnHandler createStepReturnHandler() {
        return new StepReturnHandler();
    }

    protected StepToFrameHandler createStepToFrameHandler(IStackFrame stackFrame) throws DebugException {
        return new StepToFrameHandler(stackFrame);
    }

    protected DropToFrameHandler createDropToFrameHandler(IStackFrame stackFrame) throws DebugException {
        return new DropToFrameHandler(stackFrame);
    }

    public static boolean showStepResultIsEnabled(IDebugTarget debugTarget) {
        if (debugTarget == null || debugTarget.getProcess() == null) {
            return Platform.getPreferencesService().getBoolean(JDIDebugPlugin.getUniqueIdentifier(), JDIDebugModel.PREF_SHOW_STEP_RESULT_REMOTE, false, null);
        }
        return Platform.getPreferencesService().getBoolean(JDIDebugPlugin.getUniqueIdentifier(), JDIDebugModel.PREF_SHOW_STEP_RESULT, true, null);
    }

    public static int getStepResultTimeout() {
        return Platform.getPreferencesService().getInt(JDIDebugPlugin.getUniqueIdentifier(), JDIDebugModel.PREF_SHOW_STEP_TIMEOUT, 7000, null);
    }

    protected boolean isSupported(Location currentLocation) {
        if (currentLocation == null) {
            return false;
        }
        return JAVA_STRATUM_CONSTANT.equals(currentLocation.declaringType().defaultStratum());
    }

    public MethodResult getMethodResult() {
        return this.fMethodResult;
    }

    public void setMethodResult(MethodResult fMethodResult) {
        this.fMethodResult = fMethodResult;
    }

    protected class DropToFrameHandler
    extends StepReturnHandler {
        private int fFramesToDrop;

        protected DropToFrameHandler(IStackFrame frame) throws DebugException {
            List<IJavaStackFrame> frames = JDIThread.this.computeStackFrames();
            this.setFramesToDrop(frames.indexOf(frame));
        }

        protected void setFramesToDrop(int num) {
            this.fFramesToDrop = num;
        }

        protected int getFramesToDrop() {
            return this.fFramesToDrop;
        }

        @Override
        protected void invokeThread() throws DebugException {
            if (this.getFramesToDrop() < 0) {
                super.invokeThread();
            } else {
                try {
                    ThreadReference hcrThread = (ThreadReference)((Object)JDIThread.this.fThread);
                    hcrThread.doReturn(null, true);
                }
                catch (RuntimeException e) {
                    this.stepEnd(null);
                    JDIThread.this.fireSuspendEvent(8);
                    JDIThread.this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_while_popping_stack_frame, e.toString()), e);
                }
            }
        }

        @Override
        public boolean handleEvent(Event event, JDIDebugTarget target, boolean suspendVote, EventSet eventSet) {
            this.setFramesToDrop(this.getFramesToDrop() - 1);
            try {
                if (this.getFramesToDrop() >= -1) {
                    this.deleteStepRequest();
                    this.doSecondaryStep();
                } else {
                    this.stepEnd(eventSet);
                }
            }
            catch (DebugException e) {
                this.stepEnd(eventSet);
                JDIThread.this.logError((Exception)((Object)e));
            }
            return false;
        }

        protected void doSecondaryStep() throws DebugException {
            this.setStepRequest(this.createStepRequest());
            JDIThread.this.setPendingStepHandler(this);
            JDIThread.this.addJDIEventListener(this, this.getStepRequest());
            this.invokeThread();
        }

        @Override
        protected StepRequest createStepRequest() throws DebugException {
            int num;
            com.sun.jdi.request.EventRequestManager manager = JDIThread.this.getEventRequestManager();
            if (manager == null) {
                JDIThread.this.requestFailed(JDIDebugModelMessages.JDIThread_Unable_to_create_step_request___VM_disconnected__2, new VMDisconnectedException());
            }
            if ((num = this.getFramesToDrop()) > 0) {
                return super.createStepRequest();
            }
            if (num == 0) {
                try {
                    ReenterStepRequest request = ((EventRequestManager)((Object)manager)).createReenterStepRequest(JDIThread.this.fThread);
                    request.setSuspendPolicy(1);
                    request.addCountFilter(1);
                    request.enable();
                    return request;
                }
                catch (RuntimeException e) {
                    JDIThread.this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_creating_step_request, e.toString()), e);
                }
            } else if (num == -1) {
                try {
                    StepRequest request = manager.createStepRequest(JDIThread.this.fThread, -2, 1);
                    request.setSuspendPolicy(1);
                    request.addCountFilter(1);
                    request.enable();
                    return request;
                }
                catch (RuntimeException e) {
                    JDIThread.this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_creating_step_request, e.toString()), e);
                }
            }
            return null;
        }
    }

    static class SerialPerObjectRule
    implements ISchedulingRule {
        private Object fObject = null;

        public SerialPerObjectRule(Object lock) {
            this.fObject = lock;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof SerialPerObjectRule) {
                SerialPerObjectRule vup = (SerialPerObjectRule)rule;
                return this.fObject == vup.fObject;
            }
            return false;
        }
    }

    abstract class StepHandler
    implements IJDIEventListener {
        private StepRequest fStepRequest;

        StepHandler() {
        }

        protected void step() throws DebugException {
            ISchedulingRule rule = JDIThread.this.getThreadRule();
            try {
                Job.getJobManager().beginRule(rule, null);
                JDIStackFrame top = (JDIStackFrame)JDIThread.this.getTopStackFrame();
                if (top == null) {
                    return;
                }
                JDIThread.this.setOriginalStepKind(this.getStepKind());
                StackFrame frame = top.getUnderlyingStackFrame();
                if (frame == null) {
                    return;
                }
                Location location = frame.location();
                JDIThread.this.setOriginalStepLocation(location);
                JDIThread.this.setOriginalStepStackDepth(JDIThread.this.computeStackFrames().size());
                this.setStepRequest(this.createStepRequest());
                JDIThread.this.setPendingStepHandler(this);
                JDIThread.this.addJDIEventListener(this, this.getStepRequest());
                JDIThread.this.setRunning(true);
                JDIThread.this.clearMethodResult();
                JDIThread.this.preserveStackFrames();
                JDIThread.this.fireResumeEvent(this.getStepDetail());
                this.invokeThread();
            }
            finally {
                Job.getJobManager().endRule(rule);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void invokeThread() throws DebugException {
            try {
                JDIThread jDIThread = JDIThread.this;
                synchronized (jDIThread) {
                    JDIThread.this.fClientSuspendRequest = false;
                }
                JDIThread.this.fThread.resume();
            }
            catch (RuntimeException e) {
                this.stepEnd(null);
                JDIThread.this.fireSuspendEvent(8);
                JDIThread.this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_stepping, e.toString()), e);
            }
        }

        protected StepRequest createStepRequest() throws DebugException {
            return this.createStepRequest(this.getStepKind());
        }

        protected StepRequest createStepRequest(int kind) throws DebugException {
            com.sun.jdi.request.EventRequestManager manager = JDIThread.this.getEventRequestManager();
            if (manager == null) {
                JDIThread.this.requestFailed(JDIDebugModelMessages.JDIThread_Unable_to_create_step_request___VM_disconnected__1, new VMDisconnectedException());
            }
            try {
                StepRequest request = manager.createStepRequest(JDIThread.this.fThread, -2, kind);
                request.setSuspendPolicy(1);
                request.addCountFilter(1);
                this.attachFiltersToStepRequest(request);
                request.enable();
                if (manager.virtualMachine().canGetMethodReturnValues() && JDIThread.showStepResultIsEnabled(JDIThread.this.getDebugTarget())) {
                    if (JDIThread.this.fCurrentMethodExitRequest != null) {
                        JDIThread.this.removeJDIEventListener(this, JDIThread.this.fCurrentMethodExitRequest);
                        manager.deleteEventRequest(JDIThread.this.fCurrentMethodExitRequest);
                        JDIThread.this.fCurrentMethodExitRequest = null;
                        Thread t = JDIThread.this.fCurrentMethodExitRequestDisabler;
                        if (t != null) {
                            t.interrupt();
                            JDIThread.this.fCurrentMethodExitRequestDisabler = null;
                        }
                    }
                    if (JDIThread.this.fCurrentExceptionRequest != null) {
                        JDIThread.this.removeJDIEventListener(this, JDIThread.this.fCurrentExceptionRequest);
                        manager.deleteEventRequest(JDIThread.this.fCurrentExceptionRequest);
                        JDIThread.this.fCurrentExceptionRequest = null;
                    }
                    if (JDIThread.this.fCurrentMethodEntryRequest != null) {
                        JDIThread.this.removeJDIEventListener(this, JDIThread.this.fCurrentMethodEntryRequest);
                        manager.deleteEventRequest(JDIThread.this.fCurrentMethodEntryRequest);
                        JDIThread.this.fCurrentMethodEntryRequest = null;
                    }
                    JDIThread.this.fStepResultCandidate = null;
                    JDIThread.this.fStepResultTimeoutTriggered.set(false);
                    List<IJavaStackFrame> frames = JDIThread.this.computeStackFrames();
                    int frameCount = 0;
                    StackFrame currentFrame = null;
                    if (!frames.isEmpty()) {
                        frameCount = frames.size();
                        currentFrame = ((JDIStackFrame)frames.get(0)).getUnderlyingStackFrame();
                    } else if (JDIThread.this.fThread.isSuspended()) {
                        try {
                            frameCount = JDIThread.this.fThread.frameCount();
                            currentFrame = JDIThread.this.fThread.frame(0);
                        }
                        catch (IncompatibleThreadStateException e) {
                            JDIThread.this.logError(e);
                        }
                    }
                    if (currentFrame != null) {
                        int timeout;
                        Method method;
                        MethodExitRequest methodExitRequest = manager.createMethodExitRequest();
                        methodExitRequest.addThreadFilter(JDIThread.this.fThread);
                        methodExitRequest.addClassFilter(currentFrame.location().declaringType());
                        if (manager.virtualMachine().canUseInstanceFilters()) {
                            ObjectReference thisObject = null;
                            try {
                                thisObject = currentFrame.thisObject();
                            }
                            catch (Exception exception) {}
                            if (thisObject != null) {
                                methodExitRequest.addInstanceFilter(thisObject);
                            }
                        }
                        methodExitRequest.setSuspendPolicy(1);
                        methodExitRequest.enable();
                        JDIThread.this.fCurrentMethodExitRequest = methodExitRequest;
                        JDIThread.this.fStepResultMethod = method = currentFrame.location().method();
                        JDIThread.this.fStepReturnTargetFrameCount = frameCount - 1;
                        JDIThread.this.addJDIEventListener(this, methodExitRequest);
                        ExceptionRequest exceptionRequest = manager.createExceptionRequest(null, true, false);
                        exceptionRequest.addThreadFilter(JDIThread.this.fThread);
                        exceptionRequest.setSuspendPolicy(1);
                        exceptionRequest.enable();
                        JDIThread.this.fCurrentExceptionRequest = exceptionRequest;
                        JDIThread.this.addJDIEventListener(this, exceptionRequest);
                        if (kind == 2) {
                            MethodEntryRequest methodEntryRequest = manager.createMethodEntryRequest();
                            methodEntryRequest.addThreadFilter(JDIThread.this.fThread);
                            methodEntryRequest.enable();
                            methodEntryRequest.setSuspendPolicy(1);
                            JDIThread.this.fCurrentMethodEntryRequest = methodEntryRequest;
                            JDIThread.this.fStepOverLocation = currentFrame.location();
                            JDIThread.this.fStepOverFrameCount = frameCount;
                            JDIThread.this.addJDIEventListener(this, methodEntryRequest);
                        }
                        if ((timeout = JDIThread.getStepResultTimeout()) != 0) {
                            Runnable r = () -> {
                                try {
                                    if (timeout > 0) {
                                        Thread.sleep(timeout);
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                    return;
                                }
                                JDIThread.this.fStepResultTimeoutTriggered.set(true);
                                if (JDIThread.this.fCurrentMethodExitRequest == methodExitRequest) {
                                    try {
                                        methodExitRequest.disable();
                                        if (JDIThread.this.fCurrentExceptionRequest == exceptionRequest) {
                                            exceptionRequest.disable();
                                        }
                                    }
                                    catch (Exception exception) {}
                                }
                            };
                            if (timeout > 0) {
                                Thread t = new Thread(r, "JDIThread: MethodExitDisabler");
                                t.setDaemon(true);
                                t.start();
                                JDIThread.this.fCurrentMethodExitRequestDisabler = t;
                            } else {
                                r.run();
                            }
                        }
                    }
                }
                return request;
            }
            catch (RuntimeException e) {
                JDIThread.this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_creating_step_request, e.toString()), e);
                return null;
            }
        }

        protected abstract int getStepKind();

        protected abstract int getStepDetail();

        protected void setStepRequest(StepRequest request) {
            this.fStepRequest = request;
        }

        protected StepRequest getStepRequest() {
            return this.fStepRequest;
        }

        protected void deleteStepRequest() {
            try {
                try {
                    StepRequest req;
                    com.sun.jdi.request.EventRequestManager manager;
                    if (JDIThread.this.fCurrentMethodExitRequest != null) {
                        JDIThread.this.removeJDIEventListener(this, JDIThread.this.fCurrentMethodExitRequest);
                        manager = JDIThread.this.getEventRequestManager();
                        if (manager != null) {
                            manager.deleteEventRequest(JDIThread.this.fCurrentMethodExitRequest);
                        }
                        JDIThread.this.fCurrentMethodExitRequest = null;
                        Thread t = JDIThread.this.fCurrentMethodExitRequestDisabler;
                        if (t != null) {
                            t.interrupt();
                            JDIThread.this.fCurrentMethodExitRequestDisabler = null;
                        }
                    }
                    if (JDIThread.this.fCurrentExceptionRequest != null) {
                        JDIThread.this.removeJDIEventListener(this, JDIThread.this.fCurrentExceptionRequest);
                        manager = JDIThread.this.getEventRequestManager();
                        if (manager != null) {
                            manager.deleteEventRequest(JDIThread.this.fCurrentExceptionRequest);
                        }
                        JDIThread.this.fCurrentExceptionRequest = null;
                    }
                    if (JDIThread.this.fCurrentMethodEntryRequest != null) {
                        JDIThread.this.removeJDIEventListener(this, JDIThread.this.fCurrentMethodEntryRequest);
                        manager = JDIThread.this.getEventRequestManager();
                        if (manager != null) {
                            manager.deleteEventRequest(JDIThread.this.fCurrentMethodEntryRequest);
                        }
                        JDIThread.this.fCurrentMethodEntryRequest = null;
                    }
                    if ((req = this.getStepRequest()) != null) {
                        JDIThread.this.removeJDIEventListener(this, req);
                        com.sun.jdi.request.EventRequestManager manager2 = JDIThread.this.getEventRequestManager();
                        if (manager2 != null) {
                            manager2.deleteEventRequest(req);
                        }
                    }
                }
                catch (RuntimeException e) {
                    JDIThread.this.logError(e);
                    this.setStepRequest(null);
                }
            }
            finally {
                this.setStepRequest(null);
            }
        }

        protected void attachFiltersToStepRequest(StepRequest request) {
            if (this.applyStepFilters() && JDIThread.this.isStepFiltersEnabled()) {
                Location currentLocation = JDIThread.this.getOriginalStepLocation();
                if (!JDIThread.this.isSupported(currentLocation)) {
                    return;
                }
                String[] activeFilters = JDIThread.this.getJavaDebugTarget().getStepFilters();
                if (activeFilters != null) {
                    String[] stringArray = activeFilters;
                    int n = activeFilters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String activeFilter = stringArray[n2];
                        request.addClassExclusionFilter(activeFilter);
                        ++n2;
                    }
                }
            }
        }

        protected boolean applyStepFilters() {
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean handleEvent(Event event, JDIDebugTarget target, boolean suspendVote, EventSet eventSet) {
            try {
                if (event instanceof MethodExitEvent) {
                    MethodExitEvent methodExitEvent;
                    Method stepResultMethod = JDIThread.this.fStepResultMethod;
                    if (stepResultMethod != null && (methodExitEvent = (MethodExitEvent)event).location().method().equals(stepResultMethod)) {
                        JDIThread.this.fStepResultCandidate = new MethodResult(stepResultMethod, JDIThread.this.fStepReturnTargetFrameCount, methodExitEvent.returnValue(), MethodResult.ResultType.returned);
                    }
                    return true;
                }
                if (event instanceof ExceptionEvent) {
                    ExceptionEvent exceptionEvent = (ExceptionEvent)event;
                    Method stepResultMethod = JDIThread.this.fStepResultMethod;
                    if (stepResultMethod != null) {
                        JDIThread.this.fStepResultCandidate = new MethodResult(stepResultMethod, JDIThread.this.fStepReturnTargetFrameCount, exceptionEvent.exception(), MethodResult.ResultType.threw);
                    }
                    return true;
                }
                if (event instanceof MethodEntryEvent) {
                    JDIThread.this.removeJDIEventListener(this, JDIThread.this.fCurrentMethodEntryRequest);
                    com.sun.jdi.request.EventRequestManager manager = JDIThread.this.getEventRequestManager();
                    if (manager != null) {
                        manager.deleteEventRequest(JDIThread.this.fCurrentMethodEntryRequest);
                    }
                    JDIThread.this.fCurrentMethodEntryRequest = null;
                    this.deleteStepRequest();
                    this.createSecondaryStepRequest(3);
                    return true;
                }
                StepEvent stepEvent = (StepEvent)event;
                Location currentLocation = stepEvent.location();
                if (JDIThread.this.fStepResultTimeoutTriggered.get()) {
                    Method m = JDIThread.this.fStepResultMethod;
                    if (m != null) {
                        JDIThread.this.setMethodResult(new MethodResult(m, -1, null, MethodResult.ResultType.step_timeout));
                    }
                    JDIThread.this.fStepResultMethod = null;
                    JDIThread.this.fStepReturnTargetFrameCount = -1;
                    JDIThread.this.fStepResultCandidate = null;
                    JDIThread.this.fStepResultTimeoutTriggered.set(false);
                } else if (JDIThread.this.fStepResultCandidate != null) {
                    JDIThread.this.setMethodResult(JDIThread.this.fStepResultCandidate);
                    JDIThread.this.fStepResultMethod = null;
                    JDIThread.this.fStepReturnTargetFrameCount = -1;
                    JDIThread.this.fStepResultCandidate = null;
                    JDIThread.this.fStepResultTimeoutTriggered.set(false);
                }
                Location stepOverLocation2 = JDIThread.this.fStepOverLocation;
                if (this.getStepKind() == 2 && stepOverLocation2 != null && JDIThread.this.fStepOverFrameCount >= 0) {
                    int lineNumber;
                    int underlyingFrameCount = JDIThread.this.getUnderlyingFrameCount();
                    if (underlyingFrameCount > JDIThread.this.fStepOverFrameCount) {
                        this.deleteStepRequest();
                        this.createSecondaryStepRequest(3);
                        return true;
                    }
                    if (underlyingFrameCount == JDIThread.this.fStepOverFrameCount && stepOverLocation2.method().equals(currentLocation.method()) && (lineNumber = stepOverLocation2.lineNumber()) != -1 && lineNumber == currentLocation.lineNumber()) {
                        this.deleteStepRequest();
                        this.createSecondaryStepRequest(2);
                        return true;
                    }
                    JDIThread.this.fStepOverLocation = null;
                    JDIThread.this.fStepOverFrameCount = -1;
                }
                if (!target.isStepThruFilters() && JDIThread.this.shouldDoStepReturn()) {
                    this.deleteStepRequest();
                    this.createSecondaryStepRequest(3);
                    return true;
                }
                if (this.locationShouldBeFiltered(currentLocation) || JDIThread.this.shouldDoExtraStepInto(currentLocation) || this.getStepKind() == 2 && this.isSyntheticAndNotAvailable(currentLocation, stepOverLocation2)) {
                    JDIThread.this.setRunning(true);
                    this.deleteStepRequest();
                    this.createSecondaryStepRequest();
                    JDIThread.this.clearMethodResult();
                    return true;
                }
                this.stepEnd(eventSet);
                return false;
            }
            catch (DebugException e) {
                JDIThread.this.logError((Exception)((Object)e));
                this.stepEnd(eventSet);
                return false;
            }
        }

        @Override
        public void eventSetComplete(Event event, JDIDebugTarget target, boolean suspend, EventSet eventSet) {
        }

        protected boolean locationShouldBeFiltered(Location location) throws DebugException {
            Location origLocation;
            if (this.applyStepFilters() && (origLocation = JDIThread.this.getOriginalStepLocation()) != null) {
                return !this.locationIsFiltered(origLocation.method(), true) && this.locationIsFiltered(location.method(), false);
            }
            return false;
        }

        protected boolean locationIsFiltered(Method method, boolean orig) {
            if (JDIThread.this.isStepFiltersEnabled()) {
                JDIDebugTarget target = JDIThread.this.getJavaDebugTarget();
                if (target.isFilterStaticInitializers() && method.isStaticInitializer() || target.isFilterSynthetics() && method.isSynthetic() || target.isFilterConstructors() && method.isConstructor() || target.isFilterGetters() && JDIMethod.isGetterMethod(method) || target.isFilterSetters() && JDIMethod.isSetterMethod(method)) {
                    return true;
                }
                if (!orig) {
                    IStepFilter[] iStepFilterArray = DebugPlugin.getStepFilters((String)JDIDebugPlugin.getUniqueIdentifier());
                    int n = iStepFilterArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStepFilter contributedFilter = iStepFilterArray[n2];
                        if (contributedFilter.isFiltered((Object)method)) {
                            return true;
                        }
                        ++n2;
                    }
                }
            }
            return false;
        }

        protected void stepEnd(EventSet set) {
            JDIThread.this.setRunning(false);
            this.deleteStepRequest();
            JDIThread.this.setPendingStepHandler(null);
            if (set != null) {
                JDIThread.this.queueSuspendEvent(8, set);
            }
        }

        protected void createSecondaryStepRequest() throws DebugException {
            this.createSecondaryStepRequest(this.getStepKind());
        }

        protected void createSecondaryStepRequest(int kind) throws DebugException {
            this.setStepRequest(this.createStepRequest(kind));
            JDIThread.this.setPendingStepHandler(this);
            JDIThread.this.addJDIEventListener(this, this.getStepRequest());
        }

        protected void abort() {
            if (this.getStepRequest() != null) {
                this.deleteStepRequest();
                JDIThread.this.setPendingStepHandler(null);
                JDIThread.this.fStepOverLocation = null;
                JDIThread.this.fStepOverFrameCount = -1;
            }
        }

        private boolean isSyntheticAndNotAvailable(Location currentLocation, Location previousLocation) {
            int currentLineNumber;
            boolean isLambdaMethod;
            Method method;
            return previousLocation != null && (method = previousLocation.method()) != null && method.isSynthetic() && (isLambdaMethod = LambdaUtils.isLambdaMethod(method)) && (currentLineNumber = currentLocation.lineNumber()) == -1;
        }
    }

    protected class StepIntoHandler
    extends StepHandler {
        protected StepIntoHandler() {
        }

        @Override
        protected int getStepKind() {
            return 1;
        }

        @Override
        protected int getStepDetail() {
            return 1;
        }
    }

    class StepOverHandler
    extends StepHandler {
        StepOverHandler() {
        }

        @Override
        protected int getStepKind() {
            return 2;
        }

        @Override
        protected int getStepDetail() {
            return 2;
        }
    }

    protected class StepReturnHandler
    extends StepHandler {
        protected StepReturnHandler() {
        }

        @Override
        protected boolean locationShouldBeFiltered(Location location) throws DebugException {
            if (JDIThread.this.getOriginalStepStackDepth() == JDIThread.this.getUnderlyingFrameCount()) {
                return true;
            }
            return super.locationShouldBeFiltered(location);
        }

        @Override
        protected int getStepKind() {
            return 3;
        }

        @Override
        protected int getStepDetail() {
            return 4;
        }
    }

    protected class StepToFrameHandler
    extends StepReturnHandler {
        private int fRemainingFrames;

        protected StepToFrameHandler(IStackFrame frame) throws DebugException {
            List<IJavaStackFrame> frames = JDIThread.this.computeStackFrames();
            this.setRemainingFrames(frames.size() - frames.indexOf(frame));
        }

        protected void setRemainingFrames(int num) {
            this.fRemainingFrames = num;
        }

        protected int getRemainingFrames() {
            return this.fRemainingFrames;
        }

        @Override
        public boolean handleEvent(Event event, JDIDebugTarget target, boolean suspendVote, EventSet eventSet) {
            block3: {
                try {
                    int numFrames = JDIThread.this.getUnderlyingFrameCount();
                    if (numFrames > this.getRemainingFrames()) break block3;
                    this.stepEnd(eventSet);
                    return false;
                }
                catch (DebugException e) {
                    JDIThread.this.logError((Exception)((Object)e));
                    this.stepEnd(eventSet);
                    return false;
                }
            }
            JDIThread.this.setRunning(true);
            this.deleteStepRequest();
            this.createSecondaryStepRequest();
            JDIThread.this.clearMethodResult();
            return true;
        }
    }

    class ThreadJob
    extends Job {
        private final Vector<Runnable> fRunnables;

        public ThreadJob() {
            super(JDIDebugModelMessages.JDIThread_39);
            this.fRunnables = new Vector(5);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRunnable(Runnable runnable) {
            Vector<Runnable> vector = this.fRunnables;
            synchronized (vector) {
                this.fRunnables.add(runnable);
            }
            this.schedule();
        }

        public boolean isEmpty() {
            return this.fRunnables.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            Object[] runnables;
            JDIThread.this.fRunningAsyncJob = true;
            Vector<Runnable> vector = this.fRunnables;
            synchronized (vector) {
                runnables = this.fRunnables.toArray();
                this.fRunnables.clear();
            }
            MultiStatus failed = null;
            monitor.beginTask(JDIDebugModelMessages.JDIThread_39, runnables.length);
            int i = 0;
            while (i < runnables.length && !JDIThread.this.isTerminated() && !monitor.isCanceled()) {
                try {
                    ((Runnable)runnables[i]).run();
                }
                catch (Exception e) {
                    if (failed == null) {
                        failed = new MultiStatus(JDIDebugPlugin.getUniqueIdentifier(), 120, JDIDebugModelMessages.JDIThread_0, null);
                    }
                    failed.add((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 120, JDIDebugModelMessages.JDIThread_0, (Throwable)e));
                }
                ++i;
                monitor.worked(1);
            }
            JDIThread.this.fRunningAsyncJob = false;
            monitor.done();
            if (failed == null) {
                return Status.OK_STATUS;
            }
            return failed;
        }

        public boolean shouldRun() {
            return !JDIThread.this.isTerminated() && !this.fRunnables.isEmpty();
        }

        public boolean belongsTo(Object family) {
            return JDIThread.class == family || JDIThread.this == family;
        }
    }
}

