/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.serialization;

import com.google.common.collect.Maps;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecoretools.ale.core.env.impl.FileBasedAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.parser.BehaviorsParser;
import org.eclipse.emf.ecoretools.ale.core.parser.ParsedFile;
import org.eclipse.emf.ecoretools.ale.core.parser.internal.AntlrAstToAleBehaviorsFactory;
import org.eclipse.emf.ecoretools.ale.core.serialization.Serializer;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;

@Deprecated
public class Converter {
    IQueryEnvironment qryEnv;

    public Converter(IQueryEnvironment qryEnv) {
        this.qryEnv = qryEnv;
        AntlrAstToAleBehaviorsFactory.createSingleton(qryEnv);
    }

    public void aleToEcore(FileBasedAleEnvironment dsl, boolean createRuntimeEcore) throws IOException {
        List<ParsedFile<ModelUnit>> parseRes = new BehaviorsParser(this.qryEnv).parse(dsl.getMetamodels(), dsl.getBehaviorsSources());
        List allModelUnits = parseRes.stream().map(p -> (ModelUnit)p.getRoot()).collect(Collectors.toList());
        boolean isConvertible = allModelUnits.stream().allMatch(unit -> this.isConvertibleToEcore((ModelUnit)unit));
        if (isConvertible) {
            parseRes.forEach(parseUnit -> {
                List<Method> allImplem = ((ModelUnit)parseUnit.getRoot()).getClassExtensions().stream().flatMap(cls -> cls.getMethods().stream()).collect(Collectors.toList());
                allImplem.forEach(mtd -> {
                    EOperation opRef = mtd.getOperationRef();
                    Optional<String> body = parseUnit.getText(mtd.getBody());
                    if (opRef != null) {
                        if (body.isPresent()) {
                            EcoreUtil.setAnnotation((EModelElement)opRef, (String)"http://implementation/", (String)"body", (String)body.get());
                        }
                        EcoreUtil.setAnnotation((EModelElement)opRef.getEContainingClass().getEPackage(), (String)"http://www.eclipse.org/emf/2002/Ecore", (String)"invocationDelegates", (String)"http://implementation/");
                    }
                });
                EList<RuntimeClass> allRuntimeCls = ((ModelUnit)parseUnit.getRoot()).getClassDefinitions();
                allRuntimeCls.stream().flatMap(cls -> cls.getMethods().stream()).forEach(mtd -> {
                    EOperation opRef = mtd.getOperationRef();
                    Optional<String> body = parseUnit.getText(mtd.getBody());
                    if (body.isPresent() && opRef != null) {
                        EcoreUtil.setAnnotation((EModelElement)opRef, (String)"http://implementation/", (String)"body", (String)body.get());
                    }
                });
                allRuntimeCls.stream().flatMap(cls -> cls.getAttributes().stream()).forEach(att -> {
                    EStructuralFeature featureRef = att.getFeatureRef();
                    Optional<String> initVal = parseUnit.getText(att.getInitialValue());
                    if (initVal.isPresent()) {
                        EcoreUtil.setAnnotation((EModelElement)featureRef, (String)"http://implementation/", (String)"initial", (String)initVal.get());
                    }
                });
            });
            List<RuntimeClass> allRuntimeCls = allModelUnits.stream().flatMap(unit -> unit.getClassDefinitions().stream()).collect(Collectors.toList());
            EPackage runtimePkg = this.getRuntimeEPackage(dsl, createRuntimeEcore);
            EcoreUtil.setAnnotation((EModelElement)runtimePkg, (String)"http://www.eclipse.org/emf/2002/Ecore", (String)"settingDelegates", (String)"http://implementation/");
            EcoreUtil.setAnnotation((EModelElement)runtimePkg, (String)"http://www.eclipse.org/emf/2002/Ecore", (String)"invocationDelegates", (String)"http://implementation/");
            allRuntimeCls.forEach(runtimeCls -> {
                EClass newCls = AntlrAstToAleBehaviorsFactory.singleton.buildEClass(runtimeCls.getName());
                AntlrAstToAleBehaviorsFactory.singleton.updateEClass(newCls, (RuntimeClass)runtimeCls);
                EcoreUtil.setAnnotation((EModelElement)newCls, (String)"http://implementation/", (String)"runtime", (String)"");
                runtimePkg.getEClassifiers().add((Object)newCls);
            });
            dsl.getBehaviorsSources().clear();
            dsl.save(dsl);
        }
    }

    public void ecoreToAle(FileBasedAleEnvironment dsl, boolean createRuntimeEcore) throws IOException {
        StringBuffer aleContent = new StringBuffer();
        aleContent.append("behavior generated.runtime;\n\n");
        List<EPackage> pkgs = dsl.getMetamodels();
        List allPkgs = pkgs.stream().flatMap(pkg -> this.getAllEPackages((EPackage)pkg).stream()).collect(Collectors.toList());
        List runtimePkgs = allPkgs.stream().filter(pkg -> EcoreUtil.getAnnotation((EModelElement)pkg, (String)"http://implementation/", (String)"runtime") != null).collect(Collectors.toList());
        List syntaxPkgs = allPkgs.stream().filter(pkg -> EcoreUtil.getAnnotation((EModelElement)pkg, (String)"http://implementation/", (String)"runtime") == null).collect(Collectors.toList());
        if (!createRuntimeEcore) {
            runtimePkgs.stream().flatMap(pkg -> pkg.getEClassifiers().stream()).filter(c -> c instanceof EClass).map(cls -> (EClass)cls).forEach(cls -> {
                aleContent.append(Serializer.runtimeToString(cls));
                aleContent.append("\n");
            });
        }
        syntaxPkgs.stream().flatMap(pkg -> pkg.getEClassifiers().stream()).filter(c -> c instanceof EClass).map(cls -> (EClass)cls).forEach(cls -> {
            aleContent.append(Serializer.openclassToString(cls));
            aleContent.append("\n");
        });
        Resource res = ((EPackage)syntaxPkgs.get(0)).eResource();
        URI ecoreURI = res.getURI();
        if (ecoreURI.fileExtension().equals("ecore")) {
            URI aleURI = ecoreURI.trimFileExtension().appendFileExtension("ale");
            String aleFilePath = aleURI.toFileString();
            Path path = Paths.get(aleFilePath, new String[0]);
            try {
                Throwable throwable = null;
                Object var14_16 = null;
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    writer.write(aleContent.toString());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.removeAllRuntimeData(dsl, createRuntimeEcore);
            dsl.getBehaviorsSources().add(aleFilePath);
            dsl.save(dsl);
        }
    }

    private boolean isConvertibleToEcore(ModelUnit unit) {
        boolean hasAttributes = unit.getClassExtensions().stream().flatMap(cls -> cls.getAttributes().stream()).findAny().isPresent();
        boolean hasMethod = unit.getClassExtensions().stream().flatMap(cls -> cls.getMethods().stream()).filter(mtd -> this.isImplementation((Method)mtd)).findAny().isPresent();
        return !hasAttributes && !hasMethod;
    }

    private boolean isImplementation(Method mtd) {
        EOperation opRef = mtd.getOperationRef();
        if (opRef != null) {
            String nsURI = opRef.getEContainingClass().getEPackage().getNsURI();
            boolean isRuntime = nsURI == null || nsURI.startsWith("http://ale/runtime/");
            return !isRuntime;
        }
        return false;
    }

    private EPackage getRuntimeEPackage(FileBasedAleEnvironment dsl, boolean createRuntimeEcore) {
        List<EPackage> pkgs = dsl.getMetamodels();
        Optional<EPackage> runtimePkg = pkgs.stream().filter(pkg -> EcoreUtil.getAnnotation((EModelElement)pkg, (String)"http://implementation/", (String)"runtime") != null).findFirst();
        if (runtimePkg.isPresent()) {
            return runtimePkg.get();
        }
        if (createRuntimeEcore) {
            Resource res;
            String fileName;
            if (!pkgs.isEmpty() && (fileName = (res = pkgs.get(0).eResource()).getURI().lastSegment()).endsWith("\\.ecore")) {
                fileName = "runtime" + Character.toUpperCase(fileName.charAt(0)) + fileName.substring(1);
                URI runtimeURI = res.getURI().trimSegments(1).appendSegment(fileName);
                Resource runtimeRes = res.getResourceSet().createResource(runtimeURI);
                EPackage newPkg = AntlrAstToAleBehaviorsFactory.singleton.buildEPackage("runtime");
                EcoreUtil.setAnnotation((EModelElement)newPkg, (String)"http://implementation/", (String)"runtime", (String)"");
                runtimeRes.getContents().add((Object)newPkg);
                try {
                    runtimeRes.save((Map)Maps.newHashMap());
                    dsl.getMetamodelsSources().add(runtimeURI.toFileString());
                    return newPkg;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (!pkgs.isEmpty()) {
            EPackage firstPkg = pkgs.get(0);
            return firstPkg;
        }
        return null;
    }

    private List<EPackage> getAllEPackages(EPackage pkg) {
        List<EPackage> res = pkg.getESubpackages().stream().flatMap(p -> this.getAllEPackages((EPackage)p).stream()).collect(Collectors.toList());
        res.add(0, pkg);
        return res;
    }

    private void removeAllRuntimeData(FileBasedAleEnvironment dsl, boolean createRuntimeEcore) throws IOException {
        List<EPackage> pkgs = dsl.getMetamodels();
        List<EPackage> allPkgs = pkgs.stream().flatMap(pkg -> this.getAllEPackages((EPackage)pkg).stream()).collect(Collectors.toList());
        allPkgs.forEach(pkg -> {
            EAnnotation eAnnotation = pkg.getEAnnotation("http://implementation/");
            if (eAnnotation != null) {
                EcoreUtil.remove((EObject)eAnnotation);
            }
        });
        List syntaxPkgs = allPkgs.stream().filter(pkg -> EcoreUtil.getAnnotation((EModelElement)pkg, (String)"http://implementation/", (String)"runtime") == null).collect(Collectors.toList());
        syntaxPkgs.stream().flatMap(pkg -> pkg.getEClassifiers().stream()).filter(c -> c instanceof EClass).map(c -> (EClass)c).forEach(cls -> {
            if (EcoreUtil.getAnnotation((EModelElement)cls, (String)"http://implementation/", (String)"runtime") != null) {
                EcoreUtil.remove((EObject)cls);
            } else {
                cls.getEStructuralFeatures().forEach(feature -> {
                    EAnnotation eAnnotation = feature.getEAnnotation("http://implementation/");
                    if (eAnnotation != null) {
                        EcoreUtil.remove((EObject)eAnnotation);
                    }
                });
                cls.getEOperations().forEach(operation -> {
                    EAnnotation eAnnotation = operation.getEAnnotation("http://implementation/");
                    if (eAnnotation != null) {
                        EcoreUtil.remove((EObject)eAnnotation);
                    }
                });
            }
        });
        if (!createRuntimeEcore) {
            List<EPackage> runtimePkgs = allPkgs.stream().filter(pkg -> EcoreUtil.getAnnotation((EModelElement)pkg, (String)"http://implementation/", (String)"runtime") != null).collect(Collectors.toList());
            runtimePkgs.forEach(pkg -> dsl.getMetamodelsSources().remove(pkg.eResource().getURI().toString()));
        }
        syntaxPkgs.stream().map(pkg -> pkg.eResource()).collect(Collectors.toSet()).forEach(res -> {
            try {
                res.save((Map)Maps.newHashMap());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        dsl.save(dsl);
    }
}

