/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.ConsoleIO;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.message.ErrorMessage;

public class EclipseConsoleOutputStream
extends OutputStream {
    ConsoleIO consoleIO;
    Boolean isErrStream = false;
    StringBuffer singleByteBuffer = new StringBuffer();

    public EclipseConsoleOutputStream(ConsoleIO consoleIO) {
        this.consoleIO = consoleIO;
    }

    public EclipseConsoleOutputStream(ConsoleIO consoleIO, Boolean isErrStream) {
        this.consoleIO = consoleIO;
        this.isErrStream = isErrStream;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] bytes = new byte[]{new Integer(b).byteValue()};
        String s = new String(bytes);
        this.singleByteBuffer.append(s);
        if (this.singleByteBuffer.length() > 1024 || b == 10 || b == 13) {
            this.flush();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        String s = new String(b);
        this.flush();
        if (this.isErrStream.booleanValue()) {
            this.consoleIO.print(new ErrorMessage(s));
        } else {
            this.consoleIO.print(s);
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        super.flush();
        if (this.isErrStream.booleanValue()) {
            this.consoleIO.print(this.singleByteBuffer.toString());
        } else {
            this.consoleIO.print(this.singleByteBuffer.toString());
        }
        this.singleByteBuffer = new StringBuffer();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }
}

