/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.validation.impl;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.AssignmentToResultInVoidOperation;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.ClassExtendsItself;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.CodeLocation;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.Context;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.DiagnosticsFactory;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.IllegalAdditionAssignment;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.IllegalAssignment;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.IllegalSubstractionAssignment;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.IndirectExtension;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.Message;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.NotIterable;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.Operator;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.ProhibitedInsertionToSelf;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.ProhibitedRemovalFromSelf;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.TypeMismatch;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.TypeNotFound;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.UnsupportedOperator;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.impl.StackedScopes;
import org.eclipse.emf.ecoretools.ale.core.validation.BaseValidator;
import org.eclipse.emf.ecoretools.ale.core.validation.IValidationMessageFactory;
import org.eclipse.emf.ecoretools.ale.core.validation.impl.TypeChecker;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.ForEach;
import org.eclipse.emf.ecoretools.ale.implementation.Statement;
import org.eclipse.emf.ecoretools.ale.implementation.VariableInsert;
import org.eclipse.emf.ecoretools.ale.implementation.VariableRemove;

public final class ValidationMessageFactory
implements IValidationMessageFactory {
    private final BaseValidator base;

    public ValidationMessageFactory(BaseValidator base) {
        this.base = Objects.requireNonNull(base, "base");
    }

    @Override
    public Message assignmentToResultInVoidOperation(Statement assignment) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.base.getLines(assignment).get(0));
        location.setStartPosition(this.base.getStartOffset(assignment));
        location.setEndPosition(this.base.getEndOffset(assignment));
        AssignmentToResultInVoidOperation notfound = DiagnosticsFactory.eINSTANCE.createAssignmentToResultInVoidOperation();
        notfound.setName("result");
        notfound.setSource(assignment);
        notfound.setLocation(location);
        return notfound;
    }

    @Override
    public Message expectedBoolean(Expression exp) {
        HashSet expectedTypes = Sets.newHashSet((Object[])new IType[]{new EClassifierType((IReadOnlyQueryEnvironment)this.base.getQryEnv(), (EClassifier)EcorePackage.eINSTANCE.getEBoolean())});
        Set<IType> actualTypes = this.base.getPossibleTypes(exp);
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.base.getLines(exp).get(0));
        location.setStartPosition(this.base.getStartOffset(exp));
        location.setEndPosition(this.base.getEndOffset(exp));
        TypeMismatch mismatch = DiagnosticsFactory.eINSTANCE.createTypeMismatch();
        mismatch.setLocation(location);
        mismatch.setSource((EObject)exp);
        mismatch.getExpectedTypes().addAll((Collection)expectedTypes);
        mismatch.getActualTypes().addAll(actualTypes);
        return mismatch;
    }

    @Override
    public Message extendingItself(ExtendedClass xtdClass) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.base.getLines(xtdClass).get(0));
        location.setStartPosition(this.base.getStartOffset(xtdClass));
        location.setEndPosition(this.base.getEndOffset(xtdClass));
        ClassExtendsItself extendsItself = DiagnosticsFactory.eINSTANCE.createClassExtendsItself();
        extendsItself.setLocation(location);
        extendsItself.setSource((EObject)xtdClass);
        return extendsItself;
    }

    @Override
    public Message forEachCanOnlyIterateOnCollections(ForEach loop) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.base.getLines(loop.getCollectionExpression()).get(0));
        location.setStartPosition(this.base.getStartOffset(loop.getCollectionExpression()));
        location.setEndPosition(this.base.getEndOffset(loop.getCollectionExpression()));
        NotIterable notIterable = DiagnosticsFactory.eINSTANCE.createNotIterable();
        notIterable.setLocation(location);
        notIterable.setSource((EObject)loop.getCollectionExpression());
        notIterable.getActualTypes().addAll(this.base.getPossibleTypes(loop.getCollectionExpression()));
        return notIterable;
    }

    @Override
    public Message illegalAssignment(Set<IType> variableTypes, Set<IType> valueTypes, EObject assignment, Object assignedValue) {
        boolean includesSemicolon = assignment.getClass().getName().startsWith("org.eclipse.emf.ecoretools.ale");
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.base.getLines(assignment).get(0));
        location.setStartPosition(this.base.getStartOffset(assignedValue));
        location.setEndPosition(this.base.getEndOffset(assignedValue) + (includesSemicolon ? 1 : 1));
        IllegalAssignment illegalAssignment = DiagnosticsFactory.eINSTANCE.createIllegalAssignment();
        illegalAssignment.setLocation(location);
        illegalAssignment.setSource(assignment);
        illegalAssignment.getExpectedTypes().addAll(variableTypes);
        illegalAssignment.getTargetTypes().addAll(variableTypes);
        illegalAssignment.getActualTypes().addAll(valueTypes);
        illegalAssignment.setAssignedValue(assignedValue);
        return illegalAssignment;
    }

    @Override
    public Message illegalInsertion(Set<IType> variableTypes, Set<IType> insertedValueTypes, Set<IType> acceptedValueTypes, Expression value) {
        IllegalAdditionAssignment mismatch = DiagnosticsFactory.eINSTANCE.createIllegalAdditionAssignment();
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.base.getLines(value).get(0));
        location.setStartPosition(this.base.getStartOffset(value));
        location.setEndPosition(this.base.getEndOffset(value) + 1);
        mismatch.setLocation(location);
        mismatch.setSource((EObject)value);
        mismatch.getTargetTypes().addAll(variableTypes);
        mismatch.getExpectedTypes().addAll(acceptedValueTypes);
        mismatch.getActualTypes().addAll(insertedValueTypes);
        return mismatch;
    }

    private boolean assigningCollectionToCollection(Set<IType> variableTypes, Set<IType> valueTypes) {
        TypeChecker types = new TypeChecker(new StackedScopes(), this.base.getQryEnv());
        if (variableTypes.stream().anyMatch(types::isCollection)) {
            if (valueTypes.stream().anyMatch(types::isCollection)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Message illegalRemoval(Set<IType> variableTypes, Set<IType> removedValueTypes, Set<IType> acceptedValueTypes, Expression value) {
        IllegalSubstractionAssignment mismatch = DiagnosticsFactory.eINSTANCE.createIllegalSubstractionAssignment();
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.base.getLines(value).get(0));
        location.setStartPosition(this.base.getStartOffset(value));
        location.setEndPosition(this.base.getEndOffset(value) + 1);
        mismatch.setLocation(location);
        mismatch.setSource((EObject)value);
        mismatch.getTargetTypes().addAll(variableTypes);
        mismatch.getExpectedTypes().addAll(acceptedValueTypes);
        mismatch.getActualTypes().addAll(removedValueTypes);
        return mismatch;
    }

    @Override
    public Message incompatibleTypes(Set<IType> expected, Set<IType> actual, EObject statement) {
        TypeMismatch mismatch = this.assigningCollectionToCollection(expected, actual) ? DiagnosticsFactory.eINSTANCE.createCollectionTypeMismatch() : DiagnosticsFactory.eINSTANCE.createTypeMismatch();
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.base.getLines(statement).get(0));
        location.setStartPosition(this.base.getStartOffset(statement));
        location.setEndPosition(this.base.getEndOffset(statement));
        mismatch.setLocation(location);
        mismatch.setSource(statement);
        mismatch.getExpectedTypes().addAll(expected);
        mismatch.getActualTypes().addAll(actual);
        return mismatch;
    }

    @Override
    public Message indirectExtension(ExtendedClass xtdClass, EClass superBase, EClass baseCls) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.base.getLines(xtdClass).get(0));
        location.setStartPosition(this.base.getStartOffset(xtdClass));
        location.setEndPosition(this.base.getStartOffset(xtdClass) + ("open class " + xtdClass.getName() + " extends " + xtdClass.getBaseClass().getName()).length());
        IndirectExtension indirectExtension = DiagnosticsFactory.eINSTANCE.createIndirectExtension();
        indirectExtension.setLocation(location);
        indirectExtension.setSource((EObject)xtdClass);
        indirectExtension.setOpenClass(baseCls);
        indirectExtension.setInheritedClass(superBase);
        return indirectExtension;
    }

    @Override
    public Message prohibitedInsertionToSelf(VariableInsert statement) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.base.getLines(statement).get(0));
        location.setStartPosition(this.base.getStartOffset(statement));
        location.setEndPosition(this.base.getStartOffset(statement) + "self".length());
        Context context = DiagnosticsFactory.eINSTANCE.createContext();
        ProhibitedInsertionToSelf unsupported = DiagnosticsFactory.eINSTANCE.createProhibitedInsertionToSelf();
        unsupported.setSource(statement);
        unsupported.setContext(context);
        unsupported.setLocation(location);
        unsupported.setOperator(Operator.ADDITION_ASSIGNMENT);
        return unsupported;
    }

    @Override
    public Message prohibitedRemovalFromSelf(VariableRemove statement) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.base.getLines(statement).get(0));
        location.setStartPosition(this.base.getStartOffset(statement));
        location.setEndPosition(this.base.getStartOffset(statement) + "self".length());
        Context context = DiagnosticsFactory.eINSTANCE.createContext();
        ProhibitedRemovalFromSelf unsupported = DiagnosticsFactory.eINSTANCE.createProhibitedRemovalFromSelf();
        unsupported.setSource(statement);
        unsupported.setContext(context);
        unsupported.setLocation(location);
        unsupported.setOperator(Operator.ADDITION_ASSIGNMENT);
        return unsupported;
    }

    @Override
    public Message unresolvedType(EObject statement) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.base.getLines(statement).get(0));
        location.setStartPosition(this.base.getStartOffset(statement));
        location.setEndPosition(this.base.getEndOffset(statement));
        Context context = DiagnosticsFactory.eINSTANCE.createContext();
        TypeNotFound unresolved = DiagnosticsFactory.eINSTANCE.createTypeNotFound();
        unresolved.setSource(statement);
        unresolved.setContext(context);
        unresolved.setLocation(location);
        unresolved.setName("");
        unresolved.getAvailableEPackages().addAll((Collection)this.base.getQryEnv().getEPackageProvider().getRegisteredEPackages());
        return unresolved;
    }

    @Override
    public Message unsupportedOperatorOnFeature(Set<IType> currentTypes, EObject statement, String featureName, Operator operator) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.base.getLines(statement).get(0));
        location.setStartPosition(this.base.getStartOffset(statement));
        location.setEndPosition(this.base.getStartOffset(statement) + ("self." + featureName).length());
        Context context = DiagnosticsFactory.eINSTANCE.createContext();
        UnsupportedOperator unsupported = DiagnosticsFactory.eINSTANCE.createUnsupportedOperator();
        unsupported.setSource(statement);
        unsupported.setContext(context);
        unsupported.setLocation(location);
        unsupported.setOperator(operator);
        unsupported.getTargetTypes().addAll(currentTypes);
        return unsupported;
    }

    @Override
    public Message unsupportedOperatorOnVariable(Set<IType> currentTypes, EObject statement, String variableName, Operator operator) {
        CodeLocation location = DiagnosticsFactory.eINSTANCE.createCodeLocation();
        location.setLine(this.base.getLines(statement).get(0));
        location.setStartPosition(this.base.getStartOffset(statement));
        location.setEndPosition(this.base.getStartOffset(statement) + variableName.length());
        Context context = DiagnosticsFactory.eINSTANCE.createContext();
        UnsupportedOperator unsupported = DiagnosticsFactory.eINSTANCE.createUnsupportedOperator();
        unsupported.setSource(statement);
        unsupported.setContext(context);
        unsupported.setLocation(location);
        unsupported.setOperator(operator);
        unsupported.getTargetTypes().addAll(currentTypes);
        return unsupported;
    }
}

