/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.Message;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.Operator;
import org.eclipse.emf.ecoretools.ale.core.validation.BaseValidator;
import org.eclipse.emf.ecoretools.ale.core.validation.IAstLookup;
import org.eclipse.emf.ecoretools.ale.core.validation.IConvertType;
import org.eclipse.emf.ecoretools.ale.core.validation.ITypeChecker;
import org.eclipse.emf.ecoretools.ale.core.validation.IValidationMessageFactory;
import org.eclipse.emf.ecoretools.ale.core.validation.IValidator;
import org.eclipse.emf.ecoretools.ale.core.validation.IVariableModificationStrategy;
import org.eclipse.emf.ecoretools.ale.core.validation.InsertionStrategy;
import org.eclipse.emf.ecoretools.ale.core.validation.RemovalStrategy;
import org.eclipse.emf.ecoretools.ale.core.validation.impl.AstLookup;
import org.eclipse.emf.ecoretools.ale.core.validation.impl.ConvertType;
import org.eclipse.emf.ecoretools.ale.core.validation.impl.TypeChecker;
import org.eclipse.emf.ecoretools.ale.core.validation.impl.ValidationMessageFactory;
import org.eclipse.emf.ecoretools.ale.implementation.Assignment;
import org.eclipse.emf.ecoretools.ale.implementation.BehavioredClass;
import org.eclipse.emf.ecoretools.ale.implementation.ConditionalBlock;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureInsert;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureRemove;
import org.eclipse.emf.ecoretools.ale.implementation.ForEach;
import org.eclipse.emf.ecoretools.ale.implementation.If;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationPackage;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;
import org.eclipse.emf.ecoretools.ale.implementation.VariableAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.VariableDeclaration;
import org.eclipse.emf.ecoretools.ale.implementation.VariableInsert;
import org.eclipse.emf.ecoretools.ale.implementation.VariableRemove;
import org.eclipse.emf.ecoretools.ale.implementation.While;

public class TypeValidator
implements IValidator {
    private static final List<Message> NO_PROBLEM = Collections.emptyList();
    private static final List<Message> PROBLEM_HANDLED_BY_ANOTHER_VALIDATOR = Collections.emptyList();
    private IValidationMessageFactory messages;
    private ITypeChecker typeChecker;
    private IConvertType convert;
    private IAstLookup lookup;

    @Override
    public void setBase(BaseValidator base) {
        this.messages = new ValidationMessageFactory(base);
        this.typeChecker = new TypeChecker(base.getScopes(), base.getQryEnv());
        this.convert = new ConvertType((IReadOnlyQueryEnvironment)base.getQryEnv());
        this.lookup = new AstLookup(base.environment, base.scopes, this.convert);
    }

    @Override
    public List<Message> validateModelBehavior(List<ModelUnit> units) {
        return NO_PROBLEM;
    }

    @Override
    public List<Message> validateModelUnit(ModelUnit unit) {
        return NO_PROBLEM;
    }

    @Override
    public List<Message> validateExtendedClass(ExtendedClass xtdClass) {
        EClass baseCls;
        ArrayList<Message> msgs = new ArrayList<Message>();
        msgs.addAll(this.validateBehavioredClass(xtdClass));
        if (this.isExtendingItself(xtdClass)) {
            msgs.add(this.messages.extendingItself(xtdClass));
        }
        if ((baseCls = xtdClass.getBaseClass()) != null) {
            EList superTypes = baseCls.getESuperTypes();
            List extendsBaseClasses = xtdClass.getExtends().stream().map(xtd -> xtd.getBaseClass()).collect(Collectors.toList());
            extendsBaseClasses.stream().filter(TypeValidator.noneOf((List<EClass>)superTypes, baseCls)).map(superBase -> this.messages.indirectExtension(xtdClass, (EClass)superBase, baseCls)).forEach(msgs::add);
        }
        return msgs;
    }

    private static Predicate<EClass> noneOf(List<EClass> superTypes, EClass baseCls) {
        return superBase -> !superTypes.contains(superBase) && baseCls != superBase;
    }

    @Override
    public List<Message> validateRuntimeClass(RuntimeClass classDef) {
        return this.validateBehavioredClass(classDef);
    }

    private List<Message> validateBehavioredClass(BehavioredClass clazz) {
        ArrayList<Message> msgs = new ArrayList<Message>();
        clazz.getAttributes().stream().filter(att -> this.typeChecker.isUnresolved((ETypedElement)att.getFeatureRef())).map(this.messages::unresolvedType).forEach(msgs::add);
        clazz.getAttributes().stream().filter(att -> att.getInitialValue() != null).forEach(att -> {
            Set<IType> valueTypes = this.lookup.inferredTypesOf(att.getInitialValue());
            IType declaredType = this.convert.toAQL((ETypedElement)att.getFeatureRef());
            msgs.addAll(this.validateAssignment(Sets.newHashSet((Object[])new IType[]{declaredType}), valueTypes, (EObject)att, att.getInitialValue()));
        });
        return msgs;
    }

    @Override
    public List<Message> validateMethod(Method mtd) {
        return NO_PROBLEM;
    }

    @Override
    public List<Message> validateFeatureAssignment(FeatureAssignment assignment) {
        Set<IType> valueTypes = this.lookup.inferredTypesOf(assignment.getValue());
        return this.validateAssignment(this.lookup.findFeatureTypes(assignment.getTargetFeature(), assignment.getTarget()), valueTypes, assignment, assignment.getValue());
    }

    @Override
    public List<Message> validateFeatureInsert(FeatureInsert insertion) {
        String featureName = insertion.getTargetFeature();
        Set<IType> variableTypes = this.lookup.findFeatureTypes(featureName, insertion.getTarget());
        Supplier<Message> unsupportedOperatorMessage = () -> this.messages.unsupportedOperatorOnFeature(variableTypes, insertion, featureName, Operator.ADDITION_ASSIGNMENT);
        return this.validateInsertionOrRemoval(variableTypes, insertion.getValue(), new InsertionStrategy(this.typeChecker, this.messages), unsupportedOperatorMessage);
    }

    @Override
    public List<Message> validateFeatureRemove(FeatureRemove removal) {
        String featureName = removal.getTargetFeature();
        Set<IType> variableTypes = this.lookup.findFeatureTypes(featureName, removal.getTarget());
        Supplier<Message> unsupportedOperatorMessage = () -> this.messages.unsupportedOperatorOnFeature(variableTypes, (EObject)removal.getTarget(), featureName, Operator.SUBSTRACTION_ASSIGNMENT);
        return this.validateInsertionOrRemoval(variableTypes, removal.getValue(), new RemovalStrategy(this.typeChecker, this.messages), unsupportedOperatorMessage);
    }

    @Override
    public List<Message> validateVariableAssignment(VariableAssignment assignment) {
        String assignedVariableName = assignment.getName();
        if ("self".equals(assignedVariableName)) {
            return PROBLEM_HANDLED_BY_ANOTHER_VALIDATOR;
        }
        Set<IType> variableTypes = this.lookup.typesDeclaredFor(assignedVariableName, assignment);
        Set<IType> valueTypes = this.lookup.inferredTypesOf(assignment.getValue());
        if ("result".equals(assignedVariableName)) {
            return this.validateAssignmentToResult(assignment, valueTypes);
        }
        return this.validateAssignment(variableTypes, valueTypes, assignment, assignment.getValue());
    }

    private List<Message> validateAssignmentToResult(VariableAssignment assignment, Set<IType> returnedValueTypes) {
        Method enclosingMethod = this.lookup.enclosingMethod(assignment);
        EOperation enclosingOperation = enclosingMethod.getOperationRef();
        if (enclosingOperation == null) {
            return PROBLEM_HANDLED_BY_ANOTHER_VALIDATOR;
        }
        IType operationReturnType = this.convert.toAQL((ETypedElement)enclosingOperation);
        boolean isVoidOperation = operationReturnType instanceof NothingType;
        if (isVoidOperation) {
            return PROBLEM_HANDLED_BY_ANOTHER_VALIDATOR;
        }
        return this.validateAssignment(Sets.newHashSet((Object[])new IType[]{operationReturnType}), returnedValueTypes, assignment, assignment.getValue());
    }

    private List<Message> validateAssignment(Set<IType> variableTypes, Set<IType> valueTypes, EObject assignment, Object value) {
        if (variableTypes.isEmpty()) {
            return PROBLEM_HANDLED_BY_ANOTHER_VALIDATOR;
        }
        boolean valueCanBeAssigned = variableTypes.stream().anyMatch(variableType -> this.typeChecker.isAssignable((IType)variableType, valueTypes));
        if (valueCanBeAssigned) {
            return NO_PROBLEM;
        }
        Message illegalAssignment = this.messages.illegalAssignment(variableTypes, valueTypes, assignment, value);
        return Arrays.asList(illegalAssignment);
    }

    private List<Message> validateInsertionOrRemoval(Set<IType> variableTypes, Expression value, IVariableModificationStrategy modif, Supplier<Message> unsupportedOperatorMessage) {
        boolean isUnableToDetermineVariableType = variableTypes.isEmpty();
        if (isUnableToDetermineVariableType) {
            return PROBLEM_HANDLED_BY_ANOTHER_VALIDATOR;
        }
        boolean modificationIsSupported = variableTypes.stream().anyMatch(modif::supportsModification);
        if (!modificationIsSupported) {
            Message unsupportedOperator = unsupportedOperatorMessage.get();
            return Arrays.asList(unsupportedOperator);
        }
        Set<IType> valueTypes = this.lookup.inferredTypesOf(value);
        boolean modificationIsAccepted = modif.acceptsModification(variableTypes, valueTypes);
        if (modificationIsAccepted) {
            return NO_PROBLEM;
        }
        Set<IType> acceptedValueTypes = modif.acceptedTypes(variableTypes);
        Message illegalModification = modif.createIllegalModificationMessage(variableTypes, valueTypes, acceptedValueTypes, value);
        return Arrays.asList(illegalModification);
    }

    @Override
    public List<Message> validateVariableDeclaration(VariableDeclaration varDecl) {
        Set<IType> valueTypes;
        if (this.typeChecker.isUnresolved(varDecl.getType())) {
            return Arrays.asList(this.messages.unresolvedType(varDecl));
        }
        if (varDecl.getInitialValue() == null) {
            return NO_PROBLEM;
        }
        IType variableType = this.convert.toAQL(varDecl.getType());
        boolean initialValueCanBeAssigned = this.typeChecker.isAssignable(variableType, valueTypes = this.lookup.inferredTypesOf(varDecl.getInitialValue()));
        if (initialValueCanBeAssigned) {
            return NO_PROBLEM;
        }
        Message incompatibleTypes = this.messages.illegalAssignment(Sets.newHashSet((Object[])new IType[]{variableType}), valueTypes, varDecl, varDecl.getInitialValue());
        return Arrays.asList(incompatibleTypes);
    }

    @Override
    public List<Message> validateVariableInsert(VariableInsert varInsert) {
        if ("self".equals(varInsert.getName())) {
            return Arrays.asList(this.messages.prohibitedInsertionToSelf(varInsert));
        }
        Set<IType> variableTypes = this.lookup.typesDeclaredFor(varInsert.getName(), varInsert);
        InsertionStrategy insertionStrategy = new InsertionStrategy(this.typeChecker, this.messages);
        if ("result".equals(varInsert.getName())) {
            return this.validateInsertionOrRemovalToResult(varInsert, insertionStrategy, Operator.ADDITION_ASSIGNMENT);
        }
        Supplier<Message> unsupportedOperatorMessage = () -> this.messages.unsupportedOperatorOnVariable(variableTypes, varInsert, varInsert.getName(), Operator.ADDITION_ASSIGNMENT);
        return this.validateInsertionOrRemoval(variableTypes, varInsert.getValue(), insertionStrategy, unsupportedOperatorMessage);
    }

    @Override
    public List<Message> validateVariableRemove(VariableRemove varRemove) {
        if ("self".equals(varRemove.getName())) {
            return Arrays.asList(this.messages.prohibitedRemovalFromSelf(varRemove));
        }
        Set<IType> variableTypes = this.lookup.typesDeclaredFor(varRemove.getName(), varRemove);
        RemovalStrategy removalStrategy = new RemovalStrategy(this.typeChecker, this.messages);
        if ("result".equals(varRemove.getName())) {
            return this.validateInsertionOrRemovalToResult(varRemove, removalStrategy, Operator.SUBSTRACTION_ASSIGNMENT);
        }
        Supplier<Message> unsupportedOperatorMessage = () -> this.messages.unsupportedOperatorOnVariable(variableTypes, varRemove, varRemove.getName(), Operator.SUBSTRACTION_ASSIGNMENT);
        return this.validateInsertionOrRemoval(variableTypes, varRemove.getValue(), removalStrategy, unsupportedOperatorMessage);
    }

    private List<Message> validateInsertionOrRemovalToResult(Assignment assignment, IVariableModificationStrategy modif, Operator operator) {
        boolean isVoidOperation;
        Method enclosingMethod = this.lookup.enclosingMethod(assignment);
        EOperation enclosingOperation = enclosingMethod.getOperationRef();
        if (enclosingOperation == null) {
            return PROBLEM_HANDLED_BY_ANOTHER_VALIDATOR;
        }
        boolean bl = isVoidOperation = enclosingOperation.getEType() == null && enclosingOperation.getEGenericType() == null || enclosingOperation.getEType() == ImplementationPackage.eINSTANCE.getVoidEClassifier();
        if (isVoidOperation) {
            return PROBLEM_HANDLED_BY_ANOTHER_VALIDATOR;
        }
        IType operationReturnType = this.convert.toAQL((ETypedElement)enclosingOperation);
        Supplier<Message> unsupportedOperatorMessage = () -> this.messages.unsupportedOperatorOnVariable(Sets.newHashSet((Object[])new IType[]{operationReturnType}), assignment, "result", operator);
        return this.validateInsertionOrRemoval(Sets.newHashSet((Object[])new IType[]{operationReturnType}), assignment.getValue(), modif, unsupportedOperatorMessage);
    }

    @Override
    public List<Message> validateForEach(ForEach loop) {
        boolean iteratesOverACollection = this.lookup.inferredTypesOf(loop.getCollectionExpression()).stream().anyMatch(type -> this.isIterable((IType)type));
        if (iteratesOverACollection) {
            return NO_PROBLEM;
        }
        return Arrays.asList(this.messages.forEachCanOnlyIterateOnCollections(loop));
    }

    private final boolean isIterable(IType type) {
        if (this.typeChecker.isCollection(type)) {
            return true;
        }
        if (type instanceof EClassifierType) {
            EClassifierType classifierType = (EClassifierType)type;
            return Objects.equal((Object)classifierType.getType(), (Object)EcorePackage.eINSTANCE.getEEList());
        }
        return false;
    }

    @Override
    public List<Message> validateIf(If ifStmt) {
        ArrayList<Message> res = new ArrayList<Message>();
        for (ConditionalBlock cBlock : ifStmt.getBlocks()) {
            res.addAll(this.validateIsBoolean(cBlock.getCondition()));
        }
        return res;
    }

    @Override
    public List<Message> validateWhile(While loop) {
        return this.validateIsBoolean(loop.getCondition());
    }

    private List<Message> validateIsBoolean(Expression exp) {
        if (this.typeChecker.isBoolean(exp)) {
            return NO_PROBLEM;
        }
        return Arrays.asList(this.messages.expectedBoolean(exp));
    }

    private boolean isExtendingItself(ExtendedClass xtdClass) {
        ArrayList todo = Lists.newArrayList((Object[])new ExtendedClass[]{xtdClass});
        ArrayList done = Lists.newArrayList();
        while (!todo.isEmpty()) {
            ExtendedClass current = (ExtendedClass)todo.get(0);
            if (done.contains(current)) {
                return true;
            }
            todo.addAll(current.getExtends());
            done.add(current);
            todo.remove(0);
        }
        return false;
    }
}

