/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.interpreter.internal.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecoretools.ale.core.Activator;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.sirius.common.tools.api.interpreter.ClassLoading;
import org.eclipse.sirius.common.tools.api.interpreter.ClasspathChangeCallback;
import org.eclipse.sirius.common.tools.api.interpreter.EPackageLoadingCallback;
import org.osgi.framework.Bundle;

public class AleEnvironmentClassLoading
implements ClassLoading {
    private final Map<String, URLClassLoader> projectsToClassLoader = new HashMap<String, URLClassLoader>();

    public Class<?> findClass(Set<String> viewpointProjects, Set<String> plugins, String qualifiedName) {
        Iterator<String> it;
        Class<?> result = null;
        IWorkspaceRoot root = EcorePlugin.getWorkspaceRoot();
        if (root != null) {
            it = viewpointProjects.iterator();
            while (result == null && it.hasNext()) {
                String projectName = it.next();
                ClassLoader loader = this.getOrCreateClassLoader(projectName, root);
                if (loader == null) continue;
                try {
                    result = loader.loadClass(qualifiedName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
            }
        }
        it = plugins.iterator();
        while (result == null && it.hasNext()) {
            Bundle bnd = Platform.getBundle((String)it.next());
            if (bnd == null) continue;
            try {
                result = bnd.loadClass(qualifiedName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public void dispose() {
        this.projectsToClassLoader.values().forEach(this::closeClassLoader);
        this.projectsToClassLoader.clear();
    }

    private void closeClassLoader(URLClassLoader old) {
        try {
            old.close();
        }
        catch (IOException e) {
            Activator.error(e.getMessage(), e);
        }
    }

    public void setClasspathChangeCallback(ClasspathChangeCallback listener) {
    }

    public Collection<EPackageLoadingCallback.EPackageDeclarationSource> findEcoreDeclarations(Set<String> projects, Set<String> plugins) {
        return Collections.emptyList();
    }

    private ClassLoader getOrCreateClassLoader(String projectName, IWorkspaceRoot root) {
        URLClassLoader existing = this.projectsToClassLoader.get(projectName);
        if (existing == null && (existing = AleEnvironmentClassLoading.createClassLoader(projectName, root)) != null) {
            this.projectsToClassLoader.put(projectName, existing);
        }
        return existing;
    }

    private static URLClassLoader createClassLoader(String projectName, IWorkspaceRoot root) {
        IPluginModelBase pluginModel = AleEnvironmentClassLoading.getBundleForProject(projectName);
        List<Object> urls = new ArrayList();
        IResource res = pluginModel.getUnderlyingResource();
        if (res != null) {
            urls = AleEnvironmentClassLoading.computeURLs(res.getProject());
        }
        URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), AleEnvironmentClassLoading.class.getClassLoader()){

            @Override
            public Class<?> findClass(String name) throws ClassNotFoundException {
                try {
                    return super.findClass(name);
                }
                catch (Throwable e) {
                    return null;
                }
            }
        };
        return loader;
    }

    private static IPluginModelBase getBundleForProject(String projectName) {
        for (IPluginModelBase pluginModelBase : Arrays.asList(PluginRegistry.getWorkspaceModels())) {
            try {
                boolean isBundleForProject = pluginModelBase.getBundleDescription().getSymbolicName().equals(projectName);
                if (!isBundleForProject) continue;
                return pluginModelBase;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return null;
    }

    private static List<URL> computeURLs(IProject project) {
        ArrayList<URL> uRLs;
        block9: {
            uRLs = new ArrayList<URL>();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                IFolder reference;
                IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(true);
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile reference2;
                    IPath output;
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3 && (output = entry.getOutputLocation()) != null && (reference2 = ResourcesPlugin.getWorkspace().getRoot().getFile(output)).exists()) {
                        try {
                            URL url = reference2.getLocation().toFile().toURI().toURL();
                            uRLs.add(url);
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
                IPath output = javaProject.getOutputLocation();
                if (output == null || !(reference = ResourcesPlugin.getWorkspace().getRoot().getFolder(output)).exists() || reference.getLocation() == null) break block9;
                File file = reference.getLocation().toFile();
                try {
                    if (file != null && file.exists()) {
                        uRLs.add(file.toURI().toURL());
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return uRLs;
    }
}

