/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.resources.editor.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorPlugin;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.util.DiagramFileCreator;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class EditorUtil {
    public static IFile createNewDiagramFile(DiagramFileCreator diagramFileCreator, IPath containerFullPath, String fileName, InputStream initialContents, String kind, Shell shell, final IProgressMonitor progressMonitor, PreferencesHint preferencesHint) {
        Diagram view;
        IFile newDiagramFile = diagramFileCreator.createNewFile(containerFullPath, fileName, initialContents, shell, new IRunnableContext(){

            public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
                runnable.run(progressMonitor);
            }
        });
        Resource notationModel = null;
        try {
            newDiagramFile.refreshLocal(0, null);
            InputStream stream = newDiagramFile.getContents();
            String completeFileName = newDiagramFile.getFullPath().toString();
            try {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                notationModel = resourceSet.createResource(URI.createPlatformResourceURI((String)completeFileName, (boolean)true));
            }
            finally {
                stream.close();
            }
        }
        catch (Exception e) {
            Trace.catching((Plugin)EditorPlugin.getInstance(), (String)EditorDebugOptions.EXCEPTIONS_CATCHING, EditorUtil.class, (String)"createNewDiagramFile", (Throwable)e);
        }
        if (notationModel != null && (view = ViewService.createDiagram((String)kind, (PreferencesHint)preferencesHint)) != null) {
            notationModel.getContents().add((Object)view.getDiagram());
            view.getDiagram().setName(newDiagramFile.getName());
        }
        try {
            notationModel.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            Trace.catching((Plugin)EditorPlugin.getInstance(), (String)EditorDebugOptions.EXCEPTIONS_CATCHING, EditorUtil.class, (String)"createNewDiagramFile", (Throwable)e);
            Log.error((Plugin)EditorPlugin.getInstance(), (int)5, (String)e.getLocalizedMessage());
        }
        return newDiagramFile;
    }

    public static IPath getDefaultDiagramPath(List elements, String diagramKind) {
        IPath path = null;
        return path;
    }

    public static InputStream getInitialContents() {
        return new ByteArrayInputStream(new byte[0]);
    }
}

