/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.launching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.LaunchPluginValidator;
import org.eclipse.pde.internal.launching.launcher.OSGiFrameworkManager;

public class OSGiLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String id;
        OSGiFrameworkManager manager = PDELaunchingPlugin.getDefault().getOSGiFrameworkManager();
        LaunchConfigurationDelegate launcher = manager.getFrameworkLauncher(id = configuration.getAttribute("osgi_framework_id", manager.getDefaultFramework()));
        if (launcher == null) {
            String name = manager.getFrameworkName(id);
            if (name == null) {
                name = PDEMessages.OSGiLaunchConfiguration_selected;
            }
            String message = NLS.bind((String)PDEMessages.OSGiLaunchConfiguration_cannotFindLaunchConfiguration, (Object)name);
            Status status = new Status(4, "org.eclipse.pde.launching", 0, message, null);
            throw new CoreException((IStatus)status);
        }
        launcher.launch(configuration, mode, launch, monitor);
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.computeBuildOrder(LaunchPluginValidator.getAffectedProjects(configuration));
    }
}

