/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;

final class CompilationUnitCompletion
extends CompletionRequestor {
    private ICompilationUnit fUnit;
    private List<Variable> fLocalVariables = new ArrayList<Variable>();
    private List<Variable> fFields = new ArrayList<Variable>();
    private Map<String, String> fLocalTypes = new HashMap<String, String>();
    private boolean fError;

    CompilationUnitCompletion(ICompilationUnit unit) {
        this.reset(unit);
        this.setIgnored(1, true);
        this.setIgnored(27, true);
        this.setIgnored(3, true);
        this.setIgnored(4, true);
        this.setIgnored(7, true);
        this.setIgnored(12, true);
        this.setIgnored(6, true);
        this.setIgnored(26, true);
        this.setIgnored(24, true);
        this.setIgnored(8, true);
        this.setIgnored(29, true);
        this.setIgnored(28, true);
        this.setIgnored(11, true);
        this.setIgnored(10, true);
        this.setIgnored(9, true);
    }

    private void reset(ICompilationUnit unit) {
        this.fUnit = unit;
        this.fLocalVariables.clear();
        this.fFields.clear();
        this.fLocalTypes.clear();
        if (this.fUnit != null) {
            try {
                IType[] cuTypes;
                IType[] iTypeArray = cuTypes = this.fUnit.getAllTypes();
                int n = cuTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType cuType = iTypeArray[n2];
                    String fqn = cuType.getFullyQualifiedName();
                    String sig = Signature.createTypeSignature((String)fqn, (boolean)true);
                    this.fLocalTypes.put(sig, cuType.getElementName());
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        this.fError = false;
    }

    public void accept(CompletionProposal proposal) {
        String name = String.valueOf(proposal.getCompletion());
        String signature = String.valueOf(proposal.getSignature());
        switch (proposal.getKind()) {
            case 5: {
                this.fLocalVariables.add(new Variable(name, signature));
                break;
            }
            case 2: {
                this.fFields.add(new Variable(name, signature));
                break;
            }
        }
    }

    public void completionFailure(IProblem problem) {
        this.fError = true;
    }

    public boolean hasErrors() {
        return this.fError;
    }

    public String[] getLocalVariableNames() {
        String[] names = new String[this.fLocalVariables.size()];
        int i = 0;
        ListIterator<Variable> iterator = this.fLocalVariables.listIterator(this.fLocalVariables.size());
        while (iterator.hasPrevious()) {
            Variable localVariable = iterator.previous();
            names[i++] = localVariable.getName();
        }
        return names;
    }

    public String[] getFieldNames() {
        String[] names = new String[this.fFields.size()];
        int i = 0;
        ListIterator<Variable> iterator = this.fFields.listIterator(this.fFields.size());
        while (iterator.hasPrevious()) {
            Variable field = iterator.previous();
            names[i++] = field.getName();
        }
        return names;
    }

    public Variable[] findArraysInCurrentScope() {
        ArrayList<Variable> arrays = new ArrayList<Variable>();
        ListIterator<Variable> iterator = this.fLocalVariables.listIterator(this.fLocalVariables.size());
        while (iterator.hasPrevious()) {
            Variable localVariable = iterator.previous();
            if (!localVariable.isArray()) continue;
            arrays.add(localVariable);
        }
        iterator = this.fFields.listIterator(this.fFields.size());
        while (iterator.hasPrevious()) {
            Variable field = iterator.previous();
            if (!field.isArray()) continue;
            arrays.add(field);
        }
        return arrays.toArray(new Variable[arrays.size()]);
    }

    public Variable[] findLocalVariables(String clazz) {
        ArrayList<Variable> matches = new ArrayList<Variable>();
        ListIterator<Variable> iterator = this.fLocalVariables.listIterator(this.fLocalVariables.size());
        while (iterator.hasPrevious()) {
            Variable localVariable = iterator.previous();
            if (!localVariable.isSubtypeOf(clazz)) continue;
            matches.add(localVariable);
        }
        return matches.toArray(new Variable[matches.size()]);
    }

    public Variable[] findFieldVariables(String clazz) {
        ArrayList<Variable> matches = new ArrayList<Variable>();
        ListIterator<Variable> iterator = this.fFields.listIterator(this.fFields.size());
        while (iterator.hasPrevious()) {
            Variable localVariable = iterator.previous();
            if (!localVariable.isSubtypeOf(clazz)) continue;
            matches.add(localVariable);
        }
        return matches.toArray(new Variable[matches.size()]);
    }

    public Variable[] findIterablesInCurrentScope() {
        ArrayList<Variable> iterables = new ArrayList<Variable>();
        ListIterator<Variable> iterator = this.fLocalVariables.listIterator(this.fLocalVariables.size());
        while (iterator.hasPrevious()) {
            Variable localVariable = iterator.previous();
            if (!localVariable.isArray() && !localVariable.isIterable()) continue;
            iterables.add(localVariable);
        }
        iterator = this.fFields.listIterator(this.fFields.size());
        while (iterator.hasPrevious()) {
            Variable field = iterator.previous();
            if (!field.isArray() && !field.isIterable()) continue;
            iterables.add(field);
        }
        return iterables.toArray(new Variable[iterables.size()]);
    }

    private final class TypeParameterResolver {
        private static final String OBJECT_SIGNATURE = "Ljava.lang.Object;";
        private final ITypeHierarchy fHierarchy;
        private final Variable fVariable;
        private final IType fType;
        private final List<String> fBounds = new ArrayList<String>();

        public TypeParameterResolver(Variable variable) throws JavaModelException {
            String typeName = SignatureUtil.stripSignatureToFQN(variable.signature);
            IJavaProject project = CompilationUnitCompletion.this.fUnit.getJavaProject();
            this.fType = project.findType(typeName);
            this.fHierarchy = this.fType.newSupertypeHierarchy(null);
            this.fVariable = variable;
        }

        public String[] computeBinding(String superType, int index) throws JavaModelException, IndexOutOfBoundsException {
            IJavaProject project = CompilationUnitCompletion.this.fUnit.getJavaProject();
            IType type = project.findType(superType);
            if (type == null) {
                throw new JavaModelException(new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core.manipulation", 0, "No such type", null)));
            }
            return this.computeBinding(type, index);
        }

        public String[] computeBinding(IType superType, int index) throws JavaModelException, IndexOutOfBoundsException {
            this.initBounds();
            this.computeTypeParameterBinding(superType, index);
            return this.fBounds.toArray(new String[this.fBounds.size()]);
        }

        private void computeTypeParameterBinding(IType superType, int index) throws JavaModelException, IndexOutOfBoundsException {
            int nParameters = superType.getTypeParameters().length;
            if (nParameters <= index) {
                throw new IndexOutOfBoundsException();
            }
            IType[] subTypes = this.fHierarchy.getSubtypes(superType);
            if (subTypes.length == 0) {
                Assert.isTrue((boolean)superType.equals(this.fType));
                String match = this.findMatchingTypeArgument(this.fVariable.signature, index, CompilationUnitCompletion.this.fUnit.findPrimaryType());
                String bound = SignatureUtil.getUpperBound(match);
                this.addBound(bound);
                return;
            }
            IType subType = subTypes[0];
            String signature = this.findMatchingSuperTypeSignature(subType, superType);
            String match = this.findMatchingTypeArgument(signature, index, subType);
            if (this.isConcreteType(match, subType)) {
                this.addBound(match);
                return;
            }
            ITypeParameter[] typeParameters = subType.getTypeParameters();
            int k = 0;
            while (k < typeParameters.length) {
                ITypeParameter formalParameter = typeParameters[k];
                if (formalParameter.getElementName().equals(SignatureUtil.stripSignatureToFQN(match))) {
                    String[] bounds;
                    String[] stringArray = bounds = formalParameter.getBounds();
                    int n = bounds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String bound = stringArray[n2];
                        String boundSignature = Signature.createTypeSignature((String)bound, (boolean)true);
                        this.addBound(SignatureUtil.qualifySignature(boundSignature, subType));
                        ++n2;
                    }
                    this.computeTypeParameterBinding(subType, k);
                    return;
                }
                ++k;
            }
            this.addBound(match);
        }

        private String findMatchingTypeArgument(String signature, int index, IType context) throws IndexOutOfBoundsException {
            String[] typeArguments = Signature.getTypeArguments((String)signature);
            if (typeArguments.length > 0 && typeArguments.length <= index) {
                throw new IndexOutOfBoundsException();
            }
            if (typeArguments.length == 0) {
                return OBJECT_SIGNATURE;
            }
            String bound = SignatureUtil.getUpperBound(typeArguments[index]);
            return SignatureUtil.qualifySignature(bound, context);
        }

        private String findMatchingSuperTypeSignature(IType subType, IType superType) throws JavaModelException {
            String[] signatures;
            String[] stringArray = signatures = this.getSuperTypeSignatures(subType, superType);
            int n = signatures.length;
            int n2 = 0;
            while (n2 < n) {
                String superFQN;
                String signature = stringArray[n2];
                String qualified = SignatureUtil.qualifySignature(signature, subType);
                String subFQN = SignatureUtil.stripSignatureToFQN(qualified);
                if (subFQN.equals(superFQN = superType.getFullyQualifiedName())) {
                    return signature;
                }
                if (CompilationUnitCompletion.this.fLocalTypes.containsValue(subFQN)) {
                    return signature;
                }
                ++n2;
            }
            throw new JavaModelException(new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core.manipulation", 0, "Illegal hierarchy", null)));
        }

        private String[] getSuperTypeSignatures(IType subType, IType superType) throws JavaModelException {
            if (superType.isInterface()) {
                return subType.getSuperInterfaceTypeSignatures();
            }
            return new String[]{subType.getSuperclassTypeSignature()};
        }

        private void initBounds() {
            this.fBounds.clear();
            this.fBounds.add(OBJECT_SIGNATURE);
        }

        private void addBound(String boundSignature) {
            if (SignatureUtil.isJavaLangObject(boundSignature)) {
                return;
            }
            boolean found = false;
            ListIterator<String> it = this.fBounds.listIterator();
            while (it.hasNext()) {
                String old = it.next();
                if (!this.isTrueSubtypeOf(boundSignature, old)) continue;
                if (!found) {
                    it.set(boundSignature);
                    found = true;
                    continue;
                }
                it.remove();
            }
            if (!found) {
                this.fBounds.add(boundSignature);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isTrueSubtypeOf(String subTypeSignature, String superTypeSignature) {
            if (subTypeSignature.equals(superTypeSignature)) {
                return true;
            }
            if (SignatureUtil.isJavaLangObject(subTypeSignature)) {
                return false;
            }
            if (Signature.getTypeSignatureKind((String)subTypeSignature) != 2 && SignatureUtil.isJavaLangObject(superTypeSignature)) {
                return true;
            }
            IJavaProject project = CompilationUnitCompletion.this.fUnit.getJavaProject();
            try {
                IType[] types;
                if ((Signature.getTypeSignatureKind((String)subTypeSignature) & 3) == 0) {
                    return false;
                }
                IType subType = project.findType(SignatureUtil.stripSignatureToFQN(subTypeSignature));
                if (subType == null) {
                    return false;
                }
                if ((Signature.getTypeSignatureKind((String)superTypeSignature) & 3) == 0) {
                    return false;
                }
                IType superType = project.findType(SignatureUtil.stripSignatureToFQN(superTypeSignature));
                if (superType == null) {
                    return false;
                }
                ITypeHierarchy hierarchy = subType.newSupertypeHierarchy(null);
                IType[] iTypeArray = types = hierarchy.getAllSupertypes(subType);
                int n = types.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    IType type = iTypeArray[n2];
                    if (type.equals(superType)) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
            return false;
        }

        private boolean isConcreteType(String signature, IType context) throws JavaModelException {
            if (3 == Signature.getTypeSignatureKind((String)signature)) {
                return false;
            }
            if (context.isBinary()) {
                return CompilationUnitCompletion.this.fUnit.getJavaProject().findType(SignatureUtil.stripSignatureToFQN(signature)) != null;
            }
            return context.resolveType(SignatureUtil.stripSignatureToFQN(signature)) != null;
        }
    }

    public final class Variable {
        private static final int UNKNOWN = 0;
        private static final int NONE = 0;
        private static final int ARRAY = 1;
        private static final int COLLECTION = 2;
        private static final int ITERABLE = 4;
        private final String name;
        private final String signature;
        private int fType = 0;
        private int fChecked = 0;
        private String[] fMemberTypes;

        private Variable(String name, String signature) {
            this.name = name;
            this.signature = signature;
        }

        public String getName() {
            return this.name;
        }

        public boolean isArray() {
            if (this.fType == 0 && (this.fChecked & 1) == 0 && Signature.getTypeSignatureKind((String)this.signature) == 4) {
                this.fType = 1;
            }
            this.fChecked |= 1;
            return this.fType == 1;
        }

        public boolean isCollection() {
            if ((this.fType == 0 || this.fType == 4) && (this.fChecked & 2) == 0 && this.isSubtypeOf("java.util.Collection")) {
                this.fType = 2;
            }
            this.fChecked |= 2;
            return this.fType == 2;
        }

        public boolean isIterable() {
            if (this.fType == 0 && (this.fChecked & 4) == 0 && this.isSubtypeOf("java.lang.Iterable")) {
                this.fType = 4;
            }
            this.fChecked |= 4;
            return this.fType == 4 || this.fType == 2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isSubtypeOf(String supertype) {
            int superDims;
            String implementorName = SignatureUtil.stripSignatureToFQN(this.signature);
            if (implementorName.length() == 0) {
                return false;
            }
            int implementorDims = Signature.getArrayCount((String)this.signature);
            int superDimsIndex = supertype.indexOf("[]");
            if (superDimsIndex != -1) {
                superDims = (supertype.length() - superDimsIndex) / 2;
                supertype = supertype.substring(0, superDimsIndex);
            } else {
                superDims = 0;
            }
            if (implementorDims > superDims) {
                return "java.lang.Object".equals(supertype);
            }
            if (superDims != implementorDims) {
                return false;
            }
            boolean qualified = supertype.indexOf(46) != -1;
            if (implementorName.equals(supertype)) return true;
            if (!qualified && Signature.getSimpleName((String)implementorName).equals(supertype)) {
                return true;
            }
            if (CompilationUnitCompletion.this.fUnit == null) {
                return false;
            }
            IJavaProject project = CompilationUnitCompletion.this.fUnit.getJavaProject();
            try {
                IType[] allTypes;
                IType sub = project.findType(implementorName);
                if (sub == null) {
                    return false;
                }
                if (qualified) {
                    IType sup = project.findType(supertype);
                    if (sup == null) {
                        return false;
                    }
                    ITypeHierarchy hierarchy = sub.newSupertypeHierarchy(null);
                    return hierarchy.contains(sup);
                }
                ITypeHierarchy hierarchy = sub.newSupertypeHierarchy(null);
                IType[] iTypeArray = allTypes = hierarchy.getAllTypes();
                int n = allTypes.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    IType type = iTypeArray[n2];
                    if (type.getElementName().equals(supertype)) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
            return false;
        }

        private IType[] getSupertypes(String supertype) {
            boolean qualified;
            IType[] empty = new IType[]{};
            String implementorName = SignatureUtil.stripSignatureToFQN(this.signature);
            if (implementorName.length() == 0) {
                return empty;
            }
            boolean bl = qualified = supertype.indexOf(46) != -1;
            if (CompilationUnitCompletion.this.fUnit == null) {
                return empty;
            }
            IJavaProject project = CompilationUnitCompletion.this.fUnit.getJavaProject();
            try {
                IType sub = project.findType(implementorName);
                if (sub == null) {
                    return empty;
                }
                if (qualified) {
                    IType sup = project.findType(supertype);
                    if (sup == null) {
                        return empty;
                    }
                    return new IType[]{sup};
                }
                ITypeHierarchy hierarchy = sub.newSupertypeHierarchy(null);
                IType[] allTypes = hierarchy.getAllTypes();
                ArrayList<IType> matches = new ArrayList<IType>();
                IType[] iTypeArray = allTypes;
                int n = allTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    if (type.getElementName().equals(supertype)) {
                        matches.add(type);
                    }
                    ++n2;
                }
                return matches.toArray(new IType[matches.size()]);
            }
            catch (JavaModelException javaModelException) {
                return empty;
            }
        }

        public String getMemberTypeSignature() {
            return this.getMemberTypeSignatures()[0];
        }

        public String[] getMemberTypeSignatures() {
            if (this.isArray()) {
                return new String[]{Signature.createArraySignature((String)Signature.getElementType((String)this.signature), (int)(Signature.getArrayCount((String)this.signature) - 1))};
            }
            if (CompilationUnitCompletion.this.fUnit != null && (this.isIterable() || this.isCollection())) {
                if (this.fMemberTypes == null) {
                    try {
                        try {
                            TypeParameterResolver util = new TypeParameterResolver(this);
                            this.fMemberTypes = util.computeBinding("java.lang.Iterable", 0);
                        }
                        catch (JavaModelException javaModelException) {
                            try {
                                TypeParameterResolver util = new TypeParameterResolver(this);
                                this.fMemberTypes = util.computeBinding("java.util.Collection", 0);
                            }
                            catch (JavaModelException javaModelException2) {
                                this.fMemberTypes = new String[0];
                            }
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        this.fMemberTypes = new String[0];
                    }
                }
                if (this.fMemberTypes.length > 0) {
                    return this.fMemberTypes;
                }
            }
            return new String[]{Signature.createTypeSignature((String)"java.lang.Object", (boolean)true)};
        }

        public String[] getMemberTypeNames() {
            String[] signatures = this.getMemberTypeSignatures();
            String[] names = new String[signatures.length];
            int i = 0;
            while (i < signatures.length) {
                String sig = signatures[i];
                String local = CompilationUnitCompletion.this.fLocalTypes.get(Signature.getElementType((String)sig));
                int dim = Signature.getArrayCount((String)sig);
                if (local != null && dim > 0) {
                    StringBuilder array = new StringBuilder(local);
                    int j = 0;
                    while (j < dim) {
                        array.append("[]");
                        ++j;
                    }
                    local = array.toString();
                }
                names[i] = local != null ? local : Signature.getSimpleName((String)Signature.getSignatureSimpleName((String)sig));
                ++i;
            }
            return names;
        }

        public String[] getTypeArgumentBoundSignatures(String type, int index) {
            ArrayList<String> all = new ArrayList<String>();
            IType[] supertypes = this.getSupertypes(type);
            if (CompilationUnitCompletion.this.fUnit != null) {
                IType[] iTypeArray = supertypes;
                int n = supertypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType supertype = iTypeArray[n2];
                    try {
                        TypeParameterResolver util = new TypeParameterResolver(this);
                        String[] result = util.computeBinding(supertype.getFullyQualifiedName(), index);
                        all.addAll(Arrays.asList(result));
                    }
                    catch (IndexOutOfBoundsException | JavaModelException throwable) {}
                    ++n2;
                }
            }
            if (all.isEmpty()) {
                return new String[]{Signature.createTypeSignature((String)"java.lang.Object", (boolean)true)};
            }
            return all.toArray(new String[all.size()]);
        }

        public String toString() {
            String type;
            switch (this.fType) {
                case 4: {
                    type = "ITERABLE";
                    break;
                }
                case 2: {
                    type = "COLLECTION";
                    break;
                }
                case 1: {
                    type = "ARRAY";
                    break;
                }
                default: {
                    type = "UNKNOWN";
                }
            }
            return "LocalVariable [name=\"" + this.name + "\" signature=\"" + this.signature + "\" type=\"" + type + "\" member=\"" + this.getMemberTypeSignature() + "\"]";
        }
    }
}

