/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.support;

import java.io.File;
import org.eclipse.gemini.web.tomcat.internal.support.BundleFileResolver;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EquinoxBundleFileResolver
implements BundleFileResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(EquinoxBundleFileResolver.class);

    EquinoxBundleFileResolver() {
    }

    @Override
    public File resolve(Bundle bundle) {
        BundleFile bundleFile = this.getBundleFile(bundle);
        if (bundleFile != null) {
            File file = bundleFile.getBaseFile();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolved bundle '" + bundle.getSymbolicName() + "' to file '" + file.getAbsolutePath() + "'");
            }
            return file;
        }
        return null;
    }

    @Override
    public long resolveBundleEntrySize(Bundle bundle, String path) {
        BundleEntry bundleEntry;
        BundleFile bundleFile = this.getBundleFile(bundle);
        if (bundleFile != null && (bundleEntry = bundleFile.getEntry(path)) != null) {
            return bundleEntry.getSize();
        }
        return -1L;
    }

    public static boolean canUse() {
        try {
            EquinoxBundleFileResolver.class.getClassLoader().loadClass(EquinoxBundle.class.getName());
            return true;
        }
        catch (Exception | LinkageError throwable) {
            return false;
        }
    }

    private BundleFile getBundleFile(Bundle bundle) {
        if (bundle instanceof EquinoxBundle) {
            EquinoxBundle eb = (EquinoxBundle)bundle;
            BundleInfo.Generation current = (BundleInfo.Generation)eb.getModule().getCurrentRevision().getRevisionInfo();
            return current.getBundleFile();
        }
        return null;
    }
}

