/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.diagram.navigator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.simplemap.diagram.navigator.SimplemapNavigatorGroup;
import org.eclipse.gmf.tooling.simplemap.diagram.navigator.SimplemapNavigatorItem;
import org.eclipse.gmf.tooling.simplemap.diagram.part.SimplemapDiagramEditorPlugin;
import org.eclipse.gmf.tooling.simplemap.diagram.part.SimplemapVisualIDRegistry;
import org.eclipse.gmf.tooling.simplemap.diagram.providers.SimplemapElementTypes;
import org.eclipse.gmf.tooling.simplemap.diagram.providers.SimplemapParserProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class SimplemapNavigatorLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
ITreePathLabelProvider {
    static {
        SimplemapDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?UnknownElement", ImageDescriptor.getMissingImageDescriptor());
        SimplemapDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?ImageNotFound", ImageDescriptor.getMissingImageDescriptor());
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Object element = elementPath.getLastSegment();
        if (element instanceof SimplemapNavigatorItem && !this.isOwnView(((SimplemapNavigatorItem)((Object)element)).getView())) {
            return;
        }
        label.setText(this.getText(element));
        label.setImage(this.getImage(element));
    }

    public Image getImage(Object element) {
        if (element instanceof SimplemapNavigatorGroup) {
            SimplemapNavigatorGroup group = (SimplemapNavigatorGroup)((Object)element);
            return SimplemapDiagramEditorPlugin.getInstance().getBundledImage(group.getIcon());
        }
        if (element instanceof SimplemapNavigatorItem) {
            SimplemapNavigatorItem navigatorItem = (SimplemapNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return super.getImage(element);
            }
            return this.getImage(navigatorItem.getView());
        }
        return super.getImage(element);
    }

    public Image getImage(View view) {
        switch (SimplemapVisualIDRegistry.getVisualID(view)) {
            case 79: {
                return this.getImage("Navigator?Diagram?http://org.msl.simple.gmfmap/simplemappings_1.1?SimpleMapping", SimplemapElementTypes.SimpleMapping_79);
            }
            case 1001: {
                return this.getImage("Navigator?TopLevelNode?http://org.msl.simple.gmfmap/simplemappings_1.1?SimpleTopNode", SimplemapElementTypes.SimpleTopNode_1001);
            }
            case 1002: {
                return this.getImage("Navigator?TopLevelNode?http://org.msl.simple.gmfmap/simplemappings_1.1?SimpleLinkMapping", SimplemapElementTypes.SimpleLinkMapping_1002);
            }
            case 2001: {
                return this.getImage("Navigator?Node?http://org.msl.simple.gmfmap/simplemappings_1.1?SimpleLabelNode", SimplemapElementTypes.SimpleLabelNode_2001);
            }
            case 2002: {
                return this.getImage("Navigator?Node?http://org.msl.simple.gmfmap/simplemappings_1.1?SimpleCompartment", SimplemapElementTypes.SimpleCompartment_2002);
            }
            case 2003: {
                return this.getImage("Navigator?Node?http://org.msl.simple.gmfmap/simplemappings_1.1?SimpleSubNode", SimplemapElementTypes.SimpleSubNode_2003);
            }
            case 2004: {
                return this.getImage("Navigator?Node?http://org.msl.simple.gmfmap/simplemappings_1.1?SimpleChildReference", SimplemapElementTypes.SimpleChildReference_2004);
            }
        }
        return this.getImage("Navigator?UnknownElement", null);
    }

    private Image getImage(String key, IElementType elementType) {
        ImageRegistry imageRegistry = SimplemapDiagramEditorPlugin.getInstance().getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null && elementType != null && SimplemapElementTypes.isKnownElementType(elementType)) {
            image = SimplemapElementTypes.getImage((IAdaptable)elementType);
            imageRegistry.put(key, image);
        }
        if (image == null) {
            image = imageRegistry.get("Navigator?ImageNotFound");
            imageRegistry.put(key, image);
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof SimplemapNavigatorGroup) {
            SimplemapNavigatorGroup group = (SimplemapNavigatorGroup)((Object)element);
            return group.getGroupName();
        }
        if (element instanceof SimplemapNavigatorItem) {
            SimplemapNavigatorItem navigatorItem = (SimplemapNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return null;
            }
            return this.getText(navigatorItem.getView());
        }
        return super.getText(element);
    }

    public String getText(View view) {
        if (view.getElement() != null && view.getElement().eIsProxy()) {
            return this.getUnresolvedDomainElementProxyText(view);
        }
        switch (SimplemapVisualIDRegistry.getVisualID(view)) {
            case 79: {
                return this.getSimpleMapping_79Text(view);
            }
            case 1001: {
                return this.getSimpleTopNode_1001Text(view);
            }
            case 1002: {
                return this.getSimpleLinkMapping_1002Text(view);
            }
            case 2001: {
                return this.getSimpleLabelNode_2001Text(view);
            }
            case 2002: {
                return this.getSimpleCompartment_2002Text(view);
            }
            case 2003: {
                return this.getSimpleSubNode_2003Text(view);
            }
            case 2004: {
                return this.getSimpleChildReference_2004Text(view);
            }
        }
        return this.getUnknownElementText(view);
    }

    private String getSimpleMapping_79Text(View view) {
        return "";
    }

    private String getSimpleTopNode_1001Text(View view) {
        IParser parser = SimplemapParserProvider.getParser(SimplemapElementTypes.SimpleTopNode_1001, (EObject)(view.getElement() != null ? view.getElement() : view), SimplemapVisualIDRegistry.getType(4003));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        SimplemapDiagramEditorPlugin.getInstance().logError("Parser was not found for label 4003");
        return "";
    }

    private String getSimpleLinkMapping_1002Text(View view) {
        IParser parser = SimplemapParserProvider.getParser(SimplemapElementTypes.SimpleLinkMapping_1002, (EObject)(view.getElement() != null ? view.getElement() : view), SimplemapVisualIDRegistry.getType(4004));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        SimplemapDiagramEditorPlugin.getInstance().logError("Parser was not found for label 4004");
        return "";
    }

    private String getSimpleLabelNode_2001Text(View view) {
        IParser parser = SimplemapParserProvider.getParser(SimplemapElementTypes.SimpleLabelNode_2001, (EObject)(view.getElement() != null ? view.getElement() : view), SimplemapVisualIDRegistry.getType(2001));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        SimplemapDiagramEditorPlugin.getInstance().logError("Parser was not found for label 2001");
        return "";
    }

    private String getSimpleCompartment_2002Text(View view) {
        IParser parser = SimplemapParserProvider.getParser(SimplemapElementTypes.SimpleCompartment_2002, (EObject)(view.getElement() != null ? view.getElement() : view), SimplemapVisualIDRegistry.getType(4002));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        SimplemapDiagramEditorPlugin.getInstance().logError("Parser was not found for label 4002");
        return "";
    }

    private String getSimpleSubNode_2003Text(View view) {
        IParser parser = SimplemapParserProvider.getParser(SimplemapElementTypes.SimpleSubNode_2003, (EObject)(view.getElement() != null ? view.getElement() : view), SimplemapVisualIDRegistry.getType(4001));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        SimplemapDiagramEditorPlugin.getInstance().logError("Parser was not found for label 4001");
        return "";
    }

    private String getSimpleChildReference_2004Text(View view) {
        IParser parser = SimplemapParserProvider.getParser(SimplemapElementTypes.SimpleChildReference_2004, (EObject)(view.getElement() != null ? view.getElement() : view), SimplemapVisualIDRegistry.getType(2004));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        SimplemapDiagramEditorPlugin.getInstance().logError("Parser was not found for label 2004");
        return "";
    }

    private String getUnknownElementText(View view) {
        return "<UnknownElement Visual_ID = " + view.getType() + ">";
    }

    private String getUnresolvedDomainElementProxyText(View view) {
        return "<Unresolved domain element Visual_ID = " + view.getType() + ">";
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return null;
    }

    private boolean isOwnView(View view) {
        return "Simplemap".equals(SimplemapVisualIDRegistry.getModelID(view));
    }
}

