/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.policies.assistant;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.graphdef.editor.edit.policies.assistant.SelectableBubbleItemFigure;
import org.eclipse.gmf.runtime.draw2d.ui.graphics.GCUtilities;

public class BubbleFigure
extends Shape {
    private static final int CORNER_SIZE = 8;
    private static final int TAIL_WIDTH = 5;
    private static final int TAIL_HEIGHT = 5;
    private static final int HORIZONTAL_CHILDREN_INSET = 2;
    private Mode myMode;

    public BubbleFigure() {
        this.setRequestFocusEnabled(true);
        this.setLineStyle(2);
        this.setForegroundColor(ColorConstants.lightGray);
        this.setBackgroundColor(ColorConstants.white);
        FlowLayout layout = new FlowLayout();
        layout.setMinorSpacing(0);
        this.setLayoutManager((LayoutManager)layout);
        this.setBorder((Border)new MarginBorder(0, 7, 5, 2));
    }

    public void selectChild(SelectableBubbleItemFigure child) {
        for (Object childFigure : this.getChildren()) {
            if (!(childFigure instanceof SelectableBubbleItemFigure)) continue;
            if (childFigure == child) {
                ((SelectableBubbleItemFigure)((Object)childFigure)).setSelected(true);
                continue;
            }
            ((SelectableBubbleItemFigure)((Object)childFigure)).setSelected(false);
        }
    }

    protected void fillShape(Graphics graphics) {
        Rectangle bubbleBounds = this.getBubbleBounds();
        graphics.fillRoundRectangle(bubbleBounds, 8, 8);
        PointList tailPoints = this.getTailPoints(bubbleBounds);
        graphics.fillPolygon(tailPoints);
    }

    private Rectangle getBubbleBounds() {
        Rectangle bubbleBounds = Rectangle.SINGLETON.setBounds(this.getBounds());
        bubbleBounds.resize(-5, -5);
        bubbleBounds.translate(5, 0);
        return bubbleBounds;
    }

    private PointList getTailPoints(Rectangle bubbleBounds) {
        PointList points = new PointList();
        points.addPoint(bubbleBounds.getBottomLeft().translate(0, -8));
        points.addPoint(this.getBounds().getBottomLeft());
        points.addPoint(bubbleBounds.getBottomLeft().translate(8, 0));
        return points;
    }

    protected void outlineShape(Graphics graphics) {
        float lineInset = Math.max(1.0f, this.getLineWidthFloat()) / 2.0f;
        int inset1 = (int)Math.floor(lineInset);
        int inset2 = (int)Math.ceil(lineInset);
        Rectangle bubbleBounds = this.getBubbleBounds();
        PointList tailPoints = this.getTailPoints(bubbleBounds);
        bubbleBounds.x += inset1;
        bubbleBounds.y += inset1;
        bubbleBounds.width -= inset1 + inset2;
        bubbleBounds.height -= inset1 + inset2;
        int cornerSize = Math.max(0, 8 - (int)lineInset);
        tailPoints.performTranslate(inset1, -inset1 - inset2);
        tailPoints.insertPoint(new Point(bubbleBounds.x, bubbleBounds.y + cornerSize), 0);
        tailPoints.addPoint(new Point(bubbleBounds.x + bubbleBounds.width - cornerSize, bubbleBounds.y + bubbleBounds.height));
        graphics.drawPolyline(tailPoints);
        graphics.drawLine(bubbleBounds.x + bubbleBounds.width, bubbleBounds.y + bubbleBounds.height - cornerSize, bubbleBounds.x + bubbleBounds.width, bubbleBounds.y + cornerSize);
        graphics.drawLine(bubbleBounds.x + bubbleBounds.width - cornerSize, bubbleBounds.y, bubbleBounds.x + cornerSize, bubbleBounds.y);
        graphics.drawArc(bubbleBounds.x, bubbleBounds.y, 2 * cornerSize, 2 * cornerSize, 90, 90);
        graphics.drawArc(bubbleBounds.x + bubbleBounds.width - 2 * cornerSize, bubbleBounds.y, 2 * cornerSize, 2 * cornerSize, 0, 90);
        graphics.drawArc(bubbleBounds.x + bubbleBounds.width - 2 * cornerSize, bubbleBounds.y + bubbleBounds.height - 2 * cornerSize, 2 * cornerSize, 2 * cornerSize, 270, 90);
    }

    public void paint(Graphics graphics) {
        graphics.pushState();
        try {
            if (graphics instanceof SWTGraphics && GCUtilities.supportsAdvancedGraphics()) {
                graphics.setAntialias(1);
            }
            super.paint(graphics);
        }
        finally {
            graphics.popState();
        }
    }

    public void setMode(Mode mode) {
        this.myMode = mode;
        for (Object childFigure : this.getChildren()) {
            if (!(childFigure instanceof SelectableBubbleItemFigure)) continue;
            ((SelectableBubbleItemFigure)((Object)childFigure)).setMode(mode);
        }
    }

    public Mode getMode() {
        return this.myMode;
    }

    public static enum Mode {
        PREVIEW,
        ICON;

    }
}

