/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dap.variables.maps;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.epsilon.eol.dap.variables.IVariableReference;
import org.eclipse.epsilon.eol.dap.variables.IdentifiableReference;
import org.eclipse.epsilon.eol.dap.variables.SuspendedState;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class MapEntryReference
extends IdentifiableReference<MapEntryTarget> {
    public static final String VALUE_VARIABLE_NAME = "value";
    public static final String KEY_VARIABLE_NAME = "key";
    private final String name;

    public MapEntryReference(IEolContext context, String name, Map<Object, Object> target, Object key) {
        super(context, new MapEntryTarget(target, key));
        this.name = name;
    }

    @Override
    public String getTypeName() {
        return "MapEntry";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return String.format("Map entry for key: %s", ((MapEntryTarget)this.target).key);
    }

    @Override
    public List<IVariableReference> getVariables(SuspendedState state) {
        ArrayList<IVariableReference> refs = new ArrayList<IVariableReference>(2);
        refs.add(state.getValueReference(this.context, KEY_VARIABLE_NAME, ((MapEntryTarget)this.target).key));
        refs.add(state.getValueReference(this.context, VALUE_VARIABLE_NAME, ((MapEntryTarget)this.target).map.get(((MapEntryTarget)this.target).key)));
        return refs;
    }

    protected static class MapEntryTarget {
        public final Map<?, ?> map;
        public final Object key;

        public MapEntryTarget(Map<Object, Object> m, Object k) {
            this.map = m;
            this.key = k;
        }

        public int hashCode() {
            return Objects.hash(this.key, System.identityHashCode(this.map));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MapEntryTarget other = (MapEntryTarget)obj;
            return Objects.equals(this.key, other.key) && this.map == other.map;
        }
    }
}

