/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dap.variables.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.epsilon.eol.dap.variables.IVariableReference;
import org.eclipse.epsilon.eol.dap.variables.SuspendedState;
import org.eclipse.epsilon.eol.dap.variables.collections.CollectionReference;
import org.eclipse.epsilon.eol.dap.variables.collections.CollectionSliceReference;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class SlicedCollectionReference
extends CollectionReference {
    private final String name;
    private final int sliceSize;

    public SlicedCollectionReference(IEolContext context, String name, Collection<Object> t, int sliceSize) {
        super(context, t);
        this.name = name;
        this.sliceSize = sliceSize;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return String.format("<sliced %s of %d elements>", ((Collection)this.target).getClass().getSimpleName(), ((Collection)this.target).size());
    }

    @Override
    public List<IVariableReference> getVariables(SuspendedState state) {
        ArrayList<IVariableReference> refs = new ArrayList<IVariableReference>(((Collection)this.target).size() / this.sliceSize + 1);
        int from = 0;
        while (from < ((Collection)this.target).size()) {
            int to = Math.min(((Collection)this.target).size(), from + this.sliceSize);
            refs.add(state.putOrGetReference(new CollectionSliceReference(this.context, this.name, (Collection)this.target, from, to)));
            from += this.sliceSize;
        }
        return refs;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.name);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SlicedCollectionReference other = (SlicedCollectionReference)obj;
        return Objects.equals(this.name, other.name);
    }
}

