package org.eclipse.fx.formats.svg.fx;

import com.google.common.base.Objects;
import com.sun.javafx.geom.PathIterator;
import javafx.geometry.Insets;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.shape.Shape;
import org.eclipse.fx.formats.svg.svg.SvgFactory;
import org.eclipse.fx.formats.svg.svg.SvgPathElement;
import org.eclipse.fx.formats.svg.svg.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class FXToSvgUtils {
  public static String toRGBHex(final Color c) {
    double _red = c.getRed();
    double _multiply = (_red * 255.0);
    long r = Math.round(_multiply);
    double _green = c.getGreen();
    double _multiply_1 = (_green * 255.0);
    long g = Math.round(_multiply_1);
    double _blue = c.getBlue();
    double _multiply_2 = (_blue * 255.0);
    long b = Math.round(_multiply_2);
    return String.format("#%02x%02x%02x", Long.valueOf(r), Long.valueOf(g), Long.valueOf(b));
  }
  
  public static Visibility toVisibility(final boolean b) {
    if (b) {
      return Visibility.VISIBLE;
    } else {
      return Visibility.HIDDEN;
    }
  }
  
  public static SvgPathElement createPath(final Shape s) {
    com.sun.javafx.geom.Shape _impl_configShape = s.impl_configShape();
    final PathIterator i = _impl_configShape.getPathIterator(null);
    final float[] f = new float[6];
    final StringBuilder b = new StringBuilder();
    {
      boolean _isDone = i.isDone();
      boolean _not = (!_isDone);
      boolean _while = _not;
      while (_while) {
        {
          final int type = i.currentSegment(f);
          if ((type == PathIterator.SEG_LINETO)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("L ");
            float _get = f[0];
            _builder.append(_get, "");
            _builder.append(" ");
            float _get_1 = f[1];
            _builder.append(_get_1, "");
            b.append(_builder);
          } else {
            if ((type == PathIterator.SEG_CLOSE)) {
              b.append("z");
            } else {
              if ((type == PathIterator.SEG_CUBICTO)) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("C ");
                float _get_2 = f[0];
                _builder_1.append(_get_2, "");
                _builder_1.append(" ");
                float _get_3 = f[1];
                _builder_1.append(_get_3, "");
                _builder_1.append(" ");
                float _get_4 = f[2];
                _builder_1.append(_get_4, "");
                _builder_1.append(" ");
                float _get_5 = f[3];
                _builder_1.append(_get_5, "");
                _builder_1.append(" ");
                float _get_6 = f[4];
                _builder_1.append(_get_6, "");
                _builder_1.append(" ");
                float _get_7 = f[5];
                _builder_1.append(_get_7, "");
                b.append(_builder_1);
              } else {
                if ((type == PathIterator.SEG_MOVETO)) {
                  StringConcatenation _builder_2 = new StringConcatenation();
                  _builder_2.append("M ");
                  float _get_8 = f[0];
                  _builder_2.append(_get_8, "");
                  _builder_2.append(" ");
                  float _get_9 = f[1];
                  _builder_2.append(_get_9, "");
                  b.append(_builder_2);
                } else {
                  if ((type == PathIterator.SEG_QUADTO)) {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("Q ");
                    float _get_10 = f[0];
                    _builder_3.append(_get_10, "");
                    _builder_3.append(" ");
                    float _get_11 = f[1];
                    _builder_3.append(_get_11, "");
                    _builder_3.append(" ");
                    float _get_12 = f[2];
                    _builder_3.append(_get_12, "");
                    _builder_3.append(" ");
                    float _get_13 = f[3];
                    _builder_3.append(_get_13, "");
                    b.append(_builder_3);
                  }
                }
              }
            }
          }
        }
        i.next();
        boolean _isDone_1 = i.isDone();
        boolean _not_1 = (!_isDone_1);
        _while = _not_1;
      }
    }
    SvgPathElement p = SvgFactory.eINSTANCE.createSvgPathElement();
    String _string = b.toString();
    p.setD(_string);
    return p;
  }
  
  public static String toProportion(final double v) {
    return (Double.valueOf((v * 100)) + "%");
  }
  
  public static boolean isEmpty(final Insets i) {
    boolean _equals = Objects.equal(i, null);
    if (_equals) {
      return true;
    } else {
      return ((((i.getLeft() == 0) && (i.getRight() == 0)) && (i.getTop() == 0)) && (i.getBottom() == 0));
    }
  }
  
  public static boolean isEmpty(final CornerRadii r) {
    boolean _equals = Objects.equal(r, null);
    if (_equals) {
      return true;
    } else {
      return ((((((((r.getBottomLeftHorizontalRadius() == 0) && (r.getBottomLeftVerticalRadius() == 0)) && (r.getBottomRightHorizontalRadius() == 0)) && (r.getBottomRightVerticalRadius() == 0)) && (r.getTopLeftHorizontalRadius() == 0)) && (r.getTopLeftVerticalRadius() == 0)) && (r.getTopRightHorizontalRadius() == 0)) && (r.getTopRightVerticalRadius() == 0));
    }
  }
}
