/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.models;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;

public class LogFileMetaData
implements Serializable {
    private static final long serialVersionUID = -8935133702928939531L;
    private String version;
    private long size;
    private long lastModified;
    private String timeStampFormat;
    private String executionMode;
    private boolean eventType;
    private URI filePath;
    private String projectName;
    private String projectRelativePath;
    private int timeStampConstant = -1;
    private int fileFormat;
    private String option;
    private Map<String, String> optionsSettings = new HashMap<String, String>();
    private transient IFile logfile = null;

    public IFile getLogfile() {
        IFile[] logfiles;
        if (this.logfile == null && (logfiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(this.filePath)).length > 0) {
            this.logfile = logfiles[0];
        }
        return this.logfile;
    }

    public void setLogfile(IFile logfile) {
        this.logfile = logfile;
        this.filePath = logfile.getLocationURI();
    }

    public String getExecutionMode() {
        return this.executionMode;
    }

    public void setExecutionMode(String executionMode) {
        this.executionMode = executionMode;
    }

    public URI getFilePath() {
        return this.filePath;
    }

    public void setFilePath(URI filePath) {
        this.filePath = filePath;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectRelativePath() {
        return this.projectRelativePath;
    }

    public void setProjectRelativePath(String projectRelativePath) {
        this.projectRelativePath = projectRelativePath;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getTimeStampFormat() {
        return this.timeStampFormat;
    }

    public void setTimeStampFormat(String timeStamp) {
        this.timeStampConstant = timeStamp.length();
        this.timeStampFormat = timeStamp;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean hasLoggedEventTypes() {
        return this.eventType;
    }

    public void setHasLoggedEventTypes(boolean eventType) {
        this.eventType = eventType;
    }

    public int getTimeStampConstant() {
        return this.timeStampConstant;
    }

    public int getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(int fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String getOption() {
        return this.option;
    }

    public void setOption(String option) {
        this.option = option;
        if (option != null && option.trim().length() > 0) {
            String[] strings;
            for (String string : strings = option.split(";")) {
                String[] values = string.split(":=");
                if (values.length < 2) continue;
                this.optionsSettings.put(values[0], values[1]);
            }
        }
    }

    public String getOptionsSettings(String key) {
        String value = null;
        if (this.optionsSettings != null) {
            value = this.optionsSettings.get(key);
        }
        return value;
    }
}

