/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.GeneralConstants;
import org.eclipse.titan.designer.GlobalDeltaVisitor;
import org.eclipse.titan.designer.SaveParticipant;
import org.eclipse.titan.designer.core.CompilerVersionInformationCollector;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.core.SymbolicLinkHandler;
import org.eclipse.titan.designer.core.TITANBuilder;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.extensions.ExtensionHandler;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.properties.PropertyNotificationManager;
import org.eclipse.titan.designer.properties.data.ProjectBuildPropertyData;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressConstants;
import org.osgi.framework.BundleContext;

public final class Activator
extends AbstractUIPlugin {
    private static final String PLUGIN_ID = "org.eclipse.titan.designer";
    private static Activator plugin = null;
    private static final String RESOURCE_NAME = "org.eclipse.titan.designer.messages";
    private static final List<IResourceChangeEvent> BATCHED_EVENTS = new CopyOnWriteArrayList<IResourceChangeEvent>();
    private ResourceBundle resourceBundle;
    private Map<IProject, IResourceDelta> projects;
    private boolean handleResourceChanges = true;
    private IResourceDeltaVisitor projectAdder = new IResourceDeltaVisitor(){

        public boolean visit(IResourceDelta delta) {
            switch (delta.getResource().getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    IProject project = delta.getResource().getProject();
                    if (TITANNature.hasTITANNature(project) && !Activator.this.projects.containsKey(project)) {
                        Activator.this.projects.put(project, delta);
                    }
                    return false;
                }
            }
            return false;
        }
    };
    private IResourceChangeListener decoratorUpdater = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (!Activator.this.handleResourceChanges) {
                return;
            }
            IResourceDelta eventDelta = event.getDelta();
            if (eventDelta == null) {
                return;
            }
            for (IResourceDelta delta : eventDelta.getAffectedChildren()) {
                IResource changedResource = delta.getResource();
                if (changedResource.getType() != 4 || !TITANNature.hasTITANNature((IProject)changedResource)) continue;
                try {
                    if (!Boolean.TRUE.equals(changedResource.getSessionProperty(GeneralConstants.PROJECT_UP_TO_DATE))) {
                        return;
                    }
                    ContentChangedFileFinder changeFinder = new ContentChangedFileFinder();
                    delta.accept((IResourceDeltaVisitor)changeFinder);
                    if (!changeFinder.getChangeFound()) continue;
                    changedResource.setSessionProperty(GeneralConstants.PROJECT_UP_TO_DATE, (Object)false);
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
            }
        }
    };
    private IResourceChangeListener listener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            BATCHED_EVENTS.add(event);
            if (Activator.getDefault().handleResourceChanges) {
                Activator.this.batchedEventHandler();
            }
        }
    };

    public Activator() {
        plugin = this;
    }

    protected void batchedEventHandler() {
        IResourceDelta projectDelta;
        this.projects = new HashMap<IProject, IResourceDelta>();
        block9: for (IResourceChangeEvent event : BATCHED_EVENTS) {
            IResourceDelta resourceDelta = event.getDelta();
            if (resourceDelta == null) {
                switch (event.getType()) {
                    case 2: 
                    case 4: {
                        GlobalParser.clearAllInformation(event.getResource().getProject());
                        continue block9;
                    }
                }
                continue;
            }
            try {
                resourceDelta.accept(this.projectAdder);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
            MarkerHandler.handleResourceChanges(event);
        }
        BATCHED_EVENTS.clear();
        IPreferencesService prefs = Platform.getPreferencesService();
        for (final IProject project : this.projects.keySet()) {
            if (project == null || !project.isAccessible() || this.projects.get(project) == null) continue;
            projectDelta = this.projects.get(project);
            if (projectDelta.getKind() == 1) {
                ProjectFileHandler pfHandler = new ProjectFileHandler(project);
                pfHandler.loadProjectSettings();
                PropertyNotificationManager.firePropertyChange((IResource)project);
                continue;
            }
            try {
                ProjectFileHandler pfHandler;
                IResourceDelta propertiesDelta = projectDelta.findMember((IPath)new Path(".TITAN_properties"));
                DeltaVisitor visitor = new DeltaVisitor();
                projectDelta.accept((IResourceDeltaVisitor)visitor);
                if (visitor.hasNewOrRemovedResources()) {
                    pfHandler = new ProjectFileHandler(project);
                    if (propertiesDelta == null || propertiesDelta.getKind() == 2) {
                        pfHandler.saveProjectSettings();
                    } else {
                        pfHandler.loadProjectSettings();
                        PropertyNotificationManager.firePropertyChange((IResource)project);
                    }
                } else if (propertiesDelta != null) {
                    pfHandler = new ProjectFileHandler(project);
                    if (propertiesDelta.getKind() == 2) {
                        pfHandler.saveProjectSettings();
                    } else {
                        pfHandler.loadProjectSettings();
                        PropertyNotificationManager.firePropertyChange((IResource)project);
                    }
                }
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
            IProject[] referencingProjects = ProjectBasedBuilder.getProjectBasedBuilder(project).getReferencingProjects();
            for (int i = 0; i < referencingProjects.length; ++i) {
                ProjectBasedBuilder.setForcedBuild(referencingProjects[i]);
            }
            if ((projectDelta.getFlags() & 0x80000) != 0) {
                TITANBuilder.markProjectForRebuild(project);
            }
            if (projectDelta.getKind() != 1) continue;
            WorkspaceJob derivedSetter = new WorkspaceJob("Derived flag setter"){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    IContainer[] workingDirectories;
                    for (IContainer workingDirectory : workingDirectories = ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryResources(true)) {
                        if (workingDirectory == null || !workingDirectory.isAccessible()) continue;
                        try {
                            workingDirectory.setDerived(true, monitor);
                        }
                        catch (CoreException e) {
                            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            derivedSetter.setPriority(30);
            derivedSetter.setUser(false);
            derivedSetter.setSystem(true);
            derivedSetter.setRule(project.getWorkspace().getRuleFactory().modifyRule((IResource)project));
            derivedSetter.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
            derivedSetter.schedule();
        }
        if (prefs.getBoolean(PLUGIN_ID, "org.eclipse.titan.designer.useOnTheFlyParsing", true, null)) {
            for (final IProject project : this.projects.keySet()) {
                if (project == null || !project.isAccessible() || this.projects.get(project) == null) continue;
                projectDelta = this.projects.get(project);
                DeltaVisitor visitor = new DeltaVisitor();
                try {
                    projectDelta.accept((IResourceDeltaVisitor)visitor);
                    if (!visitor.hasNewOrRemovedResources() && (projectDelta.getFlags() & 0x80000) == 0) {
                        continue;
                    }
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
                WorkspaceJob buildStarter = new WorkspaceJob("Build starter"){

                    public IStatus runInWorkspace(IProgressMonitor monitor) {
                        GlobalDeltaVisitor tempVisitor = new GlobalDeltaVisitor(project);
                        try {
                            projectDelta.accept((IResourceDeltaVisitor)tempVisitor);
                        }
                        catch (CoreException e) {
                            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                        }
                        final WorkspaceJob[] outdatingJobs = tempVisitor.reportOutdatedFiles();
                        WorkspaceJob analyzeAfterOutdating = new WorkspaceJob("analyzeAfterOutdating"){

                            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                                try {
                                    for (WorkspaceJob job : outdatingJobs) {
                                        if (job == null) continue;
                                        job.join();
                                    }
                                }
                                catch (InterruptedException e) {
                                    ErrorReporter.logExceptionStackTrace((Exception)e);
                                }
                                GlobalParser.getProjectSourceParser(project).analyzeAll(false);
                                if (ProjectBuildPropertyData.useAutomaticMakefilegeneration(project)) {
                                    TITANBuilder.markProjectForRebuild(project);
                                    SymbolicLinkHandler.createSymlinks((IResource)project);
                                    TITANBuilder.regenerateMakefile(project);
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        analyzeAfterOutdating.setPriority(30);
                        analyzeAfterOutdating.setUser(false);
                        analyzeAfterOutdating.setSystem(true);
                        analyzeAfterOutdating.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
                        analyzeAfterOutdating.schedule();
                        return Status.OK_STATUS;
                    }
                };
                buildStarter.setPriority(30);
                buildStarter.setUser(false);
                buildStarter.setSystem(true);
                buildStarter.setRule(project.getWorkspace().getRuleFactory().refreshRule((IResource)project));
                buildStarter.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
                buildStarter.schedule();
            }
        }
    }

    public void pauseHandlingResourceChanges() {
        this.handleResourceChanges = false;
    }

    public void resumeHandlingResourceChanges() {
        this.handleResourceChanges = true;
        this.batchedEventHandler();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener(this.listener);
        workspace.addResourceChangeListener(this.decoratorUpdater);
        SaveParticipant participant = new SaveParticipant();
        ISavedState lastState = workspace.addSaveParticipant(PLUGIN_ID, (ISaveParticipant)participant);
        if (lastState != null) {
            lastState.processResourceChangeEvents(this.listener);
        }
        try {
            this.resourceBundle = ResourceBundle.getBundle(RESOURCE_NAME);
        }
        catch (MissingResourceException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            this.resourceBundle = null;
        }
        ExtensionHandler.INSTANCE.registerContributors();
        WorkspaceJob initializer = new WorkspaceJob("Initializing the TITAN toolset"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                CompilerVersionInformationCollector.collectInformation();
                return Status.OK_STATUS;
            }
        };
        initializer.setPriority(30);
        if (Platform.getPreferencesService().getBoolean(PLUGIN_ID, "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            initializer.setSystem(false);
            initializer.setUser(true);
        } else {
            initializer.setSystem(true);
            initializer.setUser(false);
        }
        initializer.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        initializer.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener(this.listener);
        workspace.removeResourceChangeListener(this.decoratorUpdater);
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static final boolean switchActivity(String activityId, boolean enable) {
        boolean activityChange;
        IWorkbenchActivitySupport as = PlatformUI.getWorkbench().getActivitySupport();
        IActivityManager am = as.getActivityManager();
        HashSet<String> enabledActivities = new HashSet<String>(am.getEnabledActivityIds());
        boolean bl = activityChange = enable ? enabledActivities.add(activityId) : enabledActivities.remove(activityId);
        if (!activityChange) {
            return false;
        }
        as.setEnabledActivityIds(enabledActivities);
        return true;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private class ContentChangedFileFinder
    implements IResourceDeltaVisitor {
        private static final String TRUE_STRING = "true";
        private static final String LOG_FILE_EXTENSION = "log";
        private boolean changedNotExcludedResourceFound = false;
        private List<IContainer> workingDirectories;

        private ContentChangedFileFinder() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (this.changedNotExcludedResourceFound) {
                return false;
            }
            switch (delta.getResource().getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    IProject project = delta.getResource().getProject();
                    if (TITANNature.hasTITANNature(project)) {
                        this.workingDirectories = Arrays.asList(ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryResources(false));
                        return true;
                    }
                    return false;
                }
                case 2: {
                    boolean isWorkingDir;
                    IFolder folder = (IFolder)delta.getResource();
                    if (!folder.exists()) {
                        return false;
                    }
                    String isExcludedFolder = folder.getPersistentProperty(GeneralConstants.EXCLUDED_FOLDER_QUALIFIER);
                    boolean bl = isWorkingDir = this.workingDirectories == null ? false : this.workingDirectories.contains(folder);
                    return !isWorkingDir && !TRUE_STRING.equals(isExcludedFolder);
                }
                case 1: {
                    if (delta.getFlags() == 0 || (delta.getFlags() & 0x20000) == 131072 || (delta.getFlags() & 0x4000) == 16384) {
                        return false;
                    }
                    IFile file = (IFile)delta.getResource();
                    if (!file.exists()) {
                        return false;
                    }
                    if (LOG_FILE_EXTENSION.equals(file.getFileExtension())) {
                        return false;
                    }
                    String isExcludedFile = file.getPersistentProperty(GeneralConstants.EXCLUDED_FILE_QUALIFIER);
                    if (!TRUE_STRING.equals(isExcludedFile)) {
                        this.changedNotExcludedResourceFound = true;
                    }
                    return false;
                }
            }
            return false;
        }

        public boolean getChangeFound() {
            return this.changedNotExcludedResourceFound;
        }
    }

    private static final class DeltaVisitor
    implements IResourceDeltaVisitor {
        private boolean hasNewOrRemovedResources = false;

        private DeltaVisitor() {
        }

        public boolean hasNewOrRemovedResources() {
            return this.hasNewOrRemovedResources;
        }

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            switch (resource.getType()) {
                case 4: {
                    if (delta.getKind() != 2) break;
                    return false;
                }
                case 1: 
                case 2: {
                    if (delta.getKind() != 1 && delta.getKind() != 2) break;
                    this.hasNewOrRemovedResources = true;
                    return false;
                }
            }
            return true;
        }
    }
}

