/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.Value_Assignment;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Constraints;
import org.eclipse.titan.designer.AST.Governor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IOutlineElement;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.attributes.MultipleWithAttributes;
import org.eclipse.titan.designer.AST.TTCN3.attributes.SingleWithAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Const;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Function_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.ParsedSubType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public abstract class Type
extends Governor
implements IType,
IIncrementallyUpdateable,
IOutlineElement {
    private static final String INCOMPATIBLEVALUE = "Incompatible value: `{0}'' was expected";
    public static final String REFTOVALUEEXPECTED = "Reference to a value was expected instead of {0}";
    public static final String REFTOVALUEEXPECTED_INSTEADOFCALL = "Reference to a value was expected instead of a call of {0}, which return a template";
    private static final String TYPECOMPATWARNING = "Type compatibility between `{0}'' and `{1}''";
    private IType parentType = null;
    protected Constraints constraints = null;
    protected WithAttributesPath withAttributesPath = null;
    private boolean hasDone = false;
    protected List<ParsedSubType> parsedRestrictions = null;
    protected SubType subType = null;
    private static String typeCompatibilitySeverity;
    protected static boolean noStructuredTypeCompatibility;

    @Override
    public ISetting.Setting_type getSettingtype() {
        return ISetting.Setting_type.S_T;
    }

    @Override
    public abstract IType.Type_type getTypetype();

    @Override
    public final IType getParentType() {
        return this.parentType;
    }

    @Override
    public final void setParentType(IType type) {
        this.parentType = type;
    }

    @Override
    public WithAttributesPath getAttributePath() {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        return this.withAttributesPath;
    }

    @Override
    public void setAttributeParentPath(WithAttributesPath parent) {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        this.withAttributesPath.setAttributeParent(parent);
    }

    @Override
    public void clearWithAttributes() {
        if (this.withAttributesPath != null) {
            this.withAttributesPath.setWithAttributes(null);
        }
    }

    @Override
    public void setWithAttributes(MultipleWithAttributes attributes) {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        this.withAttributesPath.setWithAttributes(attributes);
    }

    @Override
    public boolean hasDoneAttribute() {
        return this.hasDone;
    }

    @Override
    public final boolean isConstrained() {
        return this.constraints != null;
    }

    @Override
    public final void addConstraints(Constraints constraints) {
        if (constraints == null) {
            return;
        }
        this.constraints = constraints;
        constraints.setMyType(this);
    }

    @Override
    public final Constraints getConstraints() {
        return this.constraints;
    }

    @Override
    public SubType getSubtype() {
        return this.subType;
    }

    @Override
    public final void setParsedRestrictions(List<ParsedSubType> parsedRestrictions) {
        this.parsedRestrictions = parsedRestrictions;
    }

    @Override
    public String chainedDescription() {
        return "type reference: " + this.getFullName();
    }

    @Override
    public final Location getChainLocation() {
        return this.getLocation();
    }

    @Override
    public IType getTypeRefdLast(CompilationTimeStamp timestamp) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IType result = this.getTypeRefdLast(timestamp, referenceChain);
        referenceChain.release();
        return result;
    }

    public IType getTypeRefdLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        return this;
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, boolean interruptIfOptional) {
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IType temp = this.getFieldType(timestamp, reference, actualSubReference, expectedIndex, chain, interruptIfOptional);
        chain.release();
        return temp;
    }

    @Override
    public abstract IType getFieldType(CompilationTimeStamp var1, Reference var2, int var3, Expected_Value_type var4, IReferenceChain var5, boolean var6);

    @Override
    public boolean getSubrefsAsArray(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, List<Integer> subrefsArray, List<IType> typeArray) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return true;
        }
        ErrorReporter.INTERNAL_ERROR((String)("Type " + this.getTypename() + " has no fields."));
        return false;
    }

    @Override
    public boolean getFieldTypesAsArray(Reference reference, int actualSubReference, List<IType> typeArray) {
        List<ISubReference> subreferences = reference.getSubreferences();
        return subreferences.size() <= actualSubReference;
    }

    @Override
    public boolean hasVariantAttributes(CompilationTimeStamp timestamp) {
        if (this.withAttributesPath == null) {
            return false;
        }
        List<SingleWithAttribute> realAttributes = this.withAttributesPath.getRealAttributes(timestamp);
        for (int i = 0; i < realAttributes.size(); ++i) {
            if (!SingleWithAttribute.Attribute_Type.Variant_Attribute.equals((Object)realAttributes.get(i).getAttributeType())) continue;
            return true;
        }
        MultipleWithAttributes localAttributes = this.withAttributesPath.getAttributes();
        if (localAttributes == null) {
            return false;
        }
        for (int i = 0; i < localAttributes.getNofElements(); ++i) {
            SingleWithAttribute tempSingle = localAttributes.getAttribute(i);
            if (!SingleWithAttribute.Attribute_Type.Variant_Attribute.equals((Object)tempSingle.getAttributeType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkDoneAttribute(CompilationTimeStamp timestamp) {
        this.hasDone = false;
        if (this.withAttributesPath == null) {
            return;
        }
        List<SingleWithAttribute> realAttributes = this.withAttributesPath.getRealAttributes(timestamp);
        int size = realAttributes.size();
        for (int i = 0; i < size; ++i) {
            SingleWithAttribute singleAttribute = realAttributes.get(i);
            if (!SingleWithAttribute.Attribute_Type.Extension_Attribute.equals((Object)singleAttribute.getAttributeType()) || !"done".equals(singleAttribute.getAttributeSpecification().getSpecification())) continue;
            this.hasDone = true;
        }
    }

    @Override
    public void parseAttributes(CompilationTimeStamp timestamp) {
        this.checkDoneAttribute(timestamp);
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void checkConstructorName(String definitionName) {
    }

    @Override
    public SubType.SubType_type getSubtypeType() {
        return SubType.SubType_type.ST_NONE;
    }

    protected void checkSubtypeRestrictions(CompilationTimeStamp timestamp) {
        this.checkSubtypeRestrictions(timestamp, this.getSubtypeType(), null);
    }

    protected void checkSubtypeRestrictions(CompilationTimeStamp timestamp, SubType.SubType_type subtypeType, SubType parentSubtype) {
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        if (this.parsedRestrictions == null && parentSubtype == null) {
            return;
        }
        if (subtypeType == SubType.SubType_type.ST_NONE) {
            this.getLocation().reportSemanticError(MessageFormat.format("TTCN-3 subtype constraints are not applicable to type `{0}''", this.getTypename()));
            return;
        }
        this.subType = new SubType(subtypeType, this, this.parsedRestrictions, parentSubtype);
        this.subType.check(timestamp);
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
    }

    @Override
    public boolean isComponentInternal(CompilationTimeStamp timestamp) {
        return false;
    }

    @Override
    public void checkComponentInternal(CompilationTimeStamp timestamp, Set<IType> typeSet, String operation) {
    }

    @Override
    public void checkEmbedded(CompilationTimeStamp timestamp, Location errorLocation, boolean defaultAllowed, String errorMessage) {
    }

    @Override
    public IValue checkThisValueRef(CompilationTimeStamp timestamp, IValue value) {
        if (IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)value.getValuetype())) {
            return value.setValuetype(timestamp, IValue.Value_type.REFERENCED_VALUE);
        }
        return value;
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        value.setIsErroneous(false);
        Assignment assignment = this.getDefiningAssignment();
        if (assignment != null && assignment instanceof Definition) {
            Scope scope = value.getMyScope();
            if (scope != null) {
                Module module = scope.getModuleScope();
                if (module != null) {
                    String referingModuleName = module.getName();
                    if (!((Definition)assignment).referingHere.contains(referingModuleName)) {
                        ((Definition)assignment).referingHere.add(referingModuleName);
                    }
                } else {
                    ErrorReporter.logError((String)("The value `" + value.getFullName() + "' does not appear to be in a module"));
                }
            } else {
                ErrorReporter.logError((String)("The value `" + value.getFullName() + "' does not appear to be in a scope"));
            }
        }
        this.check(timestamp);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp) || this.getIsErroneous(timestamp)) {
            return;
        }
        if (IValue.Value_type.OMIT_VALUE.equals((Object)last.getValuetype()) && !valueCheckingOptions.omit_allowed) {
            value.getLocation().reportSemanticError("`omit' value is not allowed in this context");
            value.setIsErroneous(true);
            return;
        }
        switch (value.getValuetype()) {
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                ReferenceChain chain;
                if (IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) {
                    chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                    this.checkThisReferencedValue(timestamp, last, valueCheckingOptions.expected_value, chain, valueCheckingOptions.sub_check, valueCheckingOptions.str_elem);
                    chain.release();
                }
                return;
            }
            case REFERENCED_VALUE: {
                ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                this.checkThisReferencedValue(timestamp, value, valueCheckingOptions.expected_value, chain, valueCheckingOptions.sub_check, valueCheckingOptions.str_elem);
                chain.release();
                return;
            }
            case EXPRESSION_VALUE: {
                if (!value.isUnfoldable(timestamp, null)) break;
                IType.Type_type temporalType = value.getExpressionReturntype(timestamp, valueCheckingOptions.expected_value);
                if (!IType.Type_type.TYPE_UNDEFINED.equals((Object)temporalType) && !Type.isCompatible(timestamp, this.getTypetype(), temporalType, false, value.isAsn())) {
                    value.getLocation().reportSemanticError(MessageFormat.format(INCOMPATIBLEVALUE, this.getTypename()));
                    value.setIsErroneous(true);
                }
                return;
            }
            case MACRO_VALUE: {
                if (!value.isUnfoldable(timestamp, null)) break;
                IType.Type_type temporalType = value.getExpressionReturntype(timestamp, valueCheckingOptions.expected_value);
                if (!IType.Type_type.TYPE_UNDEFINED.equals((Object)temporalType) && !Type.isCompatible(timestamp, this.getTypetype(), temporalType, false, value.isAsn())) {
                    value.getLocation().reportSemanticError(MessageFormat.format(INCOMPATIBLEVALUE, this.getTypename()));
                    value.setIsErroneous(true);
                }
                return;
            }
        }
    }

    private void checkThisReferencedValue(CompilationTimeStamp timestamp, IValue value, Expected_Value_type expectedValue, IReferenceChain referenceChain, boolean subCheck, boolean strElem) {
        IType type;
        String referingModuleName;
        Reference reference = ((Referenced_Value)value).getReference();
        Assignment assignment = reference.getRefdAssignment(timestamp, true, referenceChain);
        if (assignment == null) {
            value.setIsErroneous(true);
            return;
        }
        Assignment myAssignment = this.getDefiningAssignment();
        if (myAssignment != null && myAssignment instanceof Definition && !((Definition)myAssignment).referingHere.contains(referingModuleName = value.getMyScope().getModuleScope().getName())) {
            ((Definition)myAssignment).referingHere.add(referingModuleName);
        }
        assignment.check(timestamp);
        boolean isConst = false;
        boolean errorFlag = false;
        boolean checkRunsOn = false;
        IType governor = null;
        if (assignment.getIsErroneous()) {
            value.setIsErroneous(true);
        } else {
            block0 : switch (assignment.getAssignmentType()) {
                case A_CONST: {
                    isConst = true;
                    break;
                }
                case A_OBJECT: 
                case A_OS: {
                    ISetting setting = reference.getRefdSetting(timestamp);
                    if (setting == null || setting.getIsErroneous(timestamp)) {
                        value.setIsErroneous(true);
                        return;
                    }
                    if (!ISetting.Setting_type.S_V.equals((Object)setting.getSettingtype())) {
                        reference.getLocation().reportSemanticError(MessageFormat.format("This InformationFromObjects construct does not refer to a value: {0}", value.getFullName()));
                        value.setIsErroneous(true);
                        return;
                    }
                    governor = ((Value)setting).getMyGovernor();
                    if (governor == null) break;
                    isConst = true;
                    break;
                }
                case A_EXT_CONST: 
                case A_MODULEPAR: {
                    if (!Expected_Value_type.EXPECTED_CONSTANT.equals((Object)expectedValue)) break;
                    value.getLocation().reportSemanticError(MessageFormat.format("Reference to an (evaluatable) constant value was expected instead of {0}", assignment.getDescription()));
                    errorFlag = true;
                    break;
                }
                case A_VAR: 
                case A_PAR_VAL: 
                case A_PAR_VAL_IN: 
                case A_PAR_VAL_OUT: 
                case A_PAR_VAL_INOUT: {
                    switch (expectedValue) {
                        case EXPECTED_CONSTANT: {
                            value.getLocation().reportSemanticError(MessageFormat.format("Reference to a constant value was expected instead of {0}", assignment.getDescription()));
                            errorFlag = true;
                            break block0;
                        }
                        case EXPECTED_STATIC_VALUE: {
                            value.getLocation().reportSemanticError(MessageFormat.format("Reference to a static value was expected instead of {0}", assignment.getDescription()));
                            errorFlag = true;
                            break block0;
                        }
                    }
                    break;
                }
                case A_TEMPLATE: 
                case A_MODULEPAR_TEMPLATE: 
                case A_VAR_TEMPLATE: 
                case A_PAR_TEMP_IN: 
                case A_PAR_TEMP_OUT: 
                case A_PAR_TEMP_INOUT: {
                    if (Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue)) break;
                    value.getLocation().reportSemanticError(MessageFormat.format(REFTOVALUEEXPECTED, assignment.getDescription()));
                    errorFlag = true;
                    break;
                }
                case A_FUNCTION_RVAL: {
                    String message;
                    checkRunsOn = true;
                    switch (expectedValue) {
                        case EXPECTED_CONSTANT: {
                            message = MessageFormat.format("Reference to a constant value was expected instead of the return value of {0}", assignment.getDescription());
                            value.getLocation().reportSemanticError(message);
                            errorFlag = true;
                            break block0;
                        }
                        case EXPECTED_STATIC_VALUE: {
                            message = MessageFormat.format("Reference to a static value was expected instead of the return value of {0}", assignment.getDescription());
                            value.getLocation().reportSemanticError(message);
                            errorFlag = true;
                            break block0;
                        }
                    }
                    break;
                }
                case A_EXT_FUNCTION_RVAL: {
                    String message;
                    switch (expectedValue) {
                        case EXPECTED_CONSTANT: {
                            message = MessageFormat.format("Reference to a constant value was expected instead of the return value of {0}", assignment.getDescription());
                            value.getLocation().reportSemanticError(message);
                            errorFlag = true;
                            break block0;
                        }
                        case EXPECTED_STATIC_VALUE: {
                            message = MessageFormat.format("Reference to a static value was expected instead of the return value of {0}", assignment.getDescription());
                            value.getLocation().reportSemanticError(message);
                            errorFlag = true;
                            break block0;
                        }
                    }
                    break;
                }
                case A_FUNCTION_RTEMP: {
                    checkRunsOn = true;
                    if (Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue)) break;
                    value.getLocation().reportSemanticError(MessageFormat.format(REFTOVALUEEXPECTED_INSTEADOFCALL, assignment.getDescription()));
                    errorFlag = true;
                    break;
                }
                case A_EXT_FUNCTION_RTEMP: {
                    if (Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue)) break;
                    value.getLocation().reportSemanticError(MessageFormat.format(REFTOVALUEEXPECTED_INSTEADOFCALL, assignment.getDescription()));
                    errorFlag = true;
                    break;
                }
                case A_FUNCTION: 
                case A_EXT_FUNCTION: {
                    value.getLocation().reportSemanticError(MessageFormat.format("Reference to a {0} was expected instead of a call of {1}, which does not have a return type", Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue) ? "value or template" : "value", assignment.getDescription()));
                    value.setIsErroneous(true);
                    return;
                }
                default: {
                    value.getLocation().reportSemanticError(MessageFormat.format("Reference to a {0} was expected instead of {1}", Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue) ? "value or template" : "value", assignment.getDescription()));
                    value.setIsErroneous(true);
                    return;
                }
            }
        }
        if (checkRunsOn) {
            reference.getMyScope().checkRunsOnScope(timestamp, assignment, (ILocateableNode)reference, "call");
        }
        if (governor == null && (type = assignment.getType(timestamp)) != null) {
            governor = type.getFieldType(timestamp, reference, 1, expectedValue, referenceChain, false);
        }
        if (governor == null) {
            value.setIsErroneous(true);
            return;
        }
        TypeCompatibilityInfo info = new TypeCompatibilityInfo(this, governor, true);
        info.setStr1Elem(strElem);
        info.setStr2Elem(reference.refersToStringElement());
        CompatibilityLevel compatibilityLevel = this.getCompatibility(timestamp, governor, info, null, null);
        if (compatibilityLevel != CompatibilityLevel.COMPATIBLE) {
            IType type2 = this.getTypeRefdLast(timestamp, null);
            switch (type2.getTypetype()) {
                case TYPE_PORT: {
                    break;
                }
                case TYPE_SIGNATURE: {
                    if (!Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue)) break;
                    String message = MessageFormat.format("Type mismatch: a signature template of type `{0}'' was expected instead of `{1}''", this.getTypename(), governor.getTypename());
                    value.getLocation().reportSemanticError(message);
                    break;
                }
                case TYPE_SEQUENCE_OF: 
                case TYPE_ASN1_SEQUENCE: 
                case TYPE_TTCN3_SEQUENCE: 
                case TYPE_ARRAY: 
                case TYPE_ASN1_SET: 
                case TYPE_TTCN3_SET: 
                case TYPE_SET_OF: 
                case TYPE_ASN1_CHOICE: 
                case TYPE_TTCN3_CHOICE: 
                case TYPE_ANYTYPE: {
                    if (compatibilityLevel == CompatibilityLevel.INCOMPATIBLE_SUBTYPE) {
                        value.getLocation().reportSemanticError(info.getSubtypeError());
                        break;
                    }
                    value.getLocation().reportSemanticError(info.toString());
                    break;
                }
                default: {
                    if (compatibilityLevel == CompatibilityLevel.INCOMPATIBLE_SUBTYPE) {
                        value.getLocation().reportSemanticError(info.getSubtypeError());
                        break;
                    }
                    String message = MessageFormat.format("Type mismatch: a {0} of type `{1}'' was expected instead of `{2}''", Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue) ? "value or template" : "value", this.getTypename(), governor.getTypename());
                    value.getLocation().reportSemanticError(message);
                }
            }
            errorFlag = true;
        } else if ("warning".equals(typeCompatibilitySeverity) && info.getNeedsConversion()) {
            value.getLocation().reportSemanticWarning(MessageFormat.format(TYPECOMPATWARNING, this.getTypename(), governor.getTypename()));
        }
        if (errorFlag) {
            value.setIsErroneous(true);
            return;
        }
        IValue last = value.getValueRefdLast(timestamp, expectedValue, referenceChain);
        if (isConst && !last.getIsErroneous(timestamp) && subCheck && this.subType != null) {
            this.subType.checkThisValue(timestamp, value);
        }
    }

    public ITTCN3Template checkThisTemplateRef(CompilationTimeStamp timestamp, ITTCN3Template t, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        IValue value;
        switch (t.getTemplatetype()) {
            case SUPERSET_MATCH: 
            case SUBSET_MATCH: {
                IType it1 = this.getTypeRefdLast(timestamp);
                IType.Type_type tt = it1.getTypetype();
                if (IType.Type_type.TYPE_SEQUENCE_OF.equals((Object)tt) || IType.Type_type.TYPE_SET_OF.equals((Object)tt)) {
                    return t;
                }
                t.getLocation().reportSemanticError(MessageFormat.format("{0} cannot be used for type {1}", t.getTemplateTypeName(), this.getTypename()));
                t.setIsErroneous(true);
                return t;
            }
            case SPECIFIC_VALUE: {
                break;
            }
            default: {
                return t;
            }
        }
        ITTCN3Template template = t;
        if (template instanceof TemplateBody) {
            template = ((TemplateBody)template).getTemplate();
        }
        if ((value = ((SpecificValue_Template)template).getSpecificValue()) == null) {
            return template;
        }
        value = this.checkThisValueRef(timestamp, value);
        block4 : switch (value.getValuetype()) {
            case REFERENCED_VALUE: {
                Assignment assignment = ((Referenced_Value)value).getReference().getRefdAssignment(timestamp, false, referenceChain);
                if (assignment == null) {
                    template.setIsErroneous(true);
                    break;
                }
                switch (assignment.getAssignmentType()) {
                    case A_VAR_TEMPLATE: {
                        if (!Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue)) {
                            template.getLocation().reportSemanticError(MessageFormat.format(REFTOVALUEEXPECTED, assignment.getDescription()));
                            template.setIsErroneous(true);
                        }
                        Type type = ((Def_Var_Template)assignment).getType(timestamp);
                        switch (type.getTypetype()) {
                            case TYPE_BITSTRING: 
                            case TYPE_BITSTRING_A: 
                            case TYPE_HEXSTRING: 
                            case TYPE_OCTETSTRING: 
                            case TYPE_CHARSTRING: 
                            case TYPE_UCHARSTRING: 
                            case TYPE_UTF8STRING: 
                            case TYPE_NUMERICSTRING: 
                            case TYPE_PRINTABLESTRING: 
                            case TYPE_TELETEXSTRING: 
                            case TYPE_VIDEOTEXSTRING: 
                            case TYPE_IA5STRING: 
                            case TYPE_GRAPHICSTRING: 
                            case TYPE_VISIBLESTRING: 
                            case TYPE_GENERALSTRING: 
                            case TYPE_UNIVERSALSTRING: 
                            case TYPE_BMPSTRING: 
                            case TYPE_UTCTIME: 
                            case TYPE_GENERALIZEDTIME: 
                            case TYPE_OBJECTDESCRIPTOR: {
                                ISubReference subreference;
                                List<ISubReference> subReferences = ((Referenced_Value)value).getReference().getSubreferences();
                                int nofSubreferences = subReferences.size();
                                if (nofSubreferences <= 1 || !((subreference = subReferences.get(nofSubreferences - 1)) instanceof ArraySubReference)) break;
                                template.getLocation().reportSemanticError(MessageFormat.format("Reference to {0} can not be indexed", assignment.getDescription()));
                                template.setIsErroneous(true);
                                return template;
                            }
                        }
                        return template.setTemplatetype(timestamp, ITTCN3Template.Template_type.TEMPLATE_REFD);
                    }
                    case A_CONST: {
                        IType type1 = assignment instanceof Value_Assignment ? ((Value_Assignment)assignment).getType(timestamp) : ((Def_Const)assignment).getType(timestamp);
                        switch (type1.getTypetype()) {
                            case TYPE_BITSTRING: 
                            case TYPE_BITSTRING_A: 
                            case TYPE_HEXSTRING: 
                            case TYPE_OCTETSTRING: 
                            case TYPE_CHARSTRING: 
                            case TYPE_UCHARSTRING: 
                            case TYPE_UTF8STRING: 
                            case TYPE_NUMERICSTRING: 
                            case TYPE_PRINTABLESTRING: 
                            case TYPE_TELETEXSTRING: 
                            case TYPE_VIDEOTEXSTRING: 
                            case TYPE_IA5STRING: 
                            case TYPE_GRAPHICSTRING: 
                            case TYPE_VISIBLESTRING: 
                            case TYPE_GENERALSTRING: 
                            case TYPE_UNIVERSALSTRING: 
                            case TYPE_BMPSTRING: 
                            case TYPE_UTCTIME: 
                            case TYPE_GENERALIZEDTIME: 
                            case TYPE_OBJECTDESCRIPTOR: {
                                List<ISubReference> subReferences = ((Referenced_Value)value).getReference().getSubreferences();
                                int nofSubreferences = subReferences.size();
                                if (nofSubreferences <= 1) break;
                                ISubReference subreference = subReferences.get(nofSubreferences - 1);
                                if (!(subreference instanceof ArraySubReference)) break block4;
                                template.getLocation().reportSemanticError(MessageFormat.format("Reference to {0} can not be indexed", assignment.getDescription()));
                                template.setIsErroneous(true);
                                return template;
                            }
                        }
                        break block4;
                    }
                    case A_TEMPLATE: 
                    case A_MODULEPAR_TEMPLATE: 
                    case A_PAR_TEMP_IN: 
                    case A_PAR_TEMP_OUT: 
                    case A_PAR_TEMP_INOUT: 
                    case A_FUNCTION_RTEMP: 
                    case A_EXT_FUNCTION_RTEMP: {
                        if (!Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue)) {
                            template.getLocation().reportSemanticError(MessageFormat.format(REFTOVALUEEXPECTED, assignment.getDescription()));
                            template.setIsErroneous(true);
                        }
                        return template.setTemplatetype(timestamp, ITTCN3Template.Template_type.TEMPLATE_REFD);
                    }
                }
                break;
            }
            case EXPRESSION_VALUE: {
                IType type;
                Expression_Value expression = (Expression_Value)value;
                if (!Expression_Value.Operation_type.APPLY_OPERATION.equals((Object)expression.getOperationType()) || (type = expression.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE)) == null || (type = type.getTypeRefdLast(timestamp)) == null || !IType.Type_type.TYPE_FUNCTION.equals((Object)type.getTypetype()) || !((Function_Type)type).returnsTemplate()) break;
                return template.setTemplatetype(timestamp, ITTCN3Template.Template_type.TEMPLATE_INVOKE);
            }
        }
        return template;
    }

    @Override
    public ITTCN3Template checkThisTemplateRef(CompilationTimeStamp timestamp, ITTCN3Template t) {
        return this.checkThisTemplateRef(timestamp, t, Expected_Value_type.EXPECTED_TEMPLATE, null);
    }

    protected void registerUsage(ITTCN3Template template) {
        String referingModuleName;
        Assignment assignment = this.getDefiningAssignment();
        if (assignment != null && assignment instanceof Definition && !((Definition)assignment).referingHere.contains(referingModuleName = template.getMyScope().getModuleScope().getName())) {
            ((Definition)assignment).referingHere.add(referingModuleName);
        }
    }

    @Override
    public abstract void checkThisTemplate(CompilationTimeStamp var1, ITTCN3Template var2, boolean var3, boolean var4);

    @Override
    public final void checkThisTemplateSubtype(CompilationTimeStamp timestamp, ITTCN3Template template) {
        if (ITTCN3Template.Template_type.PERMUTATION_MATCH.equals((Object)template.getTemplatetype())) {
            return;
        }
        if (this.subType != null) {
            this.subType.checkThisTemplateGeneric(timestamp, template);
        }
    }

    @Override
    public abstract boolean isCompatible(CompilationTimeStamp var1, IType var2, TypeCompatibilityInfo var3, TypeCompatibilityInfo.Chain var4, TypeCompatibilityInfo.Chain var5);

    @Override
    public boolean isStronglyCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType thisTypeLast = this.getTypeRefdLast(timestamp);
        IType otherTypeLast = otherType.getTypeRefdLast(timestamp);
        if (thisTypeLast == null || otherTypeLast == null || thisTypeLast.getIsErroneous(timestamp) || otherTypeLast.getIsErroneous(timestamp)) {
            return true;
        }
        return thisTypeLast.getTypetype().equals((Object)otherTypeLast.getTypetype());
    }

    @Override
    public CompatibilityLevel getCompatibility(CompilationTimeStamp timestamp, IType type, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        if (info == null) {
            ErrorReporter.INTERNAL_ERROR((String)"info==null");
        }
        if (!this.isCompatible(timestamp, type, info, leftChain, rightChain)) {
            return CompatibilityLevel.INCOMPATIBLE_TYPE;
        }
        if (noStructuredTypeCompatibility) {
            return CompatibilityLevel.COMPATIBLE;
        }
        SubType otherSubType = type.getSubtype();
        if (info != null && this.subType != null && otherSubType != null) {
            if (info.getStr1Elem()) {
                if (!info.getStr2Elem() && !otherSubType.isCompatibleWithElem(timestamp)) {
                    info.setSubtypeError("Subtype mismatch: string element has no common value with subtype " + otherSubType.toString());
                    return CompatibilityLevel.INCOMPATIBLE_SUBTYPE;
                }
            } else if (info.getStr2Elem()) {
                if (!this.subType.isCompatibleWithElem(timestamp)) {
                    info.setSubtypeError("Subtype mismatch: subtype " + this.subType.toString() + " has no common value with string element");
                    return CompatibilityLevel.INCOMPATIBLE_SUBTYPE;
                }
            } else if (!this.subType.isCompatible(timestamp, otherSubType)) {
                info.setSubtypeError("Subtype mismatch: subtype " + this.subType.toString() + " has no common value with subtype " + otherSubType.toString());
                return CompatibilityLevel.INCOMPATIBLE_SUBTYPE;
            }
        }
        return CompatibilityLevel.COMPATIBLE;
    }

    @Override
    public boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        this.check(timestamp);
        type.check(timestamp);
        IType temp = type.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return this.getTypetypeTtcn3().equals((Object)temp.getTypetypeTtcn3());
    }

    @Override
    public abstract String getTypename();

    @Override
    public abstract IType.Type_type getTypetypeTtcn3();

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder;
    }

    @Override
    public Identifier getIdentifier() {
        return null;
    }

    @Override
    public Object[] getOutlineChildren() {
        return new Object[0];
    }

    @Override
    public String getOutlineText() {
        return "";
    }

    @Override
    public int category() {
        return this.getTypetype().ordinal();
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
    }

    public static final boolean isCompatible(CompilationTimeStamp timestamp, IType.Type_type typeType1, IType.Type_type typeType2, boolean isAsn11, boolean isAsn12) {
        if (IType.Type_type.TYPE_UNDEFINED.equals((Object)typeType1) || IType.Type_type.TYPE_UNDEFINED.equals((Object)typeType2)) {
            return true;
        }
        switch (typeType1) {
            case TYPE_PORT: 
            case TYPE_SIGNATURE: 
            case TYPE_SEQUENCE_OF: 
            case TYPE_ARRAY: 
            case TYPE_SET_OF: 
            case TYPE_HEXSTRING: 
            case TYPE_NULL: 
            case TYPE_BOOL: 
            case TYPE_REAL: 
            case TYPE_VERDICT: 
            case TYPE_DEFAULT: 
            case TYPE_COMPONENT: 
            case TYPE_FUNCTION: 
            case TYPE_ALTSTEP: 
            case TYPE_TESTCASE: {
                return typeType1.equals((Object)typeType2);
            }
            case TYPE_OCTETSTRING: {
                return IType.Type_type.TYPE_OCTETSTRING.equals((Object)typeType2) || !isAsn11 && IType.Type_type.TYPE_ANY.equals((Object)typeType2);
            }
            case TYPE_UCHARSTRING: {
                switch (typeType2) {
                    case TYPE_CHARSTRING: 
                    case TYPE_UCHARSTRING: 
                    case TYPE_UTF8STRING: 
                    case TYPE_NUMERICSTRING: 
                    case TYPE_PRINTABLESTRING: 
                    case TYPE_TELETEXSTRING: 
                    case TYPE_VIDEOTEXSTRING: 
                    case TYPE_IA5STRING: 
                    case TYPE_GRAPHICSTRING: 
                    case TYPE_VISIBLESTRING: 
                    case TYPE_GENERALSTRING: 
                    case TYPE_UNIVERSALSTRING: 
                    case TYPE_BMPSTRING: 
                    case TYPE_UTCTIME: 
                    case TYPE_GENERALIZEDTIME: 
                    case TYPE_OBJECTDESCRIPTOR: {
                        return true;
                    }
                }
                return false;
            }
            case TYPE_UTF8STRING: 
            case TYPE_UNIVERSALSTRING: 
            case TYPE_BMPSTRING: {
                switch (typeType2) {
                    case TYPE_CHARSTRING: 
                    case TYPE_UCHARSTRING: 
                    case TYPE_UTF8STRING: 
                    case TYPE_NUMERICSTRING: 
                    case TYPE_PRINTABLESTRING: 
                    case TYPE_IA5STRING: 
                    case TYPE_VISIBLESTRING: 
                    case TYPE_UNIVERSALSTRING: 
                    case TYPE_BMPSTRING: 
                    case TYPE_UTCTIME: 
                    case TYPE_GENERALIZEDTIME: {
                        return true;
                    }
                }
                return false;
            }
            case TYPE_TELETEXSTRING: 
            case TYPE_VIDEOTEXSTRING: 
            case TYPE_GRAPHICSTRING: 
            case TYPE_GENERALSTRING: 
            case TYPE_OBJECTDESCRIPTOR: {
                switch (typeType2) {
                    case TYPE_CHARSTRING: 
                    case TYPE_UCHARSTRING: 
                    case TYPE_NUMERICSTRING: 
                    case TYPE_PRINTABLESTRING: 
                    case TYPE_TELETEXSTRING: 
                    case TYPE_VIDEOTEXSTRING: 
                    case TYPE_IA5STRING: 
                    case TYPE_GRAPHICSTRING: 
                    case TYPE_VISIBLESTRING: 
                    case TYPE_GENERALSTRING: 
                    case TYPE_UTCTIME: 
                    case TYPE_GENERALIZEDTIME: 
                    case TYPE_OBJECTDESCRIPTOR: {
                        return true;
                    }
                }
                return false;
            }
            case TYPE_CHARSTRING: 
            case TYPE_NUMERICSTRING: 
            case TYPE_PRINTABLESTRING: 
            case TYPE_IA5STRING: 
            case TYPE_VISIBLESTRING: 
            case TYPE_UTCTIME: 
            case TYPE_GENERALIZEDTIME: {
                switch (typeType2) {
                    case TYPE_CHARSTRING: 
                    case TYPE_NUMERICSTRING: 
                    case TYPE_PRINTABLESTRING: 
                    case TYPE_IA5STRING: 
                    case TYPE_VISIBLESTRING: 
                    case TYPE_UTCTIME: 
                    case TYPE_GENERALIZEDTIME: {
                        return true;
                    }
                }
                return false;
            }
            case TYPE_BITSTRING: 
            case TYPE_BITSTRING_A: {
                return IType.Type_type.TYPE_BITSTRING.equals((Object)typeType2) || IType.Type_type.TYPE_BITSTRING_A.equals((Object)typeType2);
            }
            case TYPE_INTEGER: 
            case TYPE_INTEGER_A: {
                return IType.Type_type.TYPE_INTEGER.equals((Object)typeType2) || IType.Type_type.TYPE_INTEGER_A.equals((Object)typeType2);
            }
            case TYPE_OBJECTID: {
                return IType.Type_type.TYPE_OBJECTID.equals((Object)typeType2) || !isAsn11 && IType.Type_type.TYPE_ROID.equals((Object)typeType2);
            }
            case TYPE_ROID: {
                return IType.Type_type.TYPE_ROID.equals((Object)typeType2) || !isAsn12 && IType.Type_type.TYPE_OBJECTID.equals((Object)typeType2);
            }
            case TYPE_TTCN3_ENUMERATED: 
            case TYPE_ASN1_ENUMERATED: {
                return IType.Type_type.TYPE_TTCN3_ENUMERATED.equals((Object)typeType2) || IType.Type_type.TYPE_ASN1_ENUMERATED.equals((Object)typeType2);
            }
            case TYPE_ASN1_CHOICE: 
            case TYPE_TTCN3_CHOICE: 
            case TYPE_OPENTYPE: {
                return IType.Type_type.TYPE_TTCN3_CHOICE.equals((Object)typeType2) || IType.Type_type.TYPE_ASN1_CHOICE.equals((Object)typeType2) || IType.Type_type.TYPE_OPENTYPE.equals((Object)typeType2);
            }
            case TYPE_ASN1_SEQUENCE: 
            case TYPE_TTCN3_SEQUENCE: {
                return IType.Type_type.TYPE_TTCN3_SEQUENCE.equals((Object)typeType2) || IType.Type_type.TYPE_ASN1_SEQUENCE.equals((Object)typeType2);
            }
            case TYPE_ASN1_SET: 
            case TYPE_TTCN3_SET: {
                return IType.Type_type.TYPE_TTCN3_SET.equals((Object)typeType2) || IType.Type_type.TYPE_ASN1_SET.equals((Object)typeType2);
            }
            case TYPE_ANY: {
                return IType.Type_type.TYPE_ANY.equals((Object)typeType2) || IType.Type_type.TYPE_OCTETSTRING.equals((Object)typeType2);
            }
            case TYPE_REFERENCED: 
            case TYPE_OBJECTCLASSFIELDTYPE: 
            case TYPE_ADDRESS: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.subType != null) {
            this.subType.updateSyntax(reparser, false);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public Assignment getDefiningAssignment() {
        if (this.getMyScope() == null) {
            return null;
        }
        Module module = this.getMyScope().getModuleScope();
        Assignment assignment = module.getEnclosingAssignment(this.getLocation().getOffset());
        return assignment;
    }

    @Override
    public void getEnclosingField(int offset, ReferenceFinder rf) {
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.constraints != null) {
            this.constraints.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.parsedRestrictions != null) {
            for (ParsedSubType parsedSubType : this.parsedRestrictions) {
                parsedSubType.findReferences(referenceFinder, foundIdentifiers);
            }
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.constraints != null && !this.constraints.accept(v)) {
            return false;
        }
        if (this.withAttributesPath != null && !this.withAttributesPath.accept(v)) {
            return false;
        }
        if (this.parsedRestrictions != null) {
            for (ParsedSubType pst : this.parsedRestrictions) {
                if (pst.accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    static {
        final IPreferencesService ps = Platform.getPreferencesService();
        if (ps != null) {
            typeCompatibilitySeverity = ps.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportTypeCompatibility", "warning", null);
            noStructuredTypeCompatibility = "error".equals(typeCompatibilitySeverity);
            Activator activator = Activator.getDefault();
            if (activator != null) {
                activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        String property = event.getProperty();
                        if ("org.eclipse.titan.designer.reportTypeCompatibility".equals(property)) {
                            typeCompatibilitySeverity = ps.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportTypeCompatibility", "warning", null);
                            noStructuredTypeCompatibility = "error".equals(typeCompatibilitySeverity);
                        }
                    }
                });
            }
        }
    }

    public static enum CompatibilityLevel {
        INCOMPATIBLE_TYPE,
        INCOMPATIBLE_SUBTYPE,
        COMPATIBLE;

    }
}

