/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Hexstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Octetstring_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Oct2HexExpression
extends Expression_Value {
    private static final String OPERANDERROR = "The operand of the `oct2hex' operation should be an octetstring value";
    private final Value value;

    public Oct2HexExpression(Value value) {
        this.value = value;
        if (value != null) {
            value.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.OCT2HEX_OPERATION;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append("oct2hex(").append(this.value.createStringRepresentation()).append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value == child) {
            return builder.append(".<operand>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_HEXSTRING;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value == null) {
            return true;
        }
        return this.value.isUnfoldable(timestamp, expectedValue, referenceChain);
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value == null) {
            return;
        }
        this.value.setLoweridToReference(timestamp);
        IType.Type_type tempType = this.value.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType) {
            case TYPE_OCTETSTRING: {
                this.value.getValueRefdLast(timestamp, expectedValue, referenceChain);
                return;
            }
            case TYPE_UNDEFINED: {
                this.setIsErroneous(true);
                return;
            }
        }
        if (!this.isErroneous) {
            this.location.reportSemanticError(OPERANDERROR);
            this.setIsErroneous(true);
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.value == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp)) {
            return this.lastValue;
        }
        if (this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        IValue last = this.value.getValueRefdLast(timestamp, referenceChain);
        if (last.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return this.lastValue;
        }
        switch (last.getValuetype()) {
            case OCTETSTRING_VALUE: {
                String octetString = ((Octetstring_Value)last).getValue();
                this.lastValue = new Hexstring_Value(octetString.toUpperCase());
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            default: {
                this.setIsErroneous(true);
            }
        }
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this) && this.value != null) {
            referenceChain.markState();
            this.value.checkRecursions(timestamp, referenceChain);
            referenceChain.previousState();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value == null) {
            return;
        }
        this.value.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.value == null || this.value.accept(v);
    }
}

