/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferencingType;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Address_Type
extends Type
implements IReferencingType {
    private IType address;

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_ADDRESS;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        return false;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        return "address";
    }

    @Override
    public String getOutlineIcon() {
        return "address.gif";
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.isErroneous = false;
        this.parseAttributes(timestamp);
        IType referencedLast = this.getTypeRefdLast(timestamp);
        if (referencedLast == null || referencedLast.getIsErroneous(timestamp)) {
            return;
        }
        referencedLast.check(timestamp);
    }

    public static void checkAddress(CompilationTimeStamp timestamp, Type type) {
        IType referencedLast = type.getTypeRefdLast(timestamp);
        if (referencedLast == null || referencedLast.getIsErroneous(timestamp)) {
            return;
        }
        referencedLast.check(timestamp);
        switch (referencedLast.getTypetype()) {
            case TYPE_PORT: {
                type.getLocation().reportSemanticError(MessageFormat.format("Port type `{0}'' cannot be the address type", referencedLast.getTypename()));
                break;
            }
            case TYPE_COMPONENT: {
                type.getLocation().reportSemanticError(MessageFormat.format("Component type `{0}'' cannot be the address type", referencedLast.getTypename()));
                break;
            }
            case TYPE_SIGNATURE: {
                type.getLocation().reportSemanticError(MessageFormat.format("Signature type `{0}'' cannot be the address type", referencedLast.getTypename()));
                break;
            }
            case TYPE_DEFAULT: {
                type.getLocation().reportSemanticError("The default type cannot be the address type");
                break;
            }
            case TYPE_ANY: {
                type.getLocation().reportSemanticError("The any type cannot be the address type");
                break;
            }
        }
    }

    @Override
    public IValue checkThisValueRef(CompilationTimeStamp timestamp, IValue value) {
        if (IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)value.getValuetype())) {
            ReferenceChain tempReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            IType refd = this.getTypeRefd(timestamp, tempReferenceChain);
            tempReferenceChain.release();
            if (refd == null || this.equals(refd)) {
                return value;
            }
            return refd.checkThisValueRef(timestamp, value);
        }
        return value;
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        IType tempType = this.getTypeRefd(timestamp, null);
        if (tempType != this) {
            tempType.checkThisValue(timestamp, value, valueCheckingOptions);
        }
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        IType tempType = this.getTypeRefd(timestamp, null);
        if (tempType != this) {
            tempType.checkThisTemplate(timestamp, template, isModified, implicitOmit);
        }
    }

    @Override
    public IType getTypeRefdLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        boolean newChain = null == referenceChain;
        IReferenceChain tempReferenceChain = newChain ? ReferenceChain.getInstance("Circular reference chain: `{0}''", true) : referenceChain;
        IType lastType = this;
        while (lastType != null && lastType instanceof IReferencingType && !lastType.getIsErroneous(timestamp)) {
            lastType = ((IReferencingType)((Object)lastType)).getTypeRefd(timestamp, tempReferenceChain);
        }
        if (newChain) {
            tempReferenceChain.release();
        }
        if (lastType != null && lastType.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
        }
        return lastType;
    }

    @Override
    public IType getTypeRefd(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (refChain != null && !refChain.add(this)) {
            this.setIsErroneous(true);
            return this;
        }
        if (this.myScope != null) {
            TTCN3Module module = (TTCN3Module)this.myScope.getModuleScope();
            this.address = module.getAddressType(timestamp);
            if (this.address != null) {
                return this.address;
            }
            this.location.reportSemanticError("Type `address' is not defined in this module");
        }
        this.setIsErroneous(true);
        return this;
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        if (this.lastTimeChecked == null) {
            this.check(timestamp);
        }
        if (this.address != null && this != this.address) {
            Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
            IType temp = this.address.getFieldType(timestamp, reference, actualSubReference, internalExpectation, refChain, false);
            if (reference.getIsErroneous(timestamp)) {
                this.setIsErroneous(true);
            }
            return temp;
        }
        return this;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            ReferenceChain tempReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            IType lastType = this.getTypeRefd(timestamp, tempReferenceChain);
            tempReferenceChain.release();
            if (lastType != null && !lastType.getIsErroneous(timestamp) && !this.equals(lastType)) {
                lastType.checkRecursions(timestamp, referenceChain);
            }
        }
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("address");
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.address != null) {
            this.address.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.address == null || this.address.accept(v);
    }
}

