/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.statements.Catch_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Check_Catch_Statement
extends Statement {
    private static final String FULLNAMEPART1 = ".portreference";
    private static final String FULLNAMEPART2 = ".signaturereference";
    private static final String FULLNAMEPART3 = ".parameter";
    private static final String FULLNAMEPART4 = ".from";
    private static final String FULLNAMEPART5 = ".redirecvalue";
    private static final String FULLNAMEPART6 = ".redirectSender";
    private static final String STATEMENT_NAME = "check-catch";
    private final Reference portReference;
    private final Reference signatureReference;
    private final TemplateInstance parameter;
    private final boolean timeout;
    private final TemplateInstance fromClause;
    private final Reference redirectValue;
    private final Reference redirectSender;

    public Check_Catch_Statement(Reference portReference, Reference signatureReference, TemplateInstance parameter, boolean timeout, TemplateInstance fromClause, Reference redirectValue, Reference redirectSender) {
        this.portReference = portReference;
        this.signatureReference = signatureReference;
        this.parameter = parameter;
        this.timeout = timeout;
        this.fromClause = fromClause;
        this.redirectValue = redirectValue;
        this.redirectSender = redirectSender;
        if (portReference != null) {
            portReference.setFullNameParent(this);
        }
        if (signatureReference != null) {
            signatureReference.setFullNameParent(this);
        }
        if (parameter != null) {
            parameter.setFullNameParent(this);
        }
        if (fromClause != null) {
            fromClause.setFullNameParent(this);
        }
        if (redirectValue != null) {
            redirectValue.setFullNameParent(this);
        }
        if (redirectSender != null) {
            redirectSender.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_CHECK_CATCH;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.portReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.signatureReference == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.parameter == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.fromClause == child) {
            return builder.append(FULLNAMEPART4);
        }
        if (this.redirectValue == child) {
            return builder.append(FULLNAMEPART5);
        }
        if (this.redirectSender == child) {
            return builder.append(FULLNAMEPART6);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.portReference != null) {
            this.portReference.setMyScope(scope);
        }
        if (this.signatureReference != null) {
            this.signatureReference.setMyScope(scope);
        }
        if (this.parameter != null) {
            this.parameter.setMyScope(scope);
        }
        if (this.fromClause != null) {
            this.fromClause.setMyScope(scope);
        }
        if (this.redirectValue != null) {
            this.redirectValue.setMyScope(scope);
        }
        if (this.redirectSender != null) {
            this.redirectSender.setMyScope(scope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        Catch_Statement.checkCatch(timestamp, this, STATEMENT_NAME, this.portReference, this.signatureReference, this.parameter, this.timeout, this.fromClause, this.redirectValue, this.redirectSender);
        if (this.redirectValue != null) {
            this.redirectValue.setUsedOnLeftHandSide();
        }
        if (this.redirectSender != null) {
            this.redirectSender.setUsedOnLeftHandSide();
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.redirectSender != null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(129);
        if (this.redirectValue != null) {
            return result;
        }
        result.add(219);
        if (this.fromClause != null) {
            return result;
        }
        result.add(54);
        if (this.signatureReference == null || !this.timeout) {
            result.add(251);
        }
        result.add(251);
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.portReference != null) {
            this.portReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference.getLocation());
        }
        if (this.signatureReference != null) {
            this.signatureReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.signatureReference.getLocation());
        }
        if (this.parameter != null) {
            this.parameter.updateSyntax(reparser, false);
            reparser.updateLocation(this.parameter.getLocation());
        }
        if (this.fromClause != null) {
            this.fromClause.updateSyntax(reparser, false);
            reparser.updateLocation(this.fromClause.getLocation());
        }
        if (this.redirectValue != null) {
            this.redirectValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectValue.getLocation());
        }
        if (this.redirectSender != null) {
            this.redirectSender.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectSender.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.portReference != null) {
            this.portReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.signatureReference != null) {
            this.signatureReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.parameter != null) {
            this.parameter.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.fromClause != null) {
            this.fromClause.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectValue != null) {
            this.redirectValue.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectSender != null) {
            this.redirectSender.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.portReference != null && !this.portReference.accept(v)) {
            return false;
        }
        if (this.signatureReference != null && !this.signatureReference.accept(v)) {
            return false;
        }
        if (this.parameter != null && !this.parameter.accept(v)) {
            return false;
        }
        if (this.fromClause != null && !this.fromClause.accept(v)) {
            return false;
        }
        if (this.redirectValue != null && !this.redirectValue.accept(v)) {
            return false;
        }
        return this.redirectSender == null || this.redirectSender.accept(v);
    }
}

