/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.p2.internal.repository.tools.Repo2Runnable;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.P2TargetUtils;

public class ExportTargetJob
extends Job {
    private URI fDestination;
    private boolean fclearDestinationDirectory = true;
    private IFileStore featureDir;
    private IFileStore pluginDir;
    private IFileSystem fileSystem;
    private Map<String, NameVersionDescriptor[]> filter;
    private ITargetDefinition fTarget;

    public ExportTargetJob(ITargetDefinition target, URI destination, boolean clearDestinationDirectory) {
        super("Export Current Target Definition Job");
        this.fTarget = target;
        this.fDestination = destination;
        this.fclearDestinationDirectory = clearDestinationDirectory;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            try {
                this.constructFilter(this.fTarget);
                ITargetLocation[] containers = this.fTarget.getTargetLocations();
                int totalWork = containers.length;
                monitor.beginTask(PDECoreMessages.ExportTargetDefinition_task, totalWork);
                monitor.subTask(PDECoreMessages.ExportTargetJob_ConfiguringDestination);
                this.setupDestination(monitor);
                monitor.subTask(PDECoreMessages.ExportTargetJob_ExportingTargetContents);
                int i = 0;
                while (i < containers.length) {
                    ITargetLocation container = containers[i];
                    container.resolve(this.fTarget, monitor);
                    if (!(container instanceof IUBundleContainer)) {
                        this.exportContainer(container, this.fTarget, this.featureDir, this.pluginDir, this.fileSystem, monitor);
                    }
                    ++i;
                }
                this.exportProfile(this.fTarget, this.fDestination, monitor);
            }
            catch (CoreException e) {
                Status status = new Status(4, "org.eclipse.pde.core", "Failed to export the target", (Throwable)e);
                monitor.done();
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private void constructFilter(ITargetDefinition target) {
        NameVersionDescriptor[] included = target.getIncluded();
        if (included == null) {
            return;
        }
        this.filter = new HashMap<String, NameVersionDescriptor[]>();
        int i = 0;
        while (i < included.length) {
            NameVersionDescriptor inclusion = included[i];
            NameVersionDescriptor[] versions = this.filter.get(inclusion.getId());
            if (versions == null) {
                this.filter.put(inclusion.getId(), new NameVersionDescriptor[]{inclusion});
            } else {
                NameVersionDescriptor[] versions2 = new NameVersionDescriptor[versions.length + 1];
                System.arraycopy(versions, 0, versions2, 0, versions.length);
                versions2[versions.length] = inclusion;
                this.filter.put(inclusion.getId(), versions2);
            }
            ++i;
        }
    }

    private void setupDestination(IProgressMonitor monitor) throws CoreException {
        this.fileSystem = EFS.getLocalFileSystem();
        if (!this.fileSystem.canWrite()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", "Destination directory not writable."));
        }
        IFileStore destination = this.fileSystem.getStore(this.fDestination);
        this.featureDir = destination.getChild("features");
        this.pluginDir = destination.getChild("plugins");
        if (this.fclearDestinationDirectory) {
            monitor.subTask(PDECoreMessages.ExportTargetDeleteOldData);
            this.featureDir.delete(0, null);
            this.pluginDir.delete(0, null);
        }
        this.featureDir.mkdir(0, null);
        this.pluginDir.mkdir(0, null);
    }

    private boolean shouldExport(NameVersionDescriptor descriptor) {
        if (this.filter == null || descriptor.getType().equals("feature")) {
            return true;
        }
        NameVersionDescriptor[] versions = this.filter.get(descriptor.getId());
        if (versions == null) {
            return false;
        }
        int i = 0;
        while (i < versions.length) {
            String version = versions[i].getVersion();
            if ((version == null || version.equals(descriptor.getVersion())) && descriptor.getType().equals(versions[i].getType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean shouldExport(TargetFeature feature) {
        if (this.filter == null) {
            return true;
        }
        NameVersionDescriptor descriptor = new NameVersionDescriptor(feature.getId(), feature.getVersion(), "feature");
        return this.shouldExport(descriptor);
    }

    private boolean shouldExport(TargetBundle bundle) {
        if (this.filter == null) {
            return true;
        }
        NameVersionDescriptor descriptor = new NameVersionDescriptor(bundle.getBundleInfo().getSymbolicName(), bundle.getBundleInfo().getVersion(), "plugin");
        return this.shouldExport(descriptor);
    }

    private boolean shouldExport(IInstallableUnit iu) {
        if (this.filter == null) {
            return true;
        }
        NameVersionDescriptor descriptor = null;
        String feature = this.getCapability(iu, "org.eclipse.update.feature");
        if (feature != null) {
            descriptor = new NameVersionDescriptor(feature, iu.getVersion().toString(), "feature");
        } else if (iu.getId().endsWith(".feature.group")) {
            descriptor = new NameVersionDescriptor(iu.getId(), iu.getVersion().toString(), "feature");
        } else if ("bundle".equalsIgnoreCase(this.getCapability(iu, "org.eclipse.equinox.p2.eclipse.type"))) {
            descriptor = new NameVersionDescriptor(iu.getId(), iu.getVersion().toString(), "plugin");
        } else if ("source".equalsIgnoreCase(this.getCapability(iu, "org.eclipse.equinox.p2.eclipse.type"))) {
            descriptor = new NameVersionDescriptor(iu.getId(), iu.getVersion().toString(), "plugin");
        }
        return descriptor == null ? true : this.shouldExport(descriptor);
    }

    private String getCapability(IInstallableUnit iu, String namespace) {
        for (IProvidedCapability capability : iu.getProvidedCapabilities()) {
            if (!capability.getNamespace().equals(namespace)) continue;
            return capability.getName();
        }
        return null;
    }

    private void exportContainer(ITargetLocation container, ITargetDefinition target, IFileStore featureDir, IFileStore pluginDir, IFileSystem fileSystem, IProgressMonitor monitor) throws CoreException {
        TargetBundle[] bundles;
        TargetFeature[] features = container.getFeatures();
        if (features != null) {
            monitor.subTask(PDECoreMessages.ExportTargetExportFeatures);
            int i = 0;
            while (i < features.length) {
                if (this.shouldExport(features[i])) {
                    this.copy(features[i].getLocation(), featureDir, fileSystem, monitor);
                }
                ++i;
            }
        }
        if ((bundles = container.getBundles()) != null) {
            monitor.subTask(PDECoreMessages.ExportTargetExportPlugins);
            int i = 0;
            while (i < bundles.length) {
                if (this.shouldExport(bundles[i])) {
                    this.copy(bundles[i].getBundleInfo().getLocation().getPath(), pluginDir, fileSystem, monitor);
                }
                ++i;
            }
        }
    }

    private IStatus copy(String src, IFileStore destinationParent, IFileSystem fileSystem, IProgressMonitor monitor) throws CoreException {
        Path srcPath = new Path(src);
        IFileStore source = fileSystem.getStore((IPath)srcPath);
        String elementName = srcPath.segment(srcPath.segmentCount() - 1);
        IFileStore destination = destinationParent.getChild(elementName);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (destination.fetchInfo().exists()) {
            return Status.OK_STATUS;
        }
        if (source.fetchInfo().isDirectory()) {
            destination.mkdir(0, (IProgressMonitor)new NullProgressMonitor());
        }
        source.copy(destination, 2, (IProgressMonitor)subMonitor.split(1));
        return Status.OK_STATUS;
    }

    private RepositoryDescriptor createRepoDescriptor(URI location, String name, String kind) {
        RepositoryDescriptor result = new RepositoryDescriptor();
        result.setLocation(location);
        result.setKind(kind);
        result.setName(name);
        if (this.fclearDestinationDirectory) {
            result.setAppend(false);
        }
        return result;
    }

    private void exportProfile(ITargetDefinition target, URI destination, IProgressMonitor monitor) throws CoreException {
        Repo2Runnable exporter = new Repo2Runnable();
        exporter.addDestination(this.createRepoDescriptor(destination, P2TargetUtils.getProfileId(target), "M"));
        exporter.addDestination(this.createRepoDescriptor(destination, P2TargetUtils.getProfileId(target), "A"));
        exporter.addSource(this.createRepoDescriptor(P2TargetUtils.getBundlePool().getLocation(), null, "A"));
        IQueryResult<?> ius = P2TargetUtils.getIUs(target, monitor);
        ArrayList<IInstallableUnit> toExport = new ArrayList<IInstallableUnit>();
        for (IInstallableUnit iu : ius) {
            if (!this.shouldExport(iu)) continue;
            toExport.add(iu);
        }
        exporter.setSourceIUs(toExport);
        exporter.run(monitor);
    }
}

