/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetElementAdapter;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public final class BasicWorkingSetElementAdapter
implements IWorkingSetElementAdapter,
IExecutableExtension {
    private Type[] preferredTypes = new Type[0];
    private ServiceTracker packageTracker;

    @Override
    public IAdaptable[] adaptElements(IWorkingSet ws, IAdaptable[] elements) {
        ArrayList<IAdaptable> adaptedElements = new ArrayList<IAdaptable>();
        IAdaptable[] iAdaptableArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable element = iAdaptableArray[n2];
            IAdaptable adaptable = this.adapt(element);
            if (adaptable != null) {
                adaptedElements.add(adaptable);
            }
            ++n2;
        }
        return adaptedElements.toArray(new IAdaptable[adaptedElements.size()]);
    }

    private IAdaptable adapt(IAdaptable adaptable) {
        Type[] typeArray = this.preferredTypes;
        int n = this.preferredTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Type preferredType = typeArray[n2];
            IAdaptable adaptedAdaptable = this.adapt(preferredType, adaptable);
            if (adaptedAdaptable != null) {
                return adaptedAdaptable;
            }
            ++n2;
        }
        return null;
    }

    private IAdaptable adapt(Type type, IAdaptable adaptable) {
        Class[] directClasses;
        IAdapterManager adapterManager = Platform.getAdapterManager();
        Class[] classArray = directClasses = adapterManager.computeClassOrder(adaptable.getClass());
        int n = directClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            if (clazz.getName().equals(type.className)) {
                return adaptable;
            }
            ++n2;
        }
        if ((type.flags & 1) != 0) {
            String packageName;
            ExportedPackage[] packages;
            int lastDot;
            Object adapted = adapterManager.getAdapter((Object)adaptable, type.className);
            if (adapted instanceof IAdaptable) {
                return (IAdaptable)adapted;
            }
            PackageAdmin admin = this.getPackageAdmin();
            if (admin != null && (lastDot = type.className.lastIndexOf(46)) > 0 && (packages = admin.getExportedPackages(packageName = type.className.substring(0, lastDot))) != null && packages.length == 1 && packages[0].getExportingBundle().getState() == 32) {
                try {
                    adapted = adaptable.getAdapter(packages[0].getExportingBundle().loadClass(type.className));
                    if (adapted instanceof IAdaptable) {
                        return (IAdaptable)adapted;
                    }
                }
                catch (ClassNotFoundException e) {
                    WorkbenchPlugin.log(e);
                }
            }
        }
        return null;
    }

    @Override
    public void dispose() {
        if (this.packageTracker != null) {
            this.packageTracker.close();
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        if (data instanceof String) {
            ArrayList<Type> preferredTypes = new ArrayList<Type>(0);
            StringTokenizer toker = new StringTokenizer((String)data, ",");
            while (toker.hasMoreTokens()) {
                String classNameAndOptions = toker.nextToken();
                Type record = new Type();
                this.parseOptions(classNameAndOptions, record);
                preferredTypes.add(record);
            }
            this.preferredTypes = preferredTypes.toArray(new Type[preferredTypes.size()]);
        }
    }

    private void parseOptions(String classNameAndOptions, Type record) {
        StringTokenizer toker = new StringTokenizer(classNameAndOptions, ";");
        while (toker.hasMoreTokens()) {
            String token = toker.nextToken();
            if (record.className == null) {
                record.className = token;
                continue;
            }
            StringTokenizer pair = new StringTokenizer(token, "=");
            while (pair.hasMoreTokens()) {
                if (pair.countTokens() != 2) continue;
                String param = pair.nextToken();
                String value = pair.nextToken();
                if (!"adapt".equals(param)) continue;
                record.flags = record.flags ^ ("true".equals(value) ? 1 : 0);
            }
        }
    }

    private PackageAdmin getPackageAdmin() {
        if (this.packageTracker == null) {
            this.packageTracker = new ServiceTracker(WorkbenchPlugin.getDefault().getBundleContext(), PackageAdmin.class.getName(), null);
            this.packageTracker.open();
        }
        return (PackageAdmin)this.packageTracker.getService();
    }

    private class Type {
        private static final int NONE = 0;
        private static final int ADAPT = 1;
        String className;
        int flags;

        private Type() {
        }
    }
}

