/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.applicationimpl;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.el.FacesCompositeELResolver;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContextListener;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.enterprise.inject.spi.el.ELAwareBeanManager;
import jakarta.faces.context.FacesContext;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ExpressionLanguage {
    private static final ELContextListener[] EMPTY_EL_CTX_LIST_ARRAY = new ELContextListener[0];
    private final ApplicationAssociate associate;
    private final List<ELContextListener> elContextListeners;
    private final CompositeELResolver elResolvers;
    private volatile FacesCompositeELResolver compositeELResolver;

    public ExpressionLanguage(ApplicationAssociate applicationAssociate) {
        this.associate = applicationAssociate;
        this.elContextListeners = new CopyOnWriteArrayList<ELContextListener>();
        this.elResolvers = new CompositeELResolver();
    }

    public void addELContextListener(ELContextListener listener) {
        if (listener != null) {
            this.elContextListeners.add(listener);
        }
    }

    public void removeELContextListener(ELContextListener listener) {
        if (listener != null) {
            this.elContextListeners.remove(listener);
        }
    }

    public ELContextListener[] getELContextListeners() {
        if (!this.elContextListeners.isEmpty()) {
            return this.elContextListeners.toArray(new ELContextListener[this.elContextListeners.size()]);
        }
        return EMPTY_EL_CTX_LIST_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ELResolver getELResolver() {
        if (this.compositeELResolver == null) {
            ExpressionLanguage expressionLanguage = this;
            synchronized (expressionLanguage) {
                if (this.compositeELResolver == null) {
                    this.performOneTimeELInitialization();
                }
            }
        }
        return this.compositeELResolver;
    }

    public void addELResolver(ELResolver resolver) {
        if (this.associate.hasRequestBeenServiced()) {
            throw new IllegalStateException(MessageUtils.getExceptionMessageString("com.sun.faces.ILLEGAL_ATTEMPT_SETTING_APPLICATION_ARTIFACT", "ELResolver"));
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELAwareBeanManager cdiBeanManager = Util.getCdiBeanManager(facesContext);
        if (!resolver.equals(cdiBeanManager.getELResolver())) {
            this.elResolvers.add(resolver);
        }
    }

    public ExpressionFactory getExpressionFactory() {
        return this.associate.getExpressionFactory();
    }

    public <T> T evaluateExpressionGet(FacesContext context, String expression, Class<? extends T> expectedType) throws ELException {
        return (T)this.getExpressionFactory().createValueExpression(context.getELContext(), expression, expectedType).getValue(context.getELContext());
    }

    public CompositeELResolver getApplicationELResolvers() {
        return this.elResolvers;
    }

    public FacesCompositeELResolver getCompositeELResolver() {
        return this.compositeELResolver;
    }

    public void setCompositeELResolver(FacesCompositeELResolver compositeELResolver) {
        this.compositeELResolver = compositeELResolver;
    }

    private void performOneTimeELInitialization() {
        if (this.compositeELResolver != null) {
            throw new IllegalStateException("Class invariant invalidated: The Application instance's ELResolver is not null and it should be.");
        }
        this.associate.initializeELResolverChains();
    }
}

