/*
 * Decompiled with CFR 0.152.
 */
package jakarta.security.enterprise.authentication.mechanism.http;

import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.enterprise.util.Nonbinding;
import jakarta.interceptor.InterceptorBinding;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Inherited
@InterceptorBinding
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface LoginToContinue {
    @Nonbinding
    public String loginPage() default "/login";

    @Nonbinding
    public boolean useForwardToLogin() default true;

    @Nonbinding
    public String useForwardToLoginExpression() default "";

    @Nonbinding
    public String errorPage() default "/login-error";

    public static final class Literal
    extends AnnotationLiteral<LoginToContinue>
    implements LoginToContinue {
        private static final long serialVersionUID = 1L;
        private final String loginPage;
        private final boolean useForwardToLogin;
        private final String useForwardToLoginExpression;
        private final String errorPage;
        public static final Literal INSTANCE = Literal.of("/login", true, "", "/login-error");

        public static Literal of(String loginPage, boolean useForwardToLogin, String useForwardToLoginExpression, String errorPage) {
            return new Literal(loginPage, useForwardToLogin, useForwardToLoginExpression, errorPage);
        }

        private Literal(String loginPage, boolean useForwardToLogin, String useForwardToLoginExpression, String errorPage) {
            this.loginPage = loginPage;
            this.useForwardToLogin = useForwardToLogin;
            this.useForwardToLoginExpression = useForwardToLoginExpression;
            this.errorPage = errorPage;
        }

        @Override
        public String loginPage() {
            return this.loginPage;
        }

        @Override
        public boolean useForwardToLogin() {
            return this.useForwardToLogin;
        }

        @Override
        public String useForwardToLoginExpression() {
            return this.useForwardToLoginExpression;
        }

        @Override
        public String errorPage() {
            return this.errorPage;
        }
    }
}

