/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.PropertiesFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class EnvironmentVariables {
    private static final Pattern DASH_PATTERN = Pattern.compile("_dash_|_DASH_");
    private static final String UNDERSCORE = "_";
    private static final String DOUBLE_UNDERSCORE = "__";
    private static final String DASH = "-";
    private static final char UNDERSCORE_CHAR = '_';
    private static final char DOT_CHAR = '.';

    public static boolean shouldAlias(String name) {
        int length = name.length();
        return length > 2 && name.charAt(0) != '_' && name.charAt(length - 1) != '_' && name.contains(UNDERSCORE) && !name.contains(DOUBLE_UNDERSCORE);
    }

    public static Map<String, String> expand() {
        return EnvironmentVariables.expand(PropertiesFilter.create(System.getProperties()).filter(System.getenv()));
    }

    public static Map<String, String> expand(Map<String, String> env) {
        HashMap result = new HashMap(env.size());
        env.forEach((name, value) -> {
            result.put(name, value);
            if (EnvironmentVariables.shouldAlias(name)) {
                String alias = DASH_PATTERN.matcher((CharSequence)name).replaceAll(DASH);
                alias = alias.replace('_', '.');
                result.put(alias, value);
                result.put(alias.toLowerCase(), value);
            }
        });
        return Collections.unmodifiableMap(result);
    }

    private EnvironmentVariables() {
    }
}

