/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.ease.ui.scripts.repository.IScriptListener;
import org.eclipse.ease.ui.scripts.repository.impl.ParameterDelta;
import org.eclipse.ease.ui.scripts.repository.impl.RepositoryService;
import org.eclipse.ease.ui.scripts.repository.impl.ScriptContributionFactory;
import org.eclipse.ease.ui.scripts.repository.impl.ScriptContributionItem;
import org.eclipse.ease.ui.scripts.repository.impl.ScriptEvent;
import org.eclipse.ease.ui.tools.LocationImageDescriptor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class UIIntegrationJob
extends UIJob
implements IScriptListener {
    private static final String KEYWORD_NAME = "name";
    private static final String KEYWORD_IMAGE = "image";
    private static final String KEYWORD_POPUP = "popup";
    private static final String KEYWORD_MENU = "menu";
    private static final String KEYWORD_TOOLBAR = "toolbar";
    public static final String POPUP_LOCATION = "org.eclipse.ui.popup.any?after=additions";
    private final Map<String, ScriptContributionFactory> fContributionFactories = new HashMap<String, ScriptContributionFactory>();
    private final Collection<IScript> fAddedScripts = Collections.synchronizedCollection(new HashSet());
    private final Collection<IScript> fRemovedScripts = Collections.synchronizedCollection(new HashSet());
    private final Map<IScript, ParameterDelta> fChangedScripts = Collections.synchronizedMap(new HashMap());

    public UIIntegrationJob(RepositoryService repositoryService) {
        super("Update script UI components");
        repositoryService.addScriptListener(this);
        this.fAddedScripts.addAll(repositoryService.getScripts());
        if (!this.fAddedScripts.isEmpty()) {
            this.schedule(300L);
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized IStatus runInUIThread(IProgressMonitor monitor) {
        block3: {
            if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) ** GOTO lbl8
            PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

                public void windowOpened(IWorkbenchWindow window) {
                }

                public void windowDeactivated(IWorkbenchWindow window) {
                }

                public void windowClosed(IWorkbenchWindow window) {
                }

                public void windowActivated(IWorkbenchWindow window) {
                    PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
                    UIIntegrationJob.this.schedule();
                }
            });
            break block3;
lbl-1000:
            // 1 sources

            {
                script = this.fAddedScripts.iterator().next();
                this.fAddedScripts.remove(script);
                this.handleAdditions(script);
lbl8:
                // 2 sources

                ** while (!this.fAddedScripts.isEmpty())
            }
lbl9:
            // 2 sources

            while (!this.fRemovedScripts.isEmpty()) {
                script = this.fRemovedScripts.iterator().next();
                this.fRemovedScripts.remove(script);
                this.handleRemoval(script);
            }
            while (!this.fChangedScripts.isEmpty()) {
                pair = this.fChangedScripts.entrySet().iterator().next();
                this.fChangedScripts.remove(pair.getKey());
                this.handleParameterChange(pair.getKey(), pair.getValue());
            }
        }
        return Status.OK_STATUS;
    }

    private void handleAdditions(IScript script) {
        String[] stringArray = new String[]{KEYWORD_TOOLBAR, KEYWORD_MENU, KEYWORD_POPUP};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String scheme = stringArray[n2];
            if (script.getParameters().containsKey(scheme)) {
                LocationDescription location = new LocationDescription(scheme, script.getParameters().get(scheme));
                this.addViewContribution(location, script);
            }
            ++n2;
        }
    }

    private void handleRemoval(IScript script) {
        String[] stringArray = new String[]{KEYWORD_TOOLBAR, KEYWORD_MENU, KEYWORD_POPUP};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String scheme = stringArray[n2];
            if (script.getParameters().containsKey(scheme)) {
                LocationDescription location = new LocationDescription(scheme, script.getParameters().get(scheme));
                this.removeViewContribution(location, script);
            }
            ++n2;
        }
    }

    private void handleParameterChange(IScript script, ParameterDelta parameterDelta) {
        String[] stringArray = new String[]{KEYWORD_TOOLBAR, KEYWORD_MENU, KEYWORD_POPUP};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String scheme = stringArray[n2];
            this.modifyViewContribution(scheme, script, parameterDelta);
            ++n2;
        }
    }

    private void modifyViewContribution(String scheme, IScript script, ParameterDelta parameterDelta) {
        if (parameterDelta.isRemoved(scheme) || parameterDelta.isModified(scheme)) {
            LocationDescription oldLocation = new LocationDescription(scheme, parameterDelta.getOldParameter(scheme));
            this.removeViewContribution(oldLocation, script);
        }
        if (parameterDelta.isAdded(scheme) || parameterDelta.isModified(scheme)) {
            LocationDescription newLocation = new LocationDescription(scheme, script.getParameters().get(scheme));
            this.addViewContribution(newLocation, script);
        } else if (script.getParameters().containsKey(scheme) && (parameterDelta.isAffected(KEYWORD_NAME) || parameterDelta.isAffected(KEYWORD_IMAGE))) {
            IViewPart view;
            LocationDescription location = new LocationDescription(scheme, script.getParameters().get(scheme));
            if (location.fName == null && (view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(location.fViewID)) instanceof ViewPart && view.getViewSite() != null) {
                IContributionItem[] contributions = KEYWORD_TOOLBAR.equals(location.fScheme) ? view.getViewSite().getActionBars().getToolBarManager().getItems() : (KEYWORD_MENU.equals(location.fScheme) ? view.getViewSite().getActionBars().getMenuManager().getItems() : new IContributionItem[]{});
                IContributionItem[] iContributionItemArray = contributions;
                int n = contributions.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    if (item instanceof ScriptContributionItem && item.getId().equals(script.getLocation())) {
                        ((ScriptContributionItem)item).setLabel(script.getParameters().get(KEYWORD_NAME));
                        ((ScriptContributionItem)item).setIcon(LocationImageDescriptor.createFromLocation((String)ResourceTools.toAbsoluteLocation((Object)script.getParameters().get(KEYWORD_IMAGE), (Object)script.getLocation())));
                    }
                    ++n2;
                }
                view.getViewSite().getActionBars().updateActionBars();
            }
        }
    }

    private void addViewContribution(LocationDescription location, IScript script) {
        IViewPart view;
        this.getContributionFactory(location.getId()).addScript(script);
        if (location.fViewID != null && (view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(location.fViewID)) instanceof ViewPart && view.getViewSite() != null) {
            if (location.fScheme.equals(KEYWORD_TOOLBAR)) {
                this.getContributionFactory(location.getId()).setAffectedContribution((IContributionManager)view.getViewSite().getActionBars().getToolBarManager());
                view.getViewSite().getActionBars().getToolBarManager().add((IContributionItem)new ScriptContributionItem(script));
            } else if (location.fScheme.equals(KEYWORD_MENU)) {
                this.getContributionFactory(location.getId()).setAffectedContribution((IContributionManager)view.getViewSite().getActionBars().getMenuManager());
                view.getViewSite().getActionBars().getMenuManager().add((IContributionItem)new ScriptContributionItem(script));
            }
            view.getViewSite().getActionBars().updateActionBars();
        }
    }

    private void removeViewContribution(LocationDescription location, IScript script) {
        IViewPart view;
        this.getContributionFactory(location.getId()).removeScript(script);
        if (location.fViewID != null && (view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(location.fViewID)) instanceof ViewPart && view.getViewSite() != null) {
            if (location.fScheme.equals(KEYWORD_TOOLBAR)) {
                view.getViewSite().getActionBars().getToolBarManager().remove(script.getLocation());
            } else if (location.fScheme.equals(KEYWORD_MENU)) {
                view.getViewSite().getActionBars().getMenuManager().remove(script.getLocation());
            }
            view.getViewSite().getActionBars().updateActionBars();
        }
    }

    private ScriptContributionFactory getContributionFactory(String location) {
        if (!this.fContributionFactories.containsKey(location)) {
            this.fContributionFactories.put(location, new ScriptContributionFactory(location, null));
        }
        return this.fContributionFactories.get(location);
    }

    @Override
    public synchronized void notify(ScriptEvent event) {
        Map<String, String> parameters = event.getScript().getParameters();
        if (parameters.containsKey(KEYWORD_MENU) || parameters.containsKey(KEYWORD_TOOLBAR) || parameters.containsKey(KEYWORD_POPUP) || event.getType() == 2) {
            switch (event.getType()) {
                case 1: {
                    this.fAddedScripts.add(event.getScript());
                    this.reschedule(300L);
                    break;
                }
                case 4: {
                    this.fRemovedScripts.add(event.getScript());
                    this.reschedule(300L);
                    break;
                }
                case 2: {
                    ParameterDelta delta = (ParameterDelta)event.getEventData();
                    if (!delta.isAffected(KEYWORD_TOOLBAR) && !delta.isAffected(KEYWORD_MENU) && !delta.isAffected(KEYWORD_POPUP) && !delta.isAffected(KEYWORD_NAME) && !delta.isAffected(KEYWORD_IMAGE)) break;
                    if (this.fChangedScripts.containsKey(event.getScript())) {
                        this.fChangedScripts.get(event.getScript()).merge(delta);
                    } else {
                        this.fChangedScripts.put(event.getScript(), delta);
                    }
                    this.reschedule(300L);
                }
            }
        }
    }

    private void reschedule(long delay) {
        if (this.getState() != 4) {
            this.cancel();
        }
        this.schedule(delay);
    }

    private class LocationDescription {
        public String fScheme;
        public String fViewID;
        public final String fName;

        public LocationDescription(String scheme, String entry) {
            this.fScheme = scheme;
            if (UIIntegrationJob.KEYWORD_POPUP.equals(this.fScheme)) {
                this.fViewID = "";
                this.fName = null;
            } else {
                IConfigurationElement[] config;
                String locationID;
                if (entry.contains("|")) {
                    this.fName = entry.substring(entry.indexOf(124) + 1).trim();
                    locationID = entry.substring(0, entry.indexOf(124)).trim();
                } else {
                    this.fName = null;
                    locationID = entry.trim();
                }
                IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.views");
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement e = iConfigurationElementArray[n2];
                    if ("view".equals(e.getName())) {
                        String id = e.getAttribute("id");
                        if (id.equals(locationID)) {
                            this.fViewID = id;
                            return;
                        }
                        String name = e.getAttribute(UIIntegrationJob.KEYWORD_NAME);
                        if (name.equals(locationID)) {
                            this.fViewID = id;
                            return;
                        }
                    }
                    ++n2;
                }
            }
        }

        public String getId() {
            return String.valueOf(this.fScheme) + ":" + (UIIntegrationJob.KEYWORD_POPUP.equals(this.fScheme) ? UIIntegrationJob.POPUP_LOCATION : this.fViewID);
        }
    }
}

