/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.modelbase.sql.schema.helper;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.helper.ISQLObjectNameHelper;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;

public class SQLObjectNameHelper
implements ISQLObjectNameHelper {
    private String fQuoteString = "\"";

    public String getNameInSQLFormat(Column column) {
        String sqlFormatName = null;
        if (column != null) {
            String quoteString = this.getIdentifierQuoteString();
            String name = column.getName();
            sqlFormatName = this.convertCatalogIdentifierToSQLFormat(name, quoteString);
        }
        return sqlFormatName;
    }

    public String getNameInSQLFormat(Table table) {
        String sqlFormatName = null;
        if (table != null) {
            String quoteString = this.getIdentifierQuoteString();
            String name = table.getName();
            sqlFormatName = this.convertCatalogIdentifierToSQLFormat(name, quoteString);
        }
        return sqlFormatName;
    }

    public String getQualifiedNameInSQLFormat(Column column) {
        String qualifiedSQLName = null;
        if (column != null) {
            String sqlFormatName;
            String quoteString = this.getIdentifierQuoteString();
            String name = column.getName();
            qualifiedSQLName = sqlFormatName = this.convertCatalogIdentifierToSQLFormat(name, quoteString);
            String tableName = null;
            Table table = column.getTable();
            if (table != null) {
                tableName = table.getName();
                String sqlFormatTableName = this.convertCatalogIdentifierToSQLFormat(tableName, quoteString);
                qualifiedSQLName = String.valueOf(sqlFormatTableName) + "." + sqlFormatName;
            }
        }
        return qualifiedSQLName;
    }

    public String getQualifiedNameInSQLFormat(Table table) {
        String qualifiedSQLName = null;
        if (table != null) {
            String sqlFormatTableName;
            String quoteString = this.getIdentifierQuoteString();
            String tableName = table.getName();
            qualifiedSQLName = sqlFormatTableName = this.convertCatalogIdentifierToSQLFormat(tableName, quoteString);
            String schemaName = null;
            Schema schema = table.getSchema();
            if (schema != null) {
                schemaName = schema.getName();
                String sqlFormatSchemaName = this.convertCatalogIdentifierToSQLFormat(schemaName, quoteString);
                qualifiedSQLName = String.valueOf(sqlFormatSchemaName) + "." + sqlFormatTableName;
            }
        }
        return qualifiedSQLName;
    }

    public String getIdentifierQuoteString() {
        return this.fQuoteString;
    }

    public void setIdentifierQuoteString(String quoteString) {
        this.fQuoteString = quoteString;
    }

    protected String convertCatalogIdentifierToSQLFormat(String catIdentifier, String quoteString) {
        String sqlIdentifier = catIdentifier;
        if (catIdentifier != null && quoteString != null && quoteString.length() > 0 && !quoteString.equals(" ")) {
            boolean containsDelimiters = catIdentifier.indexOf(quoteString) > -1;
            boolean containsSpace = catIdentifier.indexOf(32) > -1;
            boolean containsDot = catIdentifier.indexOf(46) > -1;
            boolean isLowerOrMixedCase = !catIdentifier.toUpperCase().equals(catIdentifier);
            boolean allDigits = false;
            try {
                Integer.parseInt(catIdentifier);
                allDigits = true;
            }
            catch (NumberFormatException numberFormatException) {}
            boolean containsNonAlpha = false;
            String nonAlphaRegex = "[\\W&&[^$#@]]";
            Pattern patern = Pattern.compile(nonAlphaRegex);
            Matcher matcher = patern.matcher(catIdentifier);
            while (!containsNonAlpha && matcher.find()) {
                containsNonAlpha = true;
            }
            if (containsDelimiters || containsSpace || containsDot || containsNonAlpha || isLowerOrMixedCase || allDigits) {
                if (containsDelimiters) {
                    if (!sqlIdentifier.startsWith(quoteString) || !sqlIdentifier.endsWith(quoteString)) {
                        if (quoteString.length() == 1) {
                            char quoteChar = quoteString.charAt(0);
                            StringBuffer sqlIdentSB = new StringBuffer(sqlIdentifier);
                            int i = 0;
                            while (i < sqlIdentSB.length()) {
                                if (sqlIdentSB.charAt(i) == quoteChar) {
                                    sqlIdentSB.insert(i, quoteChar);
                                    ++i;
                                }
                                ++i;
                            }
                            sqlIdentifier = sqlIdentSB.toString();
                        }
                        sqlIdentifier = String.valueOf(quoteString) + sqlIdentifier + quoteString;
                    }
                } else {
                    sqlIdentifier = String.valueOf(quoteString) + sqlIdentifier + quoteString;
                }
            }
        }
        return sqlIdentifier;
    }

    protected Database getDatabase(Schema schema) {
        Database database = null;
        if (schema != null) {
            database = schema.getCatalog() == null ? schema.getDatabase() : schema.getCatalog().getDatabase();
        }
        return database;
    }
}

