/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.behavior.component.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.ActionList;
import org.eclipse.comma.actions.actions.ActionWithVars;
import org.eclipse.comma.actions.actions.ActionsPackage;
import org.eclipse.comma.actions.actions.AssignmentAction;
import org.eclipse.comma.actions.actions.EVENT_KIND;
import org.eclipse.comma.actions.actions.EventPattern;
import org.eclipse.comma.actions.actions.IfAction;
import org.eclipse.comma.actions.actions.RecordFieldAssignmentAction;
import org.eclipse.comma.actions.actions.Reply;
import org.eclipse.comma.actions.actions.VariableDeclBlock;
import org.eclipse.comma.behavior.behavior.BehaviorPackage;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.ProvidedPort;
import org.eclipse.comma.behavior.behavior.RequiredPort;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.component.component.AnyEvent;
import org.eclipse.comma.behavior.component.component.CommandEvent;
import org.eclipse.comma.behavior.component.component.CommandReply;
import org.eclipse.comma.behavior.component.component.CommandReplyWithVars;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.component.ComponentModel;
import org.eclipse.comma.behavior.component.component.ComponentPackage;
import org.eclipse.comma.behavior.component.component.ComponentPart;
import org.eclipse.comma.behavior.component.component.Connection;
import org.eclipse.comma.behavior.component.component.ConnectionValue;
import org.eclipse.comma.behavior.component.component.ConnectionVariable;
import org.eclipse.comma.behavior.component.component.EventCall;
import org.eclipse.comma.behavior.component.component.EventWithVars;
import org.eclipse.comma.behavior.component.component.ExpressionConnectionState;
import org.eclipse.comma.behavior.component.component.ExpressionInterfaceState;
import org.eclipse.comma.behavior.component.component.FunctionalConstraint;
import org.eclipse.comma.behavior.component.component.FunctionalConstraintsBlock;
import org.eclipse.comma.behavior.component.component.PortReference;
import org.eclipse.comma.behavior.component.component.PortSelector;
import org.eclipse.comma.behavior.component.component.PredicateFunctionalConstraint;
import org.eclipse.comma.behavior.component.component.StateBasedFunctionalConstraint;
import org.eclipse.comma.behavior.component.component.TriggeredTransition;
import org.eclipse.comma.behavior.component.utilities.ComponentUtilities;
import org.eclipse.comma.behavior.component.validation.AbstractComponentValidator;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.InterfaceDefinition;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.InterfaceDefinitionPackage;
import org.eclipse.comma.behavior.scoping.BehaviorScopeProvider;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signal;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.types.FileImport;
import org.eclipse.comma.types.types.NamespaceImport;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeObject;
import org.eclipse.comma.types.types.TypesPackage;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ComponentValidator
extends AbstractComponentValidator {
    @Check
    public void checkImportForValidity(FileImport imp) {
        boolean _not;
        boolean _isValidUri = EcoreUtil2.isValidUri((EObject)imp, (URI)URI.createURI((String)imp.getImportURI()));
        boolean bl = _not = !_isValidUri;
        if (_not) {
            this.error("Invalid resource", (EObject)imp, (EStructuralFeature)TypesPackage.eINSTANCE.getFileImport_ImportURI());
        } else {
            Resource r = EcoreUtil2.getResource((Resource)imp.eResource(), (String)imp.getImportURI());
            if (!(IteratorExtensions.head((Iterator)r.getAllContents()) instanceof InterfaceDefinition) && !(IteratorExtensions.head((Iterator)r.getAllContents()) instanceof ComponentModel)) {
                this.error("The imported resource has to be interface or component model.", (EObject)imp, (EStructuralFeature)TypesPackage.eINSTANCE.getFileImport_ImportURI());
            }
        }
    }

    @Check
    public void checkConnectionPortsInterfaces(Connection c) {
        Signature _interface_1;
        boolean _tripleNotEquals;
        if (c.getFirstEnd().getPort() == null || c.getSecondEnd().getPort() == null) {
            return;
        }
        Signature _interface = c.getFirstEnd().getPort().getInterface();
        boolean bl = _tripleNotEquals = _interface != (_interface_1 = c.getSecondEnd().getPort().getInterface());
        if (_tripleNotEquals) {
            this.error("A connection can not connect ports of different interfaces.", c, (EStructuralFeature)ComponentPackage.Literals.CONNECTION__FIRST_END);
        }
    }

    @Check
    public void checkConnectionDistinctEnds(Connection c) {
        ComponentPart _part_1;
        boolean _tripleEquals;
        ComponentPart _part = c.getFirstEnd().getPart();
        boolean bl = _tripleEquals = _part == (_part_1 = c.getSecondEnd().getPart());
        if (_tripleEquals) {
            this.error("A connection can not connect ports from the same component instance", c, (EStructuralFeature)ComponentPackage.Literals.CONNECTION__FIRST_END);
        }
    }

    @Check
    public void checkConnectionPortDirections(Connection c) {
        if (c.getFirstEnd().getPort() == null || c.getSecondEnd().getPort() == null) {
            return;
        }
        if (c.getFirstEnd().getPart() == null || c.getSecondEnd().getPart() == null) {
            boolean _tripleNotEquals;
            Port _port = c.getFirstEnd().getPort();
            Port _port_1 = c.getSecondEnd().getPort();
            boolean bl = _tripleNotEquals = Boolean.valueOf(_port instanceof ProvidedPort) != Boolean.valueOf(_port_1 instanceof ProvidedPort);
            if (_tripleNotEquals) {
                this.error("Ports must be of the same direction", c.getFirstEnd(), (EStructuralFeature)ComponentPackage.Literals.PORT_REFERENCE__PORT);
                this.error("Ports must be of the same direction", c.getSecondEnd(), (EStructuralFeature)ComponentPackage.Literals.PORT_REFERENCE__PORT);
            }
        } else {
            Port _port_3;
            boolean _equals;
            Port _port_2 = c.getFirstEnd().getPort();
            boolean bl = _equals = _port_2 instanceof ProvidedPort == (_port_3 = c.getSecondEnd().getPort()) instanceof ProvidedPort;
            if (_equals) {
                this.error("Ports must be of different direction", c.getFirstEnd(), (EStructuralFeature)ComponentPackage.Literals.PORT_REFERENCE__PORT);
                this.error("Ports must be of different direction", c.getSecondEnd(), (EStructuralFeature)ComponentPackage.Literals.PORT_REFERENCE__PORT);
            }
        }
    }

    @Check
    public void checkDistinctConnections(Component c) {
        EList<Connection> _connections = c.getConnections();
        for (Connection conn1 : _connections) {
            EList<Connection> _connections_1 = c.getConnections();
            for (Connection conn2 : _connections_1) {
                if (conn1 == conn2 || !ComponentUtilities.sameEnds(conn1, conn2)) continue;
                this.error("There is another connection with the same ends", (EObject)c, (EStructuralFeature)ComponentPackage.Literals.COMPONENT__CONNECTIONS, c.getConnections().indexOf((Object)conn2));
            }
        }
    }

    @Check
    public void checkBoundaryPortsConnections(Component c) {
        EList _ports = c.getPorts();
        for (Port p : _ports) {
            boolean _greaterThan;
            int _size = ComponentUtilities.getConnectionsForEnd(c, null, p).size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            this.error("Boundary port may have at most one connection", (EObject)p, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check
    public void checkPartPortsConnections(Component c) {
        EList<ComponentPart> _parts = c.getParts();
        for (ComponentPart part : _parts) {
            EList _ports = part.getComponentType().getPorts();
            for (Port port : _ports) {
                List<Connection> connections = ComponentUtilities.getConnectionsForEnd(c, part, port);
                if (port instanceof RequiredPort && connections.size() > 1) {
                    String _name = part.getName();
                    String _plus = "Required part port " + _name;
                    String _plus_1 = String.valueOf(_plus) + "::";
                    String _name_1 = port.getName();
                    String _plus_2 = String.valueOf(_plus_1) + _name_1;
                    String _plus_3 = String.valueOf(_plus_2) + " can be connected at most once";
                    this.error(_plus_3, (EObject)c, (EStructuralFeature)ComponentPackage.Literals.COMPONENT__CONNECTIONS, c.getConnections().indexOf((Object)connections.get(0)));
                }
                if (!(port instanceof ProvidedPort) || connections.size() <= 1) continue;
                for (Connection conn : connections) {
                    PortReference otherEnd = ComponentUtilities.otherEnd(conn, part, port);
                    if (otherEnd.getPart() != null && !(otherEnd.getPort() instanceof ProvidedPort)) continue;
                    String _name_2 = part.getName();
                    String _plus_4 = "Provided part port " + _name_2;
                    String _plus_5 = String.valueOf(_plus_4) + "::";
                    String _name_3 = port.getName();
                    String _plus_6 = String.valueOf(_plus_5) + _name_3;
                    String _plus_7 = String.valueOf(_plus_6) + " can be connected to a single boundary port or to required part ports";
                    this.error(_plus_7, (EObject)c, (EStructuralFeature)ComponentPackage.Literals.COMPONENT__CONNECTIONS, c.getConnections().indexOf((Object)conn));
                }
            }
        }
    }

    @Check
    public void checkDuplicatedPortNames(Component c) {
        this.checkForNameDuplications((Iterable)c.getPorts(), "port", null, new String[]{"port"});
    }

    @Check
    public void checkDuplicatedPartNames(Component c) {
        this.checkForNameDuplications((Iterable)c.getParts(), "part", null, new String[]{"part"});
    }

    @Check
    public void checkDuplicatedFuncConstraintNames(FunctionalConstraintsBlock fcb) {
        this.checkForNameDuplications((Iterable)fcb.getFunctionalConstraints(), "constraint", null, new String[]{"constraint"});
    }

    @Check
    public void checkDuplicatedStateNamesFunctionalConstraint(StateBasedFunctionalConstraint fc) {
        this.checkForNameDuplications((Iterable)fc.getStates(), "state", null, new String[]{"state"});
    }

    @Check
    public void checkInitialState(StateBasedFunctionalConstraint fc) {
        boolean _equals;
        boolean _greaterThan;
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State s) {
                return s.isInitial();
            }
        };
        Iterable initialStates = IterableExtensions.filter(fc.getStates(), (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)initialStates);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            this.error("More than one initial state", (EObject)fc, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
            return;
        }
        int _size_1 = IterableExtensions.size((Iterable)initialStates);
        boolean bl2 = _equals = _size_1 == 0;
        if (_equals) {
            this.error("Missing initial state", (EObject)fc, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check
    public void checkUsedEventsList(StateBasedFunctionalConstraint fc) {
        EList<EventPattern> _usedEvents = fc.getUsedEvents();
        for (EventPattern ev1 : _usedEvents) {
            EList<EventPattern> _usedEvents_1 = fc.getUsedEvents();
            for (EventPattern ev2 : _usedEvents_1) {
                boolean _isSubsumedBy;
                boolean _notEquals;
                boolean bl = _notEquals = !Objects.equal((Object)ev1, (Object)ev2);
                if (!_notEquals || !(_isSubsumedBy = ComponentUtilities.isSubsumedBy(ev1, ev2))) continue;
                this.warning("The event is duplicated or subsumed by another event", (EObject)fc, (EStructuralFeature)ComponentPackage.Literals.STATE_BASED_FUNCTIONAL_CONSTRAINT__USED_EVENTS, fc.getUsedEvents().indexOf((Object)ev1));
            }
        }
    }

    @Check
    public void checkCommandReplyPairs(StateBasedFunctionalConstraint fc) {
        EList<EventPattern> _usedEvents = fc.getUsedEvents();
        for (final EventPattern ev : _usedEvents) {
            EVENT_KIND _kind;
            boolean _equals;
            if (ev instanceof CommandEvent) {
                Functions.Function1<EventPattern, Boolean> _function = new Functions.Function1<EventPattern, Boolean>(){

                    public Boolean apply(EventPattern e) {
                        return ComponentValidator.this.matchForCommand((CommandEvent)ev, e);
                    }
                };
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter(fc.getUsedEvents(), (Functions.Function1)_function));
                if (_isEmpty) {
                    this.error("The command is missing a matching reply", (EObject)fc, (EStructuralFeature)ComponentPackage.Literals.STATE_BASED_FUNCTIONAL_CONSTRAINT__USED_EVENTS, fc.getUsedEvents().indexOf((Object)ev));
                }
            }
            if (ev instanceof CommandReply) {
                Functions.Function1<EventPattern, Boolean> _function_1 = new Functions.Function1<EventPattern, Boolean>(){

                    public Boolean apply(EventPattern e) {
                        return ComponentValidator.this.matchForReply((CommandReply)ev, e);
                    }
                };
                boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter(fc.getUsedEvents(), (Functions.Function1)_function_1));
                if (_isEmpty_1) {
                    this.error("The reply is missing a matching command", (EObject)fc, (EStructuralFeature)ComponentPackage.Literals.STATE_BASED_FUNCTIONAL_CONSTRAINT__USED_EVENTS, fc.getUsedEvents().indexOf((Object)ev));
                }
            }
            if (!(ev instanceof AnyEvent) || !(_equals = Objects.equal((Object)(_kind = ((AnyEvent)ev).getKind()), (Object)EVENT_KIND.CALL))) continue;
            Functions.Function1<EventPattern, Boolean> _function_2 = new Functions.Function1<EventPattern, Boolean>(){

                public Boolean apply(EventPattern e) {
                    return ComponentValidator.this.matchForCommand((AnyEvent)ev, e);
                }
            };
            boolean _isEmpty_2 = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter(fc.getUsedEvents(), (Functions.Function1)_function_2));
            if (!_isEmpty_2) continue;
            this.error("The any command pattern is missing a matching reply pattern", (EObject)fc, (EStructuralFeature)ComponentPackage.Literals.STATE_BASED_FUNCTIONAL_CONSTRAINT__USED_EVENTS, fc.getUsedEvents().indexOf((Object)ev));
        }
    }

    public boolean matchForReply(CommandReply r, EventPattern ev) {
        boolean _xblockexpression = false;
        if (ev instanceof CommandEvent) {
            boolean _and = false;
            if (r.getPart() != ((CommandEvent)ev).getPart() || r.getPort() != ((CommandEvent)ev).getPort()) {
                _and = false;
            } else {
                InterfaceEvent _event_1;
                boolean _tripleEquals;
                org.eclipse.comma.actions.actions.CommandEvent _command = r.getCommand();
                InterfaceEvent _event = null;
                if (_command != null) {
                    _event = _command.getEvent();
                }
                _and = _tripleEquals = _event == (_event_1 = ((CommandEvent)ev).getEvent());
            }
            return _and;
        }
        if (ev instanceof AnyEvent) {
            return ((AnyEvent)ev).getKind() == EVENT_KIND.CALL && r.getPart() == ((AnyEvent)ev).getPart() && r.getPort() == ((AnyEvent)ev).getPort();
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    public boolean matchForCommand(CommandEvent c, EventPattern ev) {
        boolean _xblockexpression = false;
        if (ev instanceof CommandReply) {
            boolean _and = false;
            if (c.getPart() != ((CommandReply)ev).getPart() || c.getPort() != ((CommandReply)ev).getPort()) {
                _and = false;
            } else {
                org.eclipse.comma.actions.actions.CommandEvent _command_1;
                boolean _tripleEquals_1;
                boolean _tripleEquals;
                boolean _or = false;
                InterfaceEvent _event = c.getEvent();
                org.eclipse.comma.actions.actions.CommandEvent _command = ((CommandReply)ev).getCommand();
                InterfaceEvent _event_1 = null;
                if (_command != null) {
                    _event_1 = _command.getEvent();
                }
                boolean bl = _tripleEquals = _event == _event_1;
                _or = _tripleEquals ? true : (_tripleEquals_1 = (_command_1 = ((CommandReply)ev).getCommand()) == null);
                _and = _or;
            }
            return _and;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    public boolean matchForCommand(AnyEvent c, EventPattern ev) {
        boolean _xblockexpression = false;
        if (ev instanceof CommandReply) {
            return c.getPart() == ((CommandReply)ev).getPart() && c.getPort() == ((CommandReply)ev).getPort() && ((CommandReply)ev).getCommand() == null;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    @Check
    public void checkTriggeredTransition(TriggeredTransition t) {
        InterfaceEvent _trigger;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        Variable _idVarDef = t.getIdVarDef();
        boolean bl = _tripleNotEquals = _idVarDef != null;
        if (_tripleNotEquals) {
            boolean _not;
            boolean _subTypeOf = this.subTypeOf(TypeUtilities.getTypeObject((Type)t.getIdVarDef().getType()), (TypeObject)this.idType);
            boolean bl2 = _not = !_subTypeOf;
            if (_not) {
                this.error("Variable has to be of type id", (EStructuralFeature)ComponentPackage.Literals.CONNECTION_VARIABLE__ID_VAR_DEF);
            }
        }
        boolean bl3 = _tripleNotEquals_1 = (_trigger = t.getTrigger()) != null;
        if (_tripleNotEquals_1) {
            boolean _not_1;
            boolean isCall;
            boolean bl4 = isCall = t.getTrigger() instanceof Command || t.getTrigger() instanceof Signal;
            if (isCall && t.getPort() instanceof RequiredPort) {
                String _name = t.getPort().getName();
                String _plus = "Trigger has to be notification or reply to the required port " + _name;
                this.error(_plus, (EStructuralFeature)BehaviorPackage.Literals.TRIGGERED_TRANSITION__TRIGGER);
                return;
            }
            if (!isCall && t.getPort() instanceof ProvidedPort) {
                String _name_1 = t.getPort().getName();
                String _plus_1 = "Trigger has to be command or signal to the provided port " + _name_1;
                this.error(_plus_1, (EStructuralFeature)BehaviorPackage.Literals.TRIGGERED_TRANSITION__TRIGGER);
                return;
            }
            InterfaceEvent _trigger_1 = t.getTrigger();
            ArrayList<Expression> _arrayList = new ArrayList<Expression>();
            final EventPattern evPattern = ComponentUtilities.makeEvent(_trigger_1, null, t, _arrayList);
            EObject _eContainer = t.eContainer().eContainer();
            Functions.Function1<EventPattern, Boolean> _function = new Functions.Function1<EventPattern, Boolean>(){

                public Boolean apply(EventPattern e) {
                    return ComponentUtilities.isSubsumedBy(evPattern, e);
                }
            };
            boolean _exists = IterableExtensions.exists(((StateBasedFunctionalConstraint)_eContainer).getUsedEvents(), (Functions.Function1)_function);
            boolean bl5 = _not_1 = !_exists;
            if (_not_1) {
                this.error("Event is not declared in used events list", (EStructuralFeature)BehaviorPackage.Literals.TRIGGERED_TRANSITION__TRIGGER);
            }
        } else {
            Port _port = t.getPort();
            if (_port instanceof ProvidedPort) {
                this.error("Reply can be a trigger only for commands on required ports", (EStructuralFeature)ComponentPackage.Literals.TRIGGERED_TRANSITION__REPLY_TO);
            } else {
                int _size_1;
                int _size;
                boolean _notEquals;
                boolean _not_3;
                boolean _not_2;
                Command _replyTo = t.getReplyTo();
                ArrayList<Expression> _arrayList_1 = new ArrayList<Expression>();
                final EventPattern evPattern_1 = ComponentUtilities.makeEvent(null, _replyTo, t, _arrayList_1);
                EObject _eContainer_1 = t.eContainer().eContainer();
                Functions.Function1<EventPattern, Boolean> _function_1 = new Functions.Function1<EventPattern, Boolean>(){

                    public Boolean apply(EventPattern e) {
                        return ComponentUtilities.isSubsumedBy(evPattern_1, e);
                    }
                };
                boolean _exists_1 = IterableExtensions.exists(((StateBasedFunctionalConstraint)_eContainer_1).getUsedEvents(), (Functions.Function1)_function_1);
                boolean bl6 = _not_2 = !_exists_1;
                if (_not_2) {
                    this.error("Reply is not declared in used events list", (EStructuralFeature)ComponentPackage.Literals.TRIGGERED_TRANSITION__REPLY_TO);
                    return;
                }
                ArrayList<TypeObject> expectedTypes = new ArrayList<TypeObject>();
                Functions.Function1<Parameter, Boolean> _function_2 = new Functions.Function1<Parameter, Boolean>(){

                    public Boolean apply(Parameter p) {
                        DIRECTION _direction = p.getDirection();
                        return !Objects.equal((Object)_direction, (Object)DIRECTION.IN);
                    }
                };
                Functions.Function1<Parameter, TypeObject> _function_3 = new Functions.Function1<Parameter, TypeObject>(){

                    public TypeObject apply(Parameter it) {
                        return TypeUtilities.getTypeObject((Type)it.getType());
                    }
                };
                Iterables.addAll(expectedTypes, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)t.getReplyTo().getParameters(), (Functions.Function1)_function_2), (Functions.Function1)_function_3));
                boolean _isVoid = TypeUtilities.isVoid((Type)t.getReplyTo().getType());
                boolean bl7 = _not_3 = !_isVoid;
                if (_not_3) {
                    expectedTypes.add(TypeUtilities.getTypeObject((Type)t.getReplyTo().getType()));
                }
                boolean bl8 = _notEquals = (_size = expectedTypes.size()) != (_size_1 = t.getParameters().size());
                if (_notEquals) {
                    this.error("Wrong number of parameters in reply", (EStructuralFeature)BehaviorPackage.Literals.TRIGGERED_TRANSITION__PARAMETERS);
                    return;
                }
                int _size_2 = expectedTypes.size();
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size_2, true);
                for (Integer i : _doubleDotLessThan) {
                    boolean _not_4;
                    boolean _subTypeOf_1 = this.subTypeOf(TypeUtilities.getTypeObject((Type)((Variable)t.getParameters().get(i.intValue())).getType()), (TypeObject)expectedTypes.get(i));
                    boolean bl9 = _not_4 = !_subTypeOf_1;
                    if (!_not_4) continue;
                    this.error("The type of the variable must be the same as the return type of the command or inout/out parameter type.", t, (EStructuralFeature)BehaviorPackage.Literals.TRIGGERED_TRANSITION__PARAMETERS, i);
                }
            }
        }
    }

    @Check
    public void checkUsedEvent(StateBasedFunctionalConstraint fc) {
        ArrayList<EventPattern> eventPatterns = new ArrayList<EventPattern>();
        List _allContentsOfType = EcoreUtil2.getAllContentsOfType((EObject)fc, EventCall.class);
        for (EventCall ec : _allContentsOfType) {
            InterfaceEvent _event = ec.getEvent();
            ArrayList<Expression> _arrayList = new ArrayList<Expression>();
            eventPatterns.add(ComponentUtilities.makeEvent(_event, null, ec, _arrayList));
        }
        List _allContentsOfType_1 = EcoreUtil2.getAllContentsOfType((EObject)fc, EventWithVars.class);
        for (EventWithVars ec_1 : _allContentsOfType_1) {
            Iterator _event_1 = ec_1.getEvent();
            ArrayList<Expression> _arrayList_1 = new ArrayList<Expression>();
            eventPatterns.add(ComponentUtilities.makeEvent((InterfaceEvent)_event_1, null, ec_1, _arrayList_1));
        }
        EList<State> _states = fc.getStates();
        for (State state : _states) {
            List _allContentsOfType_2 = EcoreUtil2.getAllContentsOfType((EObject)state, Reply.class);
            Iterator iterator = _allContentsOfType_2.iterator();
            while (iterator.hasNext()) {
                boolean _tripleNotEquals;
                Reply ec_2 = (Reply)iterator.next();
                Command command = null;
                org.eclipse.comma.actions.actions.CommandEvent _command = ec_2.getCommand();
                boolean bl = _tripleNotEquals = _command != null;
                if (_tripleNotEquals) {
                    InterfaceEvent _event_2 = ec_2.getCommand().getEvent();
                    command = (Command)_event_2;
                } else {
                    boolean _tripleNotEquals_1;
                    TriggeredTransition t = (TriggeredTransition)EcoreUtil2.getContainerOfType((EObject)ec_2, TriggeredTransition.class);
                    boolean _and = false;
                    InterfaceEvent _trigger = null;
                    if (t != null) {
                        _trigger = t.getTrigger();
                    }
                    boolean bl2 = _tripleNotEquals_1 = _trigger != null;
                    if (!_tripleNotEquals_1) {
                        _and = false;
                    } else {
                        InterfaceEvent _trigger_1 = t.getTrigger();
                        _and = _trigger_1 instanceof Command;
                    }
                    if (_and) {
                        InterfaceEvent _trigger_2 = t.getTrigger();
                        command = (Command)_trigger_2;
                    }
                }
                if (command == null) continue;
                ArrayList<Expression> _arrayList_2 = new ArrayList<Expression>();
                eventPatterns.add(ComponentUtilities.makeEvent(null, command, (PortSelector)ec_2, _arrayList_2));
            }
        }
        List _allContentsOfType_3 = EcoreUtil2.getAllContentsOfType((EObject)fc, TriggeredTransition.class);
        for (TriggeredTransition t : _allContentsOfType_3) {
            boolean _tripleEquals;
            InterfaceEvent _trigger = t.getTrigger();
            boolean bl = _tripleEquals = _trigger == null;
            if (_tripleEquals) {
                InterfaceEvent _trigger_1 = t.getTrigger();
                Command _replyTo = t.getReplyTo();
                ArrayList<Expression> _arrayList_2 = new ArrayList<Expression>();
                eventPatterns.add(ComponentUtilities.makeEvent(_trigger_1, _replyTo, t, _arrayList_2));
                continue;
            }
            InterfaceEvent _trigger_2 = t.getTrigger();
            ArrayList<Expression> _arrayList_3 = new ArrayList<Expression>();
            eventPatterns.add(ComponentUtilities.makeEvent(_trigger_2, null, t, _arrayList_3));
        }
        EList<EventPattern> _usedEvents = fc.getUsedEvents();
        for (final EventPattern e : _usedEvents) {
            boolean _not;
            Functions.Function1<EventPattern, Boolean> _function = new Functions.Function1<EventPattern, Boolean>(){

                public Boolean apply(EventPattern evPattern) {
                    return ComponentUtilities.isSubsumedBy(evPattern, e);
                }
            };
            boolean _exists = IterableExtensions.exists(eventPatterns, (Functions.Function1)_function);
            boolean bl = _not = !_exists;
            if (!_not) continue;
            String _name = fc.getName();
            String _plus = "Event is not mentioned in the constraint " + _name;
            this.error(_plus, (EObject)fc, (EStructuralFeature)ComponentPackage.Literals.STATE_BASED_FUNCTIONAL_CONSTRAINT__USED_EVENTS, fc.getUsedEvents().indexOf((Object)e));
        }
    }

    @Check
    public void checkEventReceptions(StateBasedFunctionalConstraint fc) {
        List _allContentsOfType = EcoreUtil2.getAllContentsOfType((EObject)fc, EventCall.class);
        for (EventCall ec : _allContentsOfType) {
            boolean _not;
            InterfaceEvent _event = ec.getEvent();
            ArrayList<Expression> _arrayList = new ArrayList<Expression>();
            final EventPattern evPattern = ComponentUtilities.makeEvent(_event, null, ec, _arrayList);
            Functions.Function1<EventPattern, Boolean> _function = new Functions.Function1<EventPattern, Boolean>(){

                public Boolean apply(EventPattern e) {
                    return ComponentUtilities.isSubsumedBy(evPattern, e);
                }
            };
            boolean _exists = IterableExtensions.exists(fc.getUsedEvents(), (Functions.Function1)_function);
            boolean bl = _not = !_exists;
            if (!_not) continue;
            this.error("Event is not declared in used events list", ec, (EStructuralFeature)ActionsPackage.Literals.INTERFACE_EVENT_INSTANCE__EVENT);
        }
        List _allContentsOfType_1 = EcoreUtil2.getAllContentsOfType((EObject)fc, EventWithVars.class);
        for (EventWithVars ec_1 : _allContentsOfType_1) {
            boolean _not;
            InterfaceEvent _event = ec_1.getEvent();
            ArrayList<Expression> _arrayList = new ArrayList<Expression>();
            final EventPattern evPattern = ComponentUtilities.makeEvent(_event, null, ec_1, _arrayList);
            Functions.Function1<EventPattern, Boolean> _function = new Functions.Function1<EventPattern, Boolean>(){

                public Boolean apply(EventPattern e) {
                    return ComponentUtilities.isSubsumedBy(evPattern, e);
                }
            };
            boolean _exists = IterableExtensions.exists(fc.getUsedEvents(), (Functions.Function1)_function);
            boolean bl = _not = !_exists;
            if (!_not) continue;
            this.error("Event is not declared in used events list", ec_1, (EStructuralFeature)ActionsPackage.Literals.EVENT_WITH_VARS__EVENT);
        }
        List _allContentsOfType_2 = EcoreUtil2.getAllContentsOfType((EObject)fc, Reply.class);
        for (Reply ec_2 : _allContentsOfType_2) {
            boolean _not;
            boolean _tripleNotEquals;
            Command command = null;
            org.eclipse.comma.actions.actions.CommandEvent _command = ec_2.getCommand();
            boolean bl = _tripleNotEquals = _command != null;
            if (_tripleNotEquals) {
                InterfaceEvent _event = ec_2.getCommand().getEvent();
                command = (Command)_event;
            } else {
                boolean _tripleNotEquals_1;
                TriggeredTransition t = (TriggeredTransition)EcoreUtil2.getContainerOfType((EObject)ec_2, TriggeredTransition.class);
                boolean _and = false;
                InterfaceEvent _trigger = null;
                if (t != null) {
                    _trigger = t.getTrigger();
                }
                boolean bl2 = _tripleNotEquals_1 = _trigger != null;
                if (!_tripleNotEquals_1) {
                    _and = false;
                } else {
                    InterfaceEvent _trigger_1 = t.getTrigger();
                    _and = _trigger_1 instanceof Command;
                }
                if (_and) {
                    InterfaceEvent _trigger_2 = t.getTrigger();
                    command = (Command)_trigger_2;
                }
            }
            if (command == null) continue;
            ArrayList<Expression> _arrayList = new ArrayList<Expression>();
            final EventPattern evPattern = ComponentUtilities.makeEvent(null, command, (PortSelector)ec_2, _arrayList);
            Functions.Function1<EventPattern, Boolean> _function = new Functions.Function1<EventPattern, Boolean>(){

                public Boolean apply(EventPattern e) {
                    return ComponentUtilities.isSubsumedBy(evPattern, e);
                }
            };
            boolean _exists = IterableExtensions.exists(fc.getUsedEvents(), (Functions.Function1)_function);
            boolean bl3 = _not = !_exists;
            if (_not) {
                this.error("Reply to this command is not declared in used events list", (EObject)ec_2, (EStructuralFeature)ActionsPackage.Literals.REPLY__COMMAND);
                continue;
            }
            if (!(ec_2 instanceof CommandReply) || EcoreUtil2.getContainerOfType((EObject)ec_2, Transition.class) == null) continue;
            this.checkReplyAgainstCommand(command, ec_2);
        }
    }

    @Check
    public void checkUnusedVarsFunctionalConstraint(final FunctionalConstraint fc) {
        ArrayList variables = new ArrayList();
        variables.addAll(fc.getVars());
        Functions.Function1<ExpressionVariable, Variable> _function = new Functions.Function1<ExpressionVariable, Variable>(){

            public Variable apply(ExpressionVariable it) {
                return it.getVariable();
            }
        };
        variables.removeAll(ListExtensions.map((List)EcoreUtil2.getAllContentsOfType((EObject)fc, ExpressionVariable.class), (Functions.Function1)_function));
        Consumer<Variable> _function_1 = new Consumer<Variable>(){

            @Override
            public void accept(Variable it) {
                ComponentValidator.this.warning("Unused variable.", (EStructuralFeature)ActionsPackage.Literals.VARIABLE_DECL_BLOCK__VARS, fc.getVars().indexOf((Object)it));
            }
        };
        variables.forEach(_function_1);
    }

    @Check
    public void checkTypingPredicateFunctionalConstraint(PredicateFunctionalConstraint fc) {
        boolean _not;
        TypeObject t = this.typeOf(fc.getExpression());
        boolean _subTypeOf = this.subTypeOf(t, (TypeObject)this.boolType);
        boolean bl = _not = !_subTypeOf;
        if (_not) {
            this.error("Type mismatch: the type of the expression must be boolean", (EStructuralFeature)ComponentPackage.Literals.PREDICATE_FUNCTIONAL_CONSTRAINT__EXPRESSION);
        }
    }

    @Check
    public void checkConnectionValue(ConnectionValue cv) {
        boolean _tripleNotEquals;
        ExpressionVariable _idVar = cv.getIdVar();
        boolean bl = _tripleNotEquals = _idVar != null;
        if (_tripleNotEquals) {
            boolean _not;
            TypeObject t = this.typeOf((Expression)cv.getIdVar());
            boolean _subTypeOf = this.subTypeOf(t, (TypeObject)this.idType);
            boolean bl2 = _not = !_subTypeOf;
            if (_not) {
                this.error("The type of the variable must be id", (EStructuralFeature)ComponentPackage.Literals.CONNECTION_VALUE__ID_VAR);
            }
        }
    }

    @Check
    public void checkConnectionVar(ConnectionVariable cv) {
        boolean _tripleNotEquals;
        Variable _idVarDef = cv.getIdVarDef();
        boolean bl = _tripleNotEquals = _idVarDef != null;
        if (_tripleNotEquals) {
            boolean _not;
            TypeObject t = TypeUtilities.getTypeObject((Type)cv.getIdVarDef().getType());
            boolean _subTypeOf = this.subTypeOf(t, (TypeObject)this.idType);
            boolean bl2 = _not = !_subTypeOf;
            if (_not) {
                this.error("The type of the variable must be id", (EStructuralFeature)ComponentPackage.Literals.CONNECTION_VARIABLE__ID_VAR_DEF);
            }
        }
    }

    @Check
    public void checkVarTypes(CommandReplyWithVars r) {
        boolean _tripleNotEquals;
        org.eclipse.comma.actions.actions.CommandEvent _command = r.getCommand();
        boolean bl = _tripleNotEquals = _command != null;
        if (_tripleNotEquals) {
            InterfaceEvent _event = r.getCommand().getEvent();
            this.checkReplyAgainstCommand((Command)_event, (Reply)r);
        } else {
            boolean _tripleNotEquals_1;
            TriggeredTransition t = (TriggeredTransition)EcoreUtil2.getContainerOfType((EObject)r, TriggeredTransition.class);
            boolean _and = false;
            InterfaceEvent _trigger = null;
            if (t != null) {
                _trigger = t.getTrigger();
            }
            boolean bl2 = _tripleNotEquals_1 = _trigger != null;
            if (!_tripleNotEquals_1) {
                _and = false;
            } else {
                InterfaceEvent _trigger_1 = t.getTrigger();
                _and = _trigger_1 instanceof Command;
            }
            if (_and) {
                InterfaceEvent _trigger_2 = t.getTrigger();
                this.checkReplyAgainstCommand((Command)_trigger_2, (Reply)r);
            }
        }
    }

    @Check
    public void checkConnectionVariableInExpr(ExpressionConnectionState expr) {
        boolean _tripleNotEquals;
        ExpressionVariable _idVar = expr.getIdVar();
        boolean bl = _tripleNotEquals = _idVar != null;
        if (_tripleNotEquals) {
            boolean _not;
            TypeObject t = this.typeOf((Expression)expr.getIdVar());
            boolean _subTypeOf = this.subTypeOf(t, (TypeObject)this.idType);
            boolean bl2 = _not = !_subTypeOf;
            if (_not) {
                this.error("The type of the variable must be id", (EStructuralFeature)ComponentPackage.Literals.EXPRESSION_CONNECTION_STATE__ID_VAR);
            }
        }
    }

    @Check
    public void checkForIdType(Type t) {
        if (t.getType() instanceof SimpleTypeDecl && t.getType().getName().equals("id") && !(t.eContainer().eContainer() instanceof VariableDeclBlock) && !(t.eContainer().eContainer() instanceof ConnectionVariable)) {
            this.error("Usage of type id is not allowed", (EStructuralFeature)TypesPackage.Literals.TYPE__TYPE);
        }
    }

    public TypeObject typeOf(Expression exp) {
        Object _xifexpression = null;
        _xifexpression = exp != null && (exp instanceof ExpressionInterfaceState || exp instanceof ExpressionConnectionState) ? this.boolType : super.typeOf(exp);
        return _xifexpression;
    }

    @Check
    public void checkDuplications(ComponentModel compDef) {
        if (compDef.getName() == null && IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)compDef.getImports(), NamespaceImport.class))) {
            return;
        }
        Multimap multiMap = this.getImportedTypes(compDef);
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            String _string = ((QualifiedName)entry.getKey()).toString();
            String _plus = "Duplicate imported type " + _string;
            this.error(_plus, (EObject)compDef.getComponent(), (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
        multiMap = this.getGlobalDeclarations((EObject)compDef, InterfaceDefinitionPackage.Literals.INTERFACE);
        Set _entrySet_1 = multiMap.asMap().entrySet();
        for (Map.Entry entry_1 : _entrySet_1) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry_1.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            String _string = ((QualifiedName)entry_1.getKey()).toString();
            String _plus = "Duplicate imported interface " + _string;
            this.error(_plus, (EObject)compDef.getComponent(), (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check
    public void checkEventPattern(PortSelector ev) {
        boolean _equals;
        boolean _tripleEquals;
        ComponentPart _part = ev.getPart();
        boolean bl = _tripleEquals = _part == null;
        if (_tripleEquals) {
            return;
        }
        Component parent = (Component)EcoreUtil2.getContainerOfType((EObject)ev, Component.class);
        List<Connection> connections = ComponentUtilities.getConnectionsForEnd(parent, ev.getPart(), ev.getPort());
        int _size = connections.size();
        boolean bl2 = _equals = _size == 1;
        if (_equals) {
            boolean _tripleEquals_1;
            Connection conn = connections.get(0);
            PortReference otherEnd = ComponentUtilities.otherEnd(conn, ev.getPart(), ev.getPort());
            ComponentPart _part_1 = otherEnd.getPart();
            boolean bl3 = _tripleEquals_1 = _part_1 == null;
            if (_tripleEquals_1) {
                String _name = otherEnd.getPort().getName();
                String _plus = "Use an event pattern that refers to boundary port " + _name;
                this.error(_plus, ev, (EStructuralFeature)ComponentPackage.Literals.PORT_SELECTOR__PORT);
            }
        }
    }

    @Check
    public void checkUnconnectedPorts(Component c) {
        boolean _isEmpty = c.getParts().isEmpty();
        if (_isEmpty) {
            return;
        }
        EList _ports = c.getPorts();
        for (Port port : _ports) {
            boolean _isEmpty_1 = ComponentUtilities.getConnectionsForEnd(c, null, port).isEmpty();
            if (!_isEmpty_1) continue;
            this.warning("The port is unconnected.", (EObject)c, (EStructuralFeature)BehaviorPackage.Literals.BLOCK__PORTS, c.getPorts().indexOf((Object)port));
        }
        EList<ComponentPart> _parts = c.getParts();
        for (ComponentPart part : _parts) {
            EList _ports_1 = part.getComponentType().getPorts();
            for (Port p : _ports_1) {
                boolean _isEmpty_2 = ComponentUtilities.getConnectionsForEnd(c, part, p).isEmpty();
                if (!_isEmpty_2) continue;
                String _name = p.getName();
                String _plus = "Port " + _name;
                String _plus_1 = String.valueOf(_plus) + " is unconnected.";
                this.warning(_plus_1, (EObject)c, (EStructuralFeature)ComponentPackage.Literals.COMPONENT__PARTS, c.getParts().indexOf((Object)part));
            }
        }
    }

    @Check
    public void checkVariableName(ConnectionVariable cv) {
        IScope visibleVars;
        boolean _isEmpty;
        boolean _not;
        int index;
        boolean _tripleEquals;
        Variable _idVarDef = cv.getIdVarDef();
        String _name = null;
        if (_idVarDef != null) {
            _name = _idVarDef.getName();
        }
        boolean bl = _tripleEquals = _name == null;
        if (_tripleEquals) {
            return;
        }
        EObject pred = cv.eContainer();
        if (pred instanceof ActionList && (index = ((ActionList)pred).getActions().indexOf((Object)cv)) > 0) {
            pred = (EObject)((ActionList)pred).getActions().get(index - 1);
        }
        boolean bl2 = _not = !(_isEmpty = IterableExtensions.isEmpty((Iterable)(visibleVars = ((BehaviorScopeProvider)this.scopeProvider).scope_variable(pred)).getElements(QualifiedName.create((String)cv.getIdVarDef().getName()))));
        if (_not) {
            this.error("Variable with this name is already defined", cv, (EStructuralFeature)ComponentPackage.Literals.CONNECTION_VARIABLE__ID_VAR_DEF);
        }
        EList varsToCheck = null;
        if (cv instanceof ActionWithVars) {
            varsToCheck = ((ActionWithVars)cv).getParameters();
        }
        if (cv instanceof TriggeredTransition) {
            varsToCheck = ((TriggeredTransition)cv).getParameters();
        }
        if (varsToCheck == null) {
            return;
        }
        for (Variable v : varsToCheck) {
            boolean _equals = v.getName().equals(cv.getIdVarDef().getName());
            if (!_equals) continue;
            this.error("Variable with this name is already defined", (EObject)v, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check
    public void checkAllowedActionsInTransition(Action act) {
        if (act instanceof AssignmentAction || act instanceof IfAction || act instanceof RecordFieldAssignmentAction) {
            return;
        }
        if (act instanceof CommandReply && act.eContainer() instanceof StateBasedFunctionalConstraint) {
            return;
        }
        StateBasedFunctionalConstraint fc = (StateBasedFunctionalConstraint)EcoreUtil2.getContainerOfType((EObject)act, StateBasedFunctionalConstraint.class);
        if (fc == null) {
            return;
        }
        PortSelector ps = (PortSelector)act;
        boolean isCall = false;
        if (act instanceof EventCall) {
            isCall = ((EventCall)act).getEvent() instanceof Command || ((EventCall)act).getEvent() instanceof Signal;
        } else if (act instanceof EventWithVars) {
            boolean bl = isCall = ((EventWithVars)act).getEvent() instanceof Command || ((EventWithVars)act).getEvent() instanceof Signal;
        }
        if (ps.getPort() instanceof RequiredPort && !isCall) {
            this.error("Action not allowed in transition body for this required port", ps, (EStructuralFeature)ComponentPackage.Literals.PORT_SELECTOR__PORT);
        }
        if (ps.getPort() instanceof ProvidedPort && isCall) {
            this.error("Action not allowed in transition body for this provided port", ps, (EStructuralFeature)ComponentPackage.Literals.PORT_SELECTOR__PORT);
        }
    }

    @Check
    public void checkRepliesMissingCommand(Reply r) {
        boolean _tripleEquals;
        org.eclipse.comma.actions.actions.CommandEvent _command = r.getCommand();
        boolean bl = _tripleEquals = _command == null;
        if (_tripleEquals) {
            Transition t = (Transition)EcoreUtil2.getContainerOfType((EObject)r, Transition.class);
            if (t == null) {
                return;
            }
            EObject _eContainer = r.eContainer();
            ActionList parent = (ActionList)_eContainer;
            int index = parent.getActions().indexOf((Object)r);
            if (t instanceof TriggeredTransition) {
                boolean _tripleEquals_1;
                InterfaceEvent _trigger = ((TriggeredTransition)t).getTrigger();
                boolean bl2 = _tripleEquals_1 = _trigger == null;
                if (_tripleEquals_1) {
                    this.error("The reply has to specify its command when the transition trigger is not a command", (EObject)parent, (EStructuralFeature)ActionsPackage.Literals.ACTION_LIST__ACTIONS, index);
                } else {
                    InterfaceEvent _trigger_1 = ((TriggeredTransition)t).getTrigger();
                    if (_trigger_1 instanceof Command) {
                        if (((TriggeredTransition)t).getPart() != ((PortSelector)r).getPart() || ((TriggeredTransition)t).getPort() != ((PortSelector)r).getPort()) {
                            this.error("The reply has to be on the same port as the transition trigger", (EObject)parent, (EStructuralFeature)ActionsPackage.Literals.ACTION_LIST__ACTIONS, index);
                        }
                    } else {
                        this.error("The reply has to specify its command when the transition trigger is not a command", (EObject)parent, (EStructuralFeature)ActionsPackage.Literals.ACTION_LIST__ACTIONS, index);
                    }
                }
            } else {
                this.error("The reply has to specify its command", (EObject)parent, (EStructuralFeature)ActionsPackage.Literals.ACTION_LIST__ACTIONS, index);
            }
        }
    }
}

