/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib.messages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.comma.monitoring.lib.messages.CMatchResult;
import org.eclipse.comma.monitoring.lib.messages.CMessageCompositePattern;
import org.eclipse.comma.monitoring.lib.messages.CMessagePattern;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;

public class CParallelCompositionPattern
extends CMessageCompositePattern {
    private List<CMessageCompositePattern> elements = new ArrayList<CMessageCompositePattern>();

    public CParallelCompositionPattern addElement(CMessageCompositePattern element) {
        this.elements.add(element);
        return this;
    }

    @Override
    public boolean isSkippable() {
        int i = 0;
        while (i < this.elements.size()) {
            if (!this.elements.get(i).isSkippable()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public CMatchResult match(CObservedMessage observedMessage) {
        boolean failed = false;
        int i = 0;
        while (i < this.elements.size()) {
            CMatchResult result = this.elements.get(i).match(observedMessage);
            switch (result) {
                case MATCH: {
                    if (this.currentInterfaceState != null) {
                        observedMessage.setInterfaceState(this.currentInterfaceState);
                    }
                    return result;
                }
                case DROP: {
                    if (this.currentInterfaceState != null) {
                        observedMessage.setInterfaceState(this.currentInterfaceState);
                    }
                    if (this.elements.size() > 1) {
                        this.elements.remove(i);
                        return CMatchResult.MATCH;
                    }
                    return result;
                }
                case FAIL: {
                    failed = true;
                    break;
                }
            }
            ++i;
        }
        if (failed) {
            return CMatchResult.FAIL;
        }
        return CMatchResult.SKIP;
    }

    @Override
    public List<CMessagePattern> getPossibleEvents() {
        return this.elements.stream().map(x -> x.getPossibleEvents()).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

