/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.behavior.generator.plantuml;

import com.google.common.base.Objects;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.SourceFileReader;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.ActionList;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.actions.actions.EventCall;
import org.eclipse.comma.actions.generator.plantuml.ActionsUmlGenerator;
import org.eclipse.comma.behavior.behavior.AbstractBehavior;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.ConditionedAbsenceOfEvent;
import org.eclipse.comma.behavior.behavior.ConditionedEvent;
import org.eclipse.comma.behavior.behavior.DataConstraint;
import org.eclipse.comma.behavior.behavior.DataConstraintEvent;
import org.eclipse.comma.behavior.behavior.DataConstraintStep;
import org.eclipse.comma.behavior.behavior.DataConstraintUntilOperator;
import org.eclipse.comma.behavior.behavior.DataConstraintsBlock;
import org.eclipse.comma.behavior.behavior.EventInState;
import org.eclipse.comma.behavior.behavior.EventInterval;
import org.eclipse.comma.behavior.behavior.FollowUpEvent;
import org.eclipse.comma.behavior.behavior.GroupTimeConstraint;
import org.eclipse.comma.behavior.behavior.PeriodicEvent;
import org.eclipse.comma.behavior.behavior.SingleTimeConstraint;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.TimeConstraint;
import org.eclipse.comma.behavior.behavior.TimeConstraintExpression;
import org.eclipse.comma.behavior.behavior.TimeConstraintsBlock;
import org.eclipse.comma.behavior.behavior.TimeInterval;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.utilities.StateMachineUtilities;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.comma.types.types.Dimension;
import org.eclipse.comma.types.types.NamedElement;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeReference;
import org.eclipse.comma.types.types.VectorTypeConstructor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class BehaviorUmlGenerator
extends ActionsUmlGenerator {
    private boolean generateImages;
    private final String filePrefix;
    private final AbstractBehavior behavior;
    private static final String EXT_UML = ".plantuml";
    private static final String EXT_PNG = ".png";
    private static final String COMPLETE_UML = "complete";
    private static final String NOACTION_UML = "noactions";
    private static final String NOSELF_UML = "noselftrans";
    private static final String NOSELF_ACTION_UML = "noactions_noselftrans";
    private static final String SEPERATOR = "_";
    private URI outputURI;

    public BehaviorUmlGenerator(AbstractBehavior behavior, IFileSystemAccess fsa) {
        super("", fsa);
        String _plus;
        this.behavior = behavior;
        String _lastSegment = behavior.eResource().getURI().trimFileExtension().lastSegment();
        this.filePrefix = _plus = String.valueOf(_lastSegment) + SEPERATOR;
    }

    public URI setPrjURIForImages(URI prjURI) {
        URI _xblockexpression = null;
        this.generateImages = true;
        URI projectPath = this.getOutputURI(prjURI);
        URI gen = URI.createURI((String)CommaFileSystemAccess.getGenerationFolder((IFileSystemAccess)this.fsa));
        _xblockexpression = this.outputURI = gen.resolve(projectPath);
        return _xblockexpression;
    }

    public void doGenerate() {
        DataConstraintsBlock _dataConstraintsBlock;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        EList<StateMachine> _machines = this.behavior.getMachines();
        for (StateMachine machine : _machines) {
            String _name = machine.getName();
            String _plus = String.valueOf(this.filePrefix) + _name;
            String machineFile = String.valueOf(_plus) + SEPERATOR;
            this.generateUML(String.valueOf(machineFile) + COMPLETE_UML, this.toUMLStateMachine(machine, true, true));
            this.generateUML(String.valueOf(machineFile) + NOACTION_UML, this.toUMLStateMachine(machine, true, false));
            this.generateUML(String.valueOf(machineFile) + NOSELF_UML, this.toUMLStateMachine(machine, false, true));
            this.generateUML(String.valueOf(machineFile) + NOSELF_ACTION_UML, this.toUMLStateMachine(machine, false, false));
        }
        TimeConstraintsBlock _timeConstraintsBlock = this.behavior.getTimeConstraintsBlock();
        boolean bl = _tripleNotEquals = _timeConstraintsBlock != null;
        if (_tripleNotEquals) {
            EList<TimeConstraint> _timeConstraints = this.behavior.getTimeConstraintsBlock().getTimeConstraints();
            for (TimeConstraint tc : _timeConstraints) {
                String _name = tc.getName();
                String _plus = String.valueOf(this.filePrefix) + _name;
                this.generateUML(_plus, this.toUMLSequenceDiagram(tc));
            }
        }
        boolean bl2 = _tripleNotEquals_1 = (_dataConstraintsBlock = this.behavior.getDataConstraintsBlock()) != null;
        if (_tripleNotEquals_1) {
            EList<DataConstraint> _dataConstraints = this.behavior.getDataConstraintsBlock().getDataConstraints();
            for (DataConstraint dc : _dataConstraints) {
                String _name_1 = dc.getName();
                String _plus_1 = String.valueOf(this.filePrefix) + _name_1;
                this.generateUML(_plus_1, this.toUMLSequenceDiagram(dc));
            }
        }
    }

    public GeneratedImage generateUML(String file, CharSequence contents) {
        try {
            GeneratedImage _xblockexpression = null;
            this.fsa.generateFile(String.valueOf(file) + EXT_UML, contents);
            GeneratedImage _xifexpression = null;
            if (this.generateImages) {
                boolean _not;
                GeneratedImage _xblockexpression_1 = null;
                this.fsa.generateFile(String.valueOf(file) + EXT_PNG, (CharSequence)"");
                URI umlURI = URI.createURI((String)(String.valueOf(file) + EXT_UML)).resolve(this.outputURI);
                String _fileString = umlURI.toFileString();
                File umlFile = new File(_fileString);
                SourceFileReader reader = new SourceFileReader(umlFile);
                GeneratedImage _xifexpression_1 = null;
                boolean _isEmpty = reader.getGeneratedImages().isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    _xifexpression_1 = (GeneratedImage)reader.getGeneratedImages().get(0);
                }
                _xifexpression = _xblockexpression_1 = _xifexpression_1;
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected CharSequence _toUMLSequenceDiagram(DataConstraint dc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@startuml");
        _builder.newLine();
        _builder.append("title Data Rule ");
        String _name = dc.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        EList<DataConstraintStep> _steps = dc.getSteps();
        for (DataConstraintStep step : _steps) {
            CharSequence _dataConstraintStepToUML = this.dataConstraintStepToUML(step);
            _builder.append((Object)_dataConstraintStepToUML);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("... where globally ");
        CharSequence _generateExpression = this.generateExpression(dc.getCondition());
        _builder.append((Object)_generateExpression);
        _builder.append("...");
        _builder.newLineIfNotEmpty();
        _builder.append("@enduml");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _dataConstraintStepToUML(DataConstraintEvent st) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _negated = st.getNegated();
        boolean bl = _tripleNotEquals = _negated != null;
        if (_tripleNotEquals) {
            CharSequence _eventToUML = this.eventToUML(st.getEvent().getEvent(), false);
            _builder.append((Object)_eventToUML);
        } else {
            CharSequence _eventToUML_1 = this.eventToUML(st.getEvent().getEvent(), true);
            _builder.append((Object)_eventToUML_1);
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _dataConstraintStepToUML(DataConstraintUntilOperator st) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("loop ");
        String _negated = st.getBody().getNegated();
        boolean bl = _tripleNotEquals = _negated != null;
        if (_tripleNotEquals) {
            _builder.append("not observed");
        } else {
            _builder.append("observe");
        }
        _builder.newLineIfNotEmpty();
        CharSequence _eventToUML = this.eventToUML(st.getBody().getEvent().getEvent(), true);
        _builder.append((Object)_eventToUML);
        _builder.newLineIfNotEmpty();
        _builder.append("end");
        _builder.newLine();
        _builder.append("... until ...");
        _builder.newLine();
        CharSequence _dataConstraintStepToUML = this.dataConstraintStepToUML(st.getStop());
        _builder.append((Object)_dataConstraintStepToUML);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _toUMLSequenceDiagram(SingleTimeConstraint tc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@startuml");
        _builder.newLine();
        _builder.append("title Timing Rule ");
        String _name = tc.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        CharSequence _simpleTimeConstraintToUML = this.simpleTimeConstraintToUML(tc.getConstraint());
        _builder.append((Object)_simpleTimeConstraintToUML);
        _builder.newLineIfNotEmpty();
        _builder.append("@enduml");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _toUMLSequenceDiagram(GroupTimeConstraint tc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@startuml");
        _builder.newLine();
        _builder.append("title Scenario ");
        String _name = tc.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        CharSequence _simpleTimeConstraintToUML = this.simpleTimeConstraintToUML(tc.getFirst());
        _builder.append((Object)_simpleTimeConstraintToUML);
        _builder.newLineIfNotEmpty();
        EList<FollowUpEvent> _followups = tc.getFollowups();
        for (FollowUpEvent c : _followups) {
            _builder.append("... within ");
            CharSequence _intervalToString = this.intervalToString(c.getInterval());
            _builder.append((Object)_intervalToString);
            _builder.append(" ...");
            _builder.newLineIfNotEmpty();
            CharSequence _eventToUML = this.eventToUML(c.getEvent().getEvent(), true);
            _builder.append((Object)_eventToUML);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("@enduml");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _simpleTimeConstraintToUML(ConditionedEvent r) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _eventToUML = this.eventToUML(r.getCondition().getEvent(), true);
        _builder.append((Object)_eventToUML);
        _builder.newLineIfNotEmpty();
        _builder.append("... within ");
        CharSequence _intervalToString = this.intervalToString(r.getInterval());
        _builder.append((Object)_intervalToString);
        _builder.append(" ...");
        _builder.newLineIfNotEmpty();
        CharSequence _eventToUML_1 = this.eventToUML(r.getEvent().getEvent(), true);
        _builder.append((Object)_eventToUML_1);
        _builder.append("\t");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _simpleTimeConstraintToUML(ConditionedAbsenceOfEvent r) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _eventToUML = this.eventToUML(r.getCondition().getEvent(), true);
        _builder.append((Object)_eventToUML);
        _builder.newLineIfNotEmpty();
        _builder.append("... within ");
        CharSequence _intervalToString = this.intervalToString(r.getInterval());
        _builder.append((Object)_intervalToString);
        _builder.append(" ...");
        _builder.newLineIfNotEmpty();
        CharSequence _eventToUML_1 = this.eventToUML(r.getEvent().getEvent(), false);
        _builder.append((Object)_eventToUML_1);
        _builder.append("\t");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _simpleTimeConstraintToUML(EventInterval r) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _eventToUML = this.eventToUML(r.getCondition().getEvent(), true);
        _builder.append((Object)_eventToUML);
        _builder.newLineIfNotEmpty();
        _builder.append("alt the following event is observed");
        _builder.newLine();
        _builder.append("...within ");
        CharSequence _intervalToString = this.intervalToString(r.getInterval());
        _builder.append((Object)_intervalToString);
        _builder.append(" ...");
        _builder.newLineIfNotEmpty();
        CharSequence _eventToUML_1 = this.eventToUML(r.getEvent().getEvent(), true);
        _builder.append((Object)_eventToUML_1);
        _builder.newLineIfNotEmpty();
        _builder.append("else event is not observed -> rule is not triggered");
        _builder.newLine();
        _builder.append("...other events...");
        _builder.newLine();
        _builder.append("end");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _simpleTimeConstraintToUML(PeriodicEvent r) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _eventToUML = this.eventToUML(r.getCondition().getEvent(), true);
        _builder.append((Object)_eventToUML);
        _builder.newLineIfNotEmpty();
        _builder.append("loop period ");
        CharSequence _generateExpression = this.generateExpression(r.getPeriod());
        _builder.append((Object)_generateExpression);
        _builder.append(" ms and jitter ");
        CharSequence _generateExpression_1 = this.generateExpression(r.getJitter());
        _builder.append((Object)_generateExpression_1);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        CharSequence _eventToUML_1 = this.eventToUML(r.getEvent(), true);
        _builder.append((Object)_eventToUML_1);
        _builder.newLineIfNotEmpty();
        _builder.append("end");
        _builder.newLine();
        EventInState _stopEvent = r.getStopEvent();
        boolean bl = _tripleNotEquals = _stopEvent != null;
        if (_tripleNotEquals) {
            _builder.append("...until...");
            _builder.newLine();
            CharSequence _eventToUML_2 = this.eventToUML(r.getStopEvent().getEvent(), true);
            _builder.append((Object)_eventToUML_2);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence intervalToString(TimeInterval i) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("[");
        Expression _begin = i.getBegin();
        boolean bl = _tripleNotEquals = _begin != null;
        if (_tripleNotEquals) {
            CharSequence _generateExpression = this.generateExpression(i.getBegin());
            _builder.append((Object)_generateExpression);
            _builder.append(" ms");
        }
        _builder.append(" .. ");
        Expression _end = i.getEnd();
        boolean bl2 = _tripleNotEquals_1 = _end != null;
        if (_tripleNotEquals_1) {
            CharSequence _generateExpression_1 = this.generateExpression(i.getEnd());
            _builder.append((Object)_generateExpression_1);
            _builder.append(" ms");
        }
        _builder.append(" ]");
        return _builder;
    }

    public CharSequence toUMLStateMachine(StateMachine m, boolean withSelfTransitions, boolean withActions) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@startuml");
        _builder.newLine();
        _builder.newLine();
        _builder.append("[*] -> ");
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State s) {
                return s.isInitial();
            }
        };
        String _name = ((State[])Conversions.unwrapArray((Object)IterableExtensions.filter(m.getStates(), (Functions.Function1)_function), State.class))[0].getName();
        _builder.append(_name);
        if (withActions) {
            _builder.append(": /-");
        }
        _builder.newLineIfNotEmpty();
        EList<State> _states = m.getStates();
        for (State s : _states) {
            List<Transition> _transitionsForState = StateMachineUtilities.transitionsForState(m, s);
            for (Transition t : _transitionsForState) {
                EList<Clause> _clauses = t.getClauses();
                for (Clause c : _clauses) {
                    Expression _guard_1;
                    boolean _tripleNotEquals_1;
                    if (c.getTarget() != null && Objects.equal((Object)s, (Object)c.getTarget()) || c.getTarget() == null) {
                        Expression _guard;
                        boolean _tripleNotEquals;
                        if (!withSelfTransitions) continue;
                        String _name_1 = s.getName();
                        _builder.append(_name_1);
                        _builder.append(" --> ");
                        String _name_2 = s.getName();
                        _builder.append(_name_2);
                        if (t instanceof TriggeredTransition || t.getGuard() != null || this.hasActionPart(c) || withActions) {
                            _builder.append(": ");
                        }
                        if (t instanceof TriggeredTransition) {
                            boolean _greaterThan;
                            EObject _eContainer = ((TriggeredTransition)t).getTrigger().eContainer();
                            String _name_3 = ((Signature)_eContainer).getName();
                            _builder.append(_name_3);
                            _builder.append("::");
                            String _name_4 = ((TriggeredTransition)t).getTrigger().getName();
                            _builder.append(_name_4);
                            int _size = ((TriggeredTransition)t).getParameters().size();
                            boolean bl = _greaterThan = _size > 0;
                            if (_greaterThan) {
                                _builder.append("(");
                                EList<Variable> _parameters = ((TriggeredTransition)t).getParameters();
                                boolean _hasElements = false;
                                for (Variable p : _parameters) {
                                    if (!_hasElements) {
                                        _hasElements = true;
                                    } else {
                                        _builder.appendImmediate((Object)", ", "");
                                    }
                                    CharSequence _typeToString = BehaviorUmlGenerator.typeToString(p.getType());
                                    _builder.append((Object)_typeToString);
                                    _builder.append(" ");
                                    String _name_5 = p.getName();
                                    _builder.append(_name_5);
                                }
                                _builder.append(")");
                            }
                        }
                        boolean bl = _tripleNotEquals = (_guard = t.getGuard()) != null;
                        if (_tripleNotEquals) {
                            _builder.append("[");
                            CharSequence _generateExpression = this.generateExpression(t.getGuard());
                            _builder.append((Object)_generateExpression);
                            _builder.append("]");
                        }
                        if (withActions) {
                            CharSequence _allActionsToUML = this.allActionsToUML(c);
                            _builder.append((Object)_allActionsToUML);
                        } else {
                            CharSequence _actionToUML = this.actionToUML(c);
                            _builder.append((Object)_actionToUML);
                        }
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    String _name_6 = s.getName();
                    _builder.append(_name_6);
                    _builder.append(" --> ");
                    String _name_7 = c.getTarget().getName();
                    _builder.append(_name_7);
                    if (t instanceof TriggeredTransition || t.getGuard() != null || this.hasActionPart(c) || withActions) {
                        _builder.append(": ");
                    }
                    if (t instanceof TriggeredTransition) {
                        boolean _greaterThan_1;
                        EObject _eContainer_1 = ((TriggeredTransition)t).getTrigger().eContainer();
                        String _name_8 = ((Signature)_eContainer_1).getName();
                        _builder.append(_name_8);
                        _builder.append("::");
                        String _name_9 = ((TriggeredTransition)t).getTrigger().getName();
                        _builder.append(_name_9);
                        int _size_1 = ((TriggeredTransition)t).getParameters().size();
                        boolean bl = _greaterThan_1 = _size_1 > 0;
                        if (_greaterThan_1) {
                            _builder.append("(");
                            EList<Variable> _parameters_1 = ((TriggeredTransition)t).getParameters();
                            boolean _hasElements_1 = false;
                            for (Variable p_1 : _parameters_1) {
                                if (!_hasElements_1) {
                                    _hasElements_1 = true;
                                } else {
                                    _builder.appendImmediate((Object)", ", "");
                                }
                                CharSequence _typeToString_1 = BehaviorUmlGenerator.typeToString(p_1.getType());
                                _builder.append((Object)_typeToString_1);
                                _builder.append(" ");
                                String _name_10 = p_1.getName();
                                _builder.append(_name_10);
                            }
                            _builder.append(")");
                        }
                    }
                    boolean bl = _tripleNotEquals_1 = (_guard_1 = t.getGuard()) != null;
                    if (_tripleNotEquals_1) {
                        _builder.append("[");
                        CharSequence _generateExpression_1 = this.generateExpression(t.getGuard());
                        _builder.append((Object)_generateExpression_1);
                        _builder.append("]");
                    }
                    if (withActions) {
                        CharSequence _allActionsToUML_1 = this.allActionsToUML(c);
                        _builder.append((Object)_allActionsToUML_1);
                    } else {
                        CharSequence _actionToUML_1 = this.actionToUML(c);
                        _builder.append((Object)_actionToUML_1);
                    }
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        _builder.newLine();
        _builder.append("@enduml");
        _builder.newLine();
        return _builder;
    }

    protected static CharSequence _typeToString(TypeReference tr) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = tr.getType().getName();
        _builder.append(_name);
        return _builder;
    }

    protected static CharSequence _typeToString(VectorTypeConstructor tr) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = tr.getType().getName();
        _builder.append(_name);
        EList _dimensions = tr.getDimensions();
        for (Dimension d : _dimensions) {
            _builder.append("[]");
        }
        return _builder;
    }

    public CharSequence allActionsToUML(Clause c) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/");
        ActionList _actions = c.getActions();
        boolean bl = _tripleNotEquals = _actions != null;
        if (_tripleNotEquals) {
            EList _actions_1 = c.getActions().getActions();
            for (Action a : _actions_1) {
                CharSequence _generateAction = this.generateAction((EObject)a);
                _builder.append((Object)_generateAction);
            }
        } else {
            _builder.append("-");
        }
        return _builder;
    }

    public CharSequence actionToUML(Clause c) {
        boolean _tripleNotEquals;
        StringConcatenation _builder;
        StringConcatenation _xblockexpression = null;
        Object result = null;
        TreeIterator iter = null;
        EObject o = null;
        boolean found = false;
        EventCall n = null;
        CommandReply r = null;
        found = false;
        result = _builder = new StringConcatenation();
        ActionList _actions = c.getActions();
        boolean bl = _tripleNotEquals = _actions != null;
        if (_tripleNotEquals) {
            iter = c.getActions().eAllContents();
            while (iter.hasNext() && !found) {
                boolean _greaterThan_1;
                o = (EObject)iter.next();
                if (o instanceof EventCall) {
                    boolean _greaterThan;
                    n = (EventCall)o;
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("/");
                    EObject _eContainer = n.getEvent().eContainer();
                    String _name = ((Signature)_eContainer).getName();
                    String _plus = String.valueOf(_builder_1.toString()) + _name;
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("::");
                    String _plus_1 = String.valueOf(_plus) + _builder_2;
                    String _name_1 = n.getEvent().getName();
                    String _plus_2 = String.valueOf(_plus_1) + _name_1;
                    result = _plus_2;
                    int _size = n.getParameters().size();
                    boolean bl2 = _greaterThan = _size > 0;
                    if (_greaterThan) {
                        StringConcatenation _builder_3 = new StringConcatenation();
                        _builder_3.append("(");
                        EList _parameters = n.getParameters();
                        boolean _hasElements = false;
                        for (Expression p : _parameters) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder_3.appendImmediate((Object)", ", "");
                            }
                            CharSequence _generateExpression = this.generateExpression(p);
                            _builder_3.append((Object)_generateExpression);
                        }
                        _builder_3.append(")");
                        String _plus_3 = result + _builder_3.toString();
                        result = _plus_3;
                    }
                    found = true;
                }
                if (!(o instanceof CommandReply)) continue;
                r = (CommandReply)o;
                StringConcatenation _builder_4 = new StringConcatenation();
                _builder_4.append("/reply");
                result = _builder_4;
                int _size_1 = r.getParameters().size();
                boolean bl3 = _greaterThan_1 = _size_1 > 0;
                if (_greaterThan_1) {
                    StringConcatenation _builder_5 = new StringConcatenation();
                    _builder_5.append("(");
                    EList _parameters_1 = r.getParameters();
                    boolean _hasElements_1 = false;
                    for (Expression p_1 : _parameters_1) {
                        if (!_hasElements_1) {
                            _hasElements_1 = true;
                        } else {
                            _builder_5.appendImmediate((Object)", ", "");
                        }
                        CharSequence _generateExpression_1 = this.generateExpression(p_1);
                        _builder_5.append((Object)_generateExpression_1);
                    }
                    _builder_5.append(")");
                    String _plus_4 = result + _builder_5.toString();
                    result = _plus_4;
                }
                found = true;
            }
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("/-");
            result = _builder_1;
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public boolean hasActionPart(Clause c) {
        boolean _tripleNotEquals;
        boolean _xblockexpression = false;
        boolean result = false;
        TreeIterator iter = null;
        EObject o = null;
        ActionList _actions = c.getActions();
        boolean bl = _tripleNotEquals = _actions != null;
        if (_tripleNotEquals) {
            iter = c.getActions().eAllContents();
            while (iter.hasNext() && !result) {
                o = (EObject)iter.next();
                if (!(o instanceof EventCall) && !(o instanceof CommandReply)) continue;
                result = true;
            }
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    private URI getOutputURI(URI prjURI) {
        boolean _hasTrailingPathSeparator;
        boolean _not;
        URI outputDir;
        URI rURI = prjURI;
        boolean _isPlatform = rURI.isPlatform();
        if (_isPlatform) {
            IResource eclipseResource = ResourcesPlugin.getWorkspace().getRoot().findMember(rURI.toPlatformString(true));
            rURI = URI.createFileURI((String)eclipseResource.getRawLocation().toOSString());
        }
        if ((outputDir = this.getOutputConfiguration()) == null) {
            throw new IllegalArgumentException("Output directory was not set.");
        }
        boolean _isRelative = outputDir.isRelative();
        if (_isRelative) {
            outputDir = outputDir.resolve(rURI);
        }
        boolean bl = _not = !(_hasTrailingPathSeparator = outputDir.hasTrailingPathSeparator());
        if (_not) {
            outputDir.appendSegment("");
        }
        return outputDir;
    }

    private URI getOutputConfiguration() {
        IFileSystemAccess access = this.fsa;
        if (access instanceof CommaFileSystemAccess) {
            access = ((CommaFileSystemAccess)access).getIFileSystemAccess();
        }
        Path tempPath = new Path("DEFAULT_OUTPUT");
        if (access instanceof AbstractFileSystemAccess) {
            boolean _not;
            Map configs = ((AbstractFileSystemAccess)access).getOutputConfigurations();
            boolean _isEmpty = configs.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                Path _path;
                String _outputDirectory = ((OutputConfiguration)configs.get("DEFAULT_OUTPUT")).getOutputDirectory();
                tempPath = _path = new Path(_outputDirectory);
            }
        }
        Object _xifexpression = null;
        boolean _hasTrailingSeparator = tempPath.hasTrailingSeparator();
        boolean _not_1 = !_hasTrailingSeparator;
        _xifexpression = _not_1 ? tempPath.addTrailingSeparator() : tempPath;
        Path path = _xifexpression;
        return URI.createFileURI((String)path.toString());
    }

    public CharSequence toUMLSequenceDiagram(NamedElement tc) {
        if (tc instanceof GroupTimeConstraint) {
            return this._toUMLSequenceDiagram((GroupTimeConstraint)tc);
        }
        if (tc instanceof SingleTimeConstraint) {
            return this._toUMLSequenceDiagram((SingleTimeConstraint)tc);
        }
        if (tc instanceof DataConstraint) {
            return this._toUMLSequenceDiagram((DataConstraint)tc);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(tc).toString());
    }

    public CharSequence dataConstraintStepToUML(DataConstraintStep st) {
        if (st instanceof DataConstraintEvent) {
            return this._dataConstraintStepToUML((DataConstraintEvent)st);
        }
        if (st instanceof DataConstraintUntilOperator) {
            return this._dataConstraintStepToUML((DataConstraintUntilOperator)st);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(st).toString());
    }

    public CharSequence simpleTimeConstraintToUML(TimeConstraintExpression r) {
        if (r instanceof ConditionedAbsenceOfEvent) {
            return this._simpleTimeConstraintToUML((ConditionedAbsenceOfEvent)r);
        }
        if (r instanceof ConditionedEvent) {
            return this._simpleTimeConstraintToUML((ConditionedEvent)r);
        }
        if (r instanceof EventInterval) {
            return this._simpleTimeConstraintToUML((EventInterval)r);
        }
        if (r instanceof PeriodicEvent) {
            return this._simpleTimeConstraintToUML((PeriodicEvent)r);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(r).toString());
    }

    public static CharSequence typeToString(Type tr) {
        if (tr instanceof TypeReference) {
            return BehaviorUmlGenerator._typeToString((TypeReference)tr);
        }
        if (tr instanceof VectorTypeConstructor) {
            return BehaviorUmlGenerator._typeToString((VectorTypeConstructor)tr);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(tr).toString());
    }
}

