/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.evaluator;

import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.RequiredPort;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.component.component.ExpressionInterfaceState;
import org.eclipse.comma.behavior.component.component.impl.PredicateFunctionalConstraintImpl;
import org.eclipse.comma.evaluator.EAction;
import org.eclipse.comma.evaluator.EComponentState;
import org.eclipse.comma.evaluator.EConnection;
import org.eclipse.comma.evaluator.EIConstraint;
import org.eclipse.comma.evaluator.EInterfaceState;
import org.eclipse.comma.evaluator.EVariable;
import org.eclipse.comma.evaluator.EVariableCollection;
import org.eclipse.comma.evaluator.EVariableType;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionAnd;
import org.eclipse.comma.expressions.expression.ExpressionBracket;
import org.eclipse.comma.expressions.expression.ExpressionNot;
import org.eclipse.comma.expressions.expression.ExpressionOr;

public class EPredicateFunctionalConstraint
implements EIConstraint {
    private final PredicateFunctionalConstraintImpl constraint;

    public EPredicateFunctionalConstraint(PredicateFunctionalConstraintImpl c) {
        this.constraint = c;
        if (c.getInitActions().size() != 0 || c.getVars().size() != 0) {
            throw new RuntimeException("Not yet implemented");
        }
    }

    private static boolean isConditionTrue(Expression expression, final EComponentState nextState) {
        return EVariable.fromExpression(expression, null, new BiFunction<Expression, EVariableCollection, EVariable>(){

            @Override
            public EVariable apply(Expression exp, EVariableCollection u) {
                if (exp instanceof ExpressionInterfaceState) {
                    ExpressionInterfaceState ei = (ExpressionInterfaceState)exp;
                    StateMachine machine = (StateMachine)ei.getState().eContainer();
                    List states = nextState.connections.entrySet().stream().filter(e -> ((EConnection)e.getKey()).port.equals(ei.getPort().getName())).map(e -> (EInterfaceState)e.getValue()).collect(Collectors.toList());
                    if (states.size() != 1) {
                        throw new RuntimeException("Not supported");
                    }
                    return new EVariable(EVariableType.BOOL, ((EInterfaceState)states.get((int)0)).states.get(machine) == ei.getState(), null);
                }
                throw new RuntimeException("Not supported");
            }
        }).getValueBool();
    }

    @Override
    public boolean isAllowed(EComponentState currentState, EComponentState nextState, EAction action) {
        return EPredicateFunctionalConstraint.isConditionTrue(this.constraint.getExpression(), currentState) && EPredicateFunctionalConstraint.isConditionTrue(this.constraint.getExpression(), nextState);
    }

    @Override
    public EIConstraint take(EComponentState currentState, EComponentState nextState, EAction action) {
        return this;
    }

    @Override
    public boolean usesRequiredPort(List<Port> ports) {
        return this.usesRequiredPortInternal(this.constraint.getExpression(), ports);
    }

    private boolean usesRequiredPortInternal(Expression expression, List<Port> ports) {
        if (expression instanceof ExpressionOr) {
            ExpressionOr e = (ExpressionOr)expression;
            return this.usesRequiredPortInternal(e.getLeft(), ports) || this.usesRequiredPortInternal(e.getRight(), ports);
        }
        if (expression instanceof ExpressionNot) {
            ExpressionNot e = (ExpressionNot)expression;
            return this.usesRequiredPortInternal(e.getSub(), ports);
        }
        if (expression instanceof ExpressionInterfaceState) {
            Port expressionPort = ((ExpressionInterfaceState)expression).getPort();
            Port port = ports.stream().filter(p -> p.getName().equals(expressionPort.getName())).findFirst().get();
            return port instanceof RequiredPort;
        }
        if (expression instanceof ExpressionBracket) {
            ExpressionBracket e = (ExpressionBracket)expression;
            return this.usesRequiredPortInternal(e.getSub(), ports);
        }
        if (expression instanceof ExpressionAnd) {
            ExpressionAnd e = (ExpressionAnd)expression;
            return this.usesRequiredPortInternal(e.getLeft(), ports) && this.usesRequiredPortInternal(e.getRight(), ports);
        }
        throw new RuntimeException("Not supported");
    }
}

