/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.NamespacesTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.ServerCapabilitiesTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.ServerDiagnosticsTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.ServerRedundancyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.VendorServerInfoTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.ServerStatusTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ServerType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.ServerStatusDataType;

public class ServerTypeNode
extends BaseObjectTypeNode
implements ServerType {
    public ServerTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public String[] getServerArray() throws UaException {
        PropertyTypeNode node = this.getServerArrayNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setServerArray(String[] serverArray) throws UaException {
        PropertyTypeNode node = this.getServerArrayNode();
        node.setValue(new Variant((Object)serverArray));
    }

    @Override
    public String[] readServerArray() throws UaException {
        try {
            return this.readServerArrayAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeServerArray(String[] serverArray) throws UaException {
        try {
            this.writeServerArrayAsync(serverArray).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readServerArrayAsync() {
        return ((CompletableFuture)this.getServerArrayNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeServerArrayAsync(String[] serverArray) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)serverArray));
        return this.getServerArrayNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getServerArrayNode() throws UaException {
        try {
            return this.getServerArrayNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getServerArrayNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerArray", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String[] getNamespaceArray() throws UaException {
        PropertyTypeNode node = this.getNamespaceArrayNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setNamespaceArray(String[] namespaceArray) throws UaException {
        PropertyTypeNode node = this.getNamespaceArrayNode();
        node.setValue(new Variant((Object)namespaceArray));
    }

    @Override
    public String[] readNamespaceArray() throws UaException {
        try {
            return this.readNamespaceArrayAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeNamespaceArray(String[] namespaceArray) throws UaException {
        try {
            this.writeNamespaceArrayAsync(namespaceArray).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readNamespaceArrayAsync() {
        return ((CompletableFuture)this.getNamespaceArrayNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeNamespaceArrayAsync(String[] namespaceArray) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)namespaceArray));
        return this.getNamespaceArrayNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getNamespaceArrayNode() throws UaException {
        try {
            return this.getNamespaceArrayNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getNamespaceArrayNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NamespaceArray", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UByte getServiceLevel() throws UaException {
        PropertyTypeNode node = this.getServiceLevelNode();
        return (UByte)node.getValue().getValue().getValue();
    }

    @Override
    public void setServiceLevel(UByte serviceLevel) throws UaException {
        PropertyTypeNode node = this.getServiceLevelNode();
        node.setValue(new Variant((Object)serviceLevel));
    }

    @Override
    public UByte readServiceLevel() throws UaException {
        try {
            return this.readServiceLevelAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeServiceLevel(UByte serviceLevel) throws UaException {
        try {
            this.writeServiceLevelAsync(serviceLevel).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UByte> readServiceLevelAsync() {
        return ((CompletableFuture)this.getServiceLevelNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UByte)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeServiceLevelAsync(UByte serviceLevel) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)serviceLevel));
        return this.getServiceLevelNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getServiceLevelNode() throws UaException {
        try {
            return this.getServiceLevelNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getServiceLevelNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServiceLevel", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getAuditing() throws UaException {
        PropertyTypeNode node = this.getAuditingNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setAuditing(Boolean auditing) throws UaException {
        PropertyTypeNode node = this.getAuditingNode();
        node.setValue(new Variant((Object)auditing));
    }

    @Override
    public Boolean readAuditing() throws UaException {
        try {
            return this.readAuditingAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeAuditing(Boolean auditing) throws UaException {
        try {
            this.writeAuditingAsync(auditing).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readAuditingAsync() {
        return ((CompletableFuture)this.getAuditingNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeAuditingAsync(Boolean auditing) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)auditing));
        return this.getAuditingNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getAuditingNode() throws UaException {
        try {
            return this.getAuditingNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getAuditingNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Auditing", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DateTime getEstimatedReturnTime() throws UaException {
        PropertyTypeNode node = this.getEstimatedReturnTimeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setEstimatedReturnTime(DateTime estimatedReturnTime) throws UaException {
        PropertyTypeNode node = this.getEstimatedReturnTimeNode();
        node.setValue(new Variant((Object)estimatedReturnTime));
    }

    @Override
    public DateTime readEstimatedReturnTime() throws UaException {
        try {
            return this.readEstimatedReturnTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeEstimatedReturnTime(DateTime estimatedReturnTime) throws UaException {
        try {
            this.writeEstimatedReturnTimeAsync(estimatedReturnTime).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readEstimatedReturnTimeAsync() {
        return ((CompletableFuture)this.getEstimatedReturnTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEstimatedReturnTimeAsync(DateTime estimatedReturnTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)estimatedReturnTime));
        return this.getEstimatedReturnTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getEstimatedReturnTimeNode() throws UaException {
        try {
            return this.getEstimatedReturnTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getEstimatedReturnTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EstimatedReturnTime", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public ServerStatusDataType getServerStatus() throws UaException {
        ServerStatusTypeNode node = this.getServerStatusNode();
        return this.cast(node.getValue().getValue().getValue(), ServerStatusDataType.class);
    }

    @Override
    public void setServerStatus(ServerStatusDataType serverStatus) throws UaException {
        ServerStatusTypeNode node = this.getServerStatusNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)serverStatus);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServerStatusDataType readServerStatus() throws UaException {
        try {
            return this.readServerStatusAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeServerStatus(ServerStatusDataType serverStatus) throws UaException {
        try {
            this.writeServerStatusAsync(serverStatus).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServerStatusDataType> readServerStatusAsync() {
        return ((CompletableFuture)this.getServerStatusNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServerStatusDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeServerStatusAsync(ServerStatusDataType serverStatus) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)serverStatus);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getServerStatusNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public ServerStatusTypeNode getServerStatusNode() throws UaException {
        try {
            return this.getServerStatusNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends ServerStatusTypeNode> getServerStatusNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerStatus", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (ServerStatusTypeNode)node);
    }

    @Override
    public ServerCapabilitiesTypeNode getServerCapabilitiesNode() throws UaException {
        try {
            return this.getServerCapabilitiesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends ServerCapabilitiesTypeNode> getServerCapabilitiesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerCapabilities", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (ServerCapabilitiesTypeNode)node);
    }

    @Override
    public ServerDiagnosticsTypeNode getServerDiagnosticsNode() throws UaException {
        try {
            return this.getServerDiagnosticsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends ServerDiagnosticsTypeNode> getServerDiagnosticsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerDiagnostics", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (ServerDiagnosticsTypeNode)node);
    }

    @Override
    public VendorServerInfoTypeNode getVendorServerInfoNode() throws UaException {
        try {
            return this.getVendorServerInfoNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends VendorServerInfoTypeNode> getVendorServerInfoNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "VendorServerInfo", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (VendorServerInfoTypeNode)node);
    }

    @Override
    public ServerRedundancyTypeNode getServerRedundancyNode() throws UaException {
        try {
            return this.getServerRedundancyNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends ServerRedundancyTypeNode> getServerRedundancyNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerRedundancy", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (ServerRedundancyTypeNode)node);
    }

    @Override
    public NamespacesTypeNode getNamespacesNode() throws UaException {
        try {
            return this.getNamespacesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends NamespacesTypeNode> getNamespacesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Namespaces", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (NamespacesTypeNode)node);
    }
}

