---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Mixed Content

## Description

The target application was found to request resources over insecure transport protocols (HTTP). This is usually due to HTML
elements which load resources using the `http://` scheme instead of `https://`. It should be noted that most modern browsers
block these requests automatically so there is limited risk.

Some parts of the application may not behave correctly since these files are not being properly loaded.

## Remediation

Ensure all HTML elements which load resources from a URL (JavaScript, stylesheets, images, video and other media) are set to
use the `https://` scheme instead of `http://`. Alternatively, developers may use the `//` scheme, which will only load resources
over the same protocol that the originating page was loaded.

A browser visiting the website `https://example.com` with the HTML loading a file using
`<script src="//example.com/cdn/bundle.js"></script>`, would ensure the `example.com/cdn/bundle.js` file was loaded over
HTTPS.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 319.1 | true | 319 | Passive | Info |

## Links

- [OWASP](https://owasp.org/www-community/vulnerabilities/Insecure_Transport)
- [CWE](https://cwe.mitre.org/data/definitions/319.html)
- [MDN](https://developer.mozilla.org/en-US/docs/Web/Security/Mixed_content)
