#!/bin/awk -f 

#
#    REFERENCES -- bibliographic software
#    Copyright (C) 1995-2006  Volker Kiefel
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
#    USA
#

#
#    vi_sr.awk -- create a list of `search and replace' macros for the vi(m)
#    text editor
#    
#    Usage:
#
#       awk [-v output_file=NameOfOutputFile.txt] -f vi_sr.awk textfile
#
#    Versions:
#    31.7.2005: name of `outfle' may be changed (for References v4.2)
#

BEGIN {
  a = ""
  if (!output_file)
  {
    outfle = "vi-mak.txt"
  } else
  {
    outfle=output_file
  }
}
{
  a = $0;
  gsub(/\/\/\/A\/\/\//,":%s/",a) 
  gsub(/\/\/\/B\/\/\//,"/",a)
  gsub(/\/\/\/C\/\/\//,"/g",a)
  print a > outfle
}

END {
  print "\nVi(m) script " outfle " created\n"
  close(outfle)
}


# vim:tw=2048
