/* l2xiexec.h  for LTX2X interpreter  */

#ifndef exec_h
#define exec_h

#include "l2xicmon.h"
#include "listsetc.h"

/*  following markers are now at the end of the TOKEN_CODE enumeration */
/*
* #define STATEMENT_MARKER 0x70
* #define ADDRESS_MARKER 0x71
*/

/* runtime stack */


   /* stack value types */
typedef enum { 
#define sotc(a, b, c, d) a,
#define sftc(a, b, c, d) a,
#define fotc(a, b, c, d)
#include "l2xisftc.h"
#undef sotc
#undef sftc
#undef fotc
} STACK_TYPE;


typedef struct {
  STACK_TYPE type;
  union {
    XPRSAINT integer;      /* STKINT, STKLOG, STKUDF */
    XPRSAREAL real;        /* STKREA */
    STRING string;         /* STKSTR */
    ADDRESS address;       /* all others */
    LBS_PTR head;          /* STKBAG, STKLST, STKSET */
  } value;
} STACK_ITEM, *STACK_ITEM_PTR;

typedef struct {
  STACK_ITEM function_value;
  STACK_ITEM static_link;
  STACK_ITEM dynamic_link;
  STACK_ITEM return_address;
} *STACK_FRAME_HEADER_PTR;

/* functions */

SYMTAB_NODE_PTR get_symtab_cptr();
int get_statement_cmarker();
TYPE_STRUCT_PTR exec_routine_call();
TYPE_STRUCT_PTR exec_expression();
TYPE_STRUCT_PTR exec_variable();


ICT *crunch_address_marker();
ADDRESS fixup_address_marker();
ADDRESS get_address_cmarker();
XPRSAINT get_cinteger();
ADDRESS get_caddress();
ADDRESS get_address();
XPRSAREAL get_real();
ADDRESS get_static_link();
ADDRESS get_dynamic_link();
ADDRESS get_return_address();

/* macros */

/* get_ctoken  -- extract next token code from the current code segment */
/* #define get_ctoken()      entry_debug("getting_ctoken (l2xiexec.h)");   \
                          code_segment_entry_debug(code_segmentp);      \
                          ctoken = *code_segmentp++;                    \
                          exit_debug("got_ctoken")

#define get_ctoken()      code_segment_entry_debug(code_segmentp);      \
                          ctoken = *code_segmentp++
*/

/* pop  -- pop the runtime stack */
#define pop() stack_access_debug("Popped", tos); \
              --tos

/* Tracing routine calls. To compile, #define trace beforehand */
#ifndef trace
#define trace_routine_entry(idp)
#define trace_routine_exit(idp)
#define trace_statement_execution()
#define trace_data_store(idp, idp_tp, targetp, target_tp)
#define trace_data_fetch(idp, tp, datap)
#endif

#endif




