{$IFDEF WINDOWS}
{$N-,V-,W-,G+}
{$ELSE}
{$E-,N-,V-}
{$ENDIF}

unit BibText;

Interface

Uses
{$IFDEF WINDOWS}
  WinDos, WinProcs;
{$ELSE}
  DOS;
{$ENDIF}

function  TextFilePos(Var f : Text) : LongInt;
procedure TextSeek(Var f : Text; n : LongInt);


Implementation

{$IFDEF WINDOWS}
type
  TextRec = TTextRec;
{$ENDIF}


Procedure GetFileMode; Assembler;

Asm
  CLC
  CMP    ES:[DI].TextRec.Mode, fmInput
  JE     @1
  MOV    [InOutRes], 104         { 'File not opened For reading' }
  xor    AX, AX                  { Zero out Function result }
  xor    DX, DX
  STC
@1:
end;  { GetFileMode }

Function TextFilePos(Var f : Text) : LongInt; Assembler;

Asm
        LES    DI, f
        CALL   GetFileMode
        JC     @1

        xor    CX, CX                  { Get position of File Pointer }
        xor    DX, DX
        MOV    BX, ES:[DI].TextRec.handle
        MOV    AX, 4201h
{$IFDEF WINDOWS}
        call   DOS3CALL
{$ELSE}
        inT    21h                    { offset := offset-Bufend+BufPos }
{$ENDIF}
        xor    BX, BX
        SUB    AX, ES:[DI].TextRec.Bufend
        SBB    DX, BX
        ADD    AX, ES:[DI].TextRec.BufPos
        ADC    DX, BX
@1:
end;  { TextFilePos }

Procedure TextSeek(Var f : Text; n : LongInt); Assembler;

Asm
        LES    DI, f
        CALL   GetFileMode
        JC     @2

        MOV    CX, Word Ptr n+2        { Move File Pointer }
        MOV    DX, Word Ptr n
        MOV    BX, ES:[DI].TextRec.Handle
        MOV    AX, 4200h
{$IFDEF WINDOWS}
        call   DOS3CALL
{$ELSE}
        inT    21h
{$ENDIF}
        JNC    @1                      { Carry flag = reading past Eof }
        MOV    [InOutRes], AX
        JMP    @2

                           { Force read next time }
@1:     MOV    AX, ES:[DI].TextRec.Bufend
        MOV    ES:[DI].TextRec.BufPos, AX
@2:
end;  { TextSeek }

end.
