/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.util;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.mvel2.DataConversion;
import org.mvel2.ParserContext;
import org.mvel2.compiler.PropertyVerifier;
import org.mvel2.util.ParseTools;
import org.mvel2.util.ReflectionUtil;

public class PropertyTools {
    public static boolean isEmpty(Object o) {
        if (o != null) {
            if (o instanceof Object[]) {
                return ((Object[])o).length == 0 || ((Object[])o).length == 1 && PropertyTools.isEmpty(((Object[])o)[0]);
            }
            return "".equals(String.valueOf(o)) || "null".equals(String.valueOf(o)) || o instanceof Collection && ((Collection)o).size() == 0 || o instanceof Map && ((Map)o).size() == 0;
        }
        return true;
    }

    public static Method getSetter(Class clazz, String property) {
        property = ReflectionUtil.getSetter(property);
        for (Method meth : clazz.getMethods()) {
            if ((meth.getModifiers() & 1) == 0 || meth.getParameterTypes().length != 1 || !property.equals(meth.getName())) continue;
            return meth;
        }
        return null;
    }

    public static Method getSetter(Class clazz, String property, Class type) {
        String simple = "set" + property;
        property = ReflectionUtil.getSetter(property);
        for (Method meth : clazz.getMethods()) {
            if ((meth.getModifiers() & 1) == 0 || meth.getParameterTypes().length != 1 || !property.equals(meth.getName()) && !simple.equals(meth.getName()) || type != null && !DataConversion.canConvert(meth.getParameterTypes()[0], type)) continue;
            return meth;
        }
        return null;
    }

    public static boolean hasGetter(Field field) {
        Method meth = PropertyTools.getGetter(field.getDeclaringClass(), field.getName());
        return meth != null && field.getType().isAssignableFrom(meth.getReturnType());
    }

    public static boolean hasSetter(Field field) {
        Method meth = PropertyTools.getSetter(field.getDeclaringClass(), field.getName());
        return meth != null && meth.getParameterTypes().length == 1 && field.getType().isAssignableFrom(meth.getParameterTypes()[0]);
    }

    public static Method getGetter(Class clazz, String property) {
        String simple = "get" + property;
        String simpleIsGet = "is" + property;
        String isGet = ReflectionUtil.getIsGetter(property);
        String getter = ReflectionUtil.getGetter(property);
        HashMap<String, Integer> getterPriorityMap = new HashMap<String, Integer>();
        getterPriorityMap.put(isGet, 4);
        getterPriorityMap.put(simpleIsGet, 3);
        getterPriorityMap.put(getter, 2);
        getterPriorityMap.put(simple, 1);
        getterPriorityMap.put(property, 0);
        Method candidate = null;
        if (Collection.class.isAssignableFrom(clazz) && "isEmpty".equals(isGet)) {
            try {
                return Collection.class.getMethod("isEmpty", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        for (Method meth : clazz.getMethods()) {
            if ((meth.getModifiers() & 1) == 0 || (meth.getModifiers() & 8) != 0 || meth.getParameterTypes().length != 0 || !getter.equals(meth.getName()) && !property.equals(meth.getName()) && (!isGet.equals(meth.getName()) && !simpleIsGet.equals(meth.getName()) || meth.getReturnType() != Boolean.TYPE) && !simple.equals(meth.getName()) || candidate != null && !PropertyTools.isPreferredGetter(candidate, meth, getterPriorityMap)) continue;
            candidate = meth;
        }
        return candidate;
    }

    private static boolean isPreferredGetter(Method oldMethod, Method newMethod, Map<String, Integer> getterPriorityMap) {
        Class<?> newReturnType;
        Class<?> oldReturnType = oldMethod.getReturnType();
        if (oldReturnType.equals(newReturnType = newMethod.getReturnType())) {
            return getterPriorityMap.get(newMethod.getName()) > getterPriorityMap.get(oldMethod.getName());
        }
        return oldReturnType.isAssignableFrom(newReturnType);
    }

    public static Class getReturnType(Class clazz, String property, ParserContext ctx) {
        return new PropertyVerifier(property, ctx, clazz).analyze();
    }

    public static Member getFieldOrAccessor(Class clazz, String property) {
        for (Field f : clazz.getFields()) {
            if (!property.equals(f.getName())) continue;
            if ((f.getModifiers() & 1) == 0) break;
            return f;
        }
        return PropertyTools.getGetter(clazz, property);
    }

    public static Member getFieldOrWriteAccessor(Class clazz, String property) {
        try {
            Field field = clazz.getField(property);
            if (field != null && Modifier.isPublic(field.getModifiers())) {
                return field;
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return PropertyTools.getSetter(clazz, property);
    }

    public static Member getFieldOrWriteAccessor(Class clazz, String property, Class type) {
        for (Field f : clazz.getFields()) {
            if (!property.equals(f.getName()) || type != null && !DataConversion.canConvert(f.getType(), type)) continue;
            return f;
        }
        return PropertyTools.getSetter(clazz, property, type);
    }

    public static boolean contains(Object toCompare, Object testValue) {
        if (toCompare == null) {
            return false;
        }
        if (toCompare instanceof String) {
            return ((String)toCompare).contains(String.valueOf(testValue));
        }
        if (toCompare instanceof Collection) {
            return ((Collection)toCompare).contains(testValue);
        }
        if (toCompare instanceof Map) {
            return ((Map)toCompare).containsKey(testValue);
        }
        if (toCompare.getClass().isArray()) {
            for (Object o : (Object[])toCompare) {
                if (testValue == null && o == null) {
                    return true;
                }
                if (o == null || !o.equals(testValue)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object getPrimitiveInitialValue(Class type) {
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Boolean.TYPE) {
            return false;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Short.TYPE) {
            return (short)0;
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        return 0;
    }

    public static boolean isAssignable(Class to, Class from) {
        return (to.isPrimitive() ? ParseTools.boxPrimitive(to) : to).isAssignableFrom(from.isPrimitive() ? ParseTools.boxPrimitive(from) : from);
    }

    public static String getJavaVersion() {
        return System.getProperty("mvel.java.version") != null ? System.getProperty("mvel.java.version") : System.getProperty("java.version");
    }
}

