/* pkfont.cpp							-*- C++ -*-
   Time-stamp: "97/01/03 17:56:04 mik"

   Copyright (C) 1991, 92, 93, 96, 97
	Christian Schenk  <cschenk@berlin.snafu.de>
   
   This file is part of MiKTeX.

   MiKTeX is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   MiKTeX is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with MiKTeX; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#ifndef _pkfont_h
#define _pkfont_h

#include <stdlib.h>
#include "common.h"
#include "pkchar.h"

#ifdef USE_MFC
class _pkfont : public CObject
#else
class _pkfont
#endif

{
public:
  _pkfont (const char *, dvi_integer, dvi_integer,
	   dvi_integer, const char *, int);
  ~_pkfont ();
  dvi_integer wordspace ();
  dvi_integer backspace ();
  dvi_integer linespace ();
  const _pkchar *operator[] (size_t);

private:
  _pkchar nilchar;
  const char *fontname;
  dvi_integer mag;
  dvi_integer designsize;
  dvi_integer scaledsize;
  const char *mode;
  enum dvi_bool read ();
  int bdpi;
  dvi_integer existSizes[30];
  _pkchar **chars;
  size_t char_count;
  int checkdpi;
  dvi_integer wrdspace;		// boundary between ``small'' and ``large'' spaces
  dvi_integer bakspace;
  dvi_integer linspace;
  dvi_integer ds;		// design size
  dvi_integer cs;		// check sum
  dvi_integer hppp;
  dvi_integer vppp;
  void addsiz (dvi_integer);
  void adddpi (dvi_integer);
  dvi_integer dpicheck (dvi_integer, int);
  enum dvi_bool makeit (const char *, int, int, const char *);
};

#endif /* _pkfont_h */
