.TH PATGEN 1 "7 April 2010" "Web2C @VERSION@"
.\"=====================================================================
.if t .ds TX \fRT\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X\fP
.if n .ds TX TeX
.ie t .ds OX \fIT\v'+0.25m'E\v'-0.25m'X\fP for troff
.el .ds OX TeX
.\" that's for nroff.
.\" the same but obliqued
.\" BX definition must follow TX so BX can use TX
.if t .ds BX \fRB\s-2IB\s0\fP\*(TX
.if n .ds BX BibTeX
.\" LX definition must follow TX so LX can use TX
.if t .ds LX \fRL\\h'-0.36m'\\v'-0.15v'\s-2A\s0\\h'-0.15m'\\v'0.15v'\fP\*(TX
.if n .ds LX LaTeX
.\"=====================================================================
.SH NAME
patgen \- generate patterns for TeX hyphenation
.SH SYNOPSIS
.B patgen
.I dictionary_file pattern_file patout_file translate_file
.\"=====================================================================
.SH DESCRIPTION
This manual page is not meant to be exhaustive.  
See also the Info file or manual
.IR "Web2C: A TeX implementation" .
.PP
The
.I patgen
program reads the
.I dictionary_file
containing a list of hyphenated words and the
.I pattern_file
containing previously-generated patterns (if any) for a particular
language (not a complete TeX source file; see below), and produces the
.I patout_file
with (previously- plus newly-generated) hyphenation patterns for that
language. The
.I translate_file
defines language specific values for the parameters
.IR left_hyphen_min " and " right_hyphen_min
used by \*(TX's hyphenation algorithm and the external representation
of the lower and upper case version(s) of all \`letters' of that
language. Further details of the pattern generation process such as
hyphenation levels and pattern lengths are requested interactively from
the user's terminal. Optionally
.I patgen
creates a new dictionary file
.BI pattmp. n
showing the good and bad hyphens found by the generated patterns, where
.I n
is the highest hyphenation level.
.PP
The patterns generated by
.I patgen
can be read by
.B initex
for use in hyphenating words. For a real-life example of
.IR patgen 's
output, see
.IR $TEXMFMAIN/tex/generic/hyphen/hyphen.tex ,
which contains the patterns \*(TX uses for English by default.
At some sites, patterns for (many) other languages may be available,
and the local
.B tex
programs may have them preloaded.
.PP
All filenames must be complete; no adding of default
extensions or path searching is done.
.\"=====================================================================
.SH FILE FORMATS
.TP \w'@@'u+2n
.B Letters
When
.B initex
digests hyphenation patterns, \*(TX first expands macros and the result
must entirely consist of digits (hyphenation levels), dots (\`.', edge
of a word), and letters. In pattern files for non-English languages
letters are often represented by macros or other expandable constructs.
For the purpose of
.I patgen
these are just character sequences, subject to the condition that no
such sequence is a prefix of another one.
.TP \w'@@'u+2n
.B Dictionary file
A dictionary file contains a weighted list of hyphenated words, one word
per line starting in column 1. A digit in column 1 indicates a global
word weight (initially =1) applicable to all following words up to the
next global word weight. A digit at some intercharacter position
indicates a weight for that position only.

The hyphens in a word are indicated by \`-', \`*', or \`.' (or their
replacements as defined in the translate file) for hyphens yet to be
found, \`good' hyphens (correctly found by the patterns), and \`bad'
hyphens (erroneously found by the patterns) respectively; when reading a
dictionary file \`*' is treated like \`-' and \`.' is ignored.
.TP
.B Pattern file
A pattern file contains only patterns in the format above, e.g., from a
previous run of patgen.  It may \fInot\fR contain any \*(TX comments or
control sequences.  For instance, this is not a valid pattern file:
.nf

% this is a pattern file read by TeX.
\\patterns{%
 .\|.\|.
}
.fi
It can only contain the actual patterns, i.e., the `.\|.\|.'.
.TP
.B Translate file
A translate file starts with a line containing the values of
.I left_hyphen_min
in columns 1-2,
.I right_hyphen_min
in columns 3-4, and either a blank or the replacement for one of the
"hyphen" characters \`-', \`*', and \`.' in columns 5, 6, and 7. (Input
lines are padded with blanks as for many \*(TX related programs.)

Each following line defines one \`letter': an arbitrary delimiter
character in column 1, followed by one or more external representations
of that character (first the \`lower' case one used for output), each
one terminated by the delimiter and the whole sequence terminated by
another delimiter.

If the translate file is empty, the values
.IR left_hyphen_min "=2, " right_hyphen_min "=3,"
and the 26 lower case letters
.BR a .\|.\|. z
with their upper case representations
.BR A .\|.\|. Z
are assumed.
.TP
.B Terminal input
After reading the
.I translate_file
and any previously-generated patterns from
.IR pattern_file ,
.I patgen
requests input from the user's terminal.

First the integer values of
.IR hyph_start " and " hyph_finish ,
the lowest and highest hyphenation level for which patterns are to be
generated. The value of
.I hyph_start
should be larger than any hyphenation level already present in
.IR pattern_file .

Then, for each hyphenation level, the integer values of
.IR pat_start " and " pat_finish ,
the smallest and largest pattern length to be analyzed, as well as
.IR "good weight" ", " "bad weight" ", and " threshold ,
the weights for good and bad hyphens and a weight threshold for useful
patterns.

Finally the decision (\`y' or \`Y' vs. anything else) whether or not to
produce a hyphenated word list.
.\"=====================================================================
.SH FILES
.TP \w'@@'u+2n
.I $TEXMFMAIN/tex/generic/hyphen/hyphen.tex
The original hyphenation patterns for English, by Donald Knuth and Frank
Liang.
.TP
.I $TEXMFMAIN/tex/generic/hyphen/ushyphmax.tex
Maximal hyphenation patterns for English, extended by Gerard Kuiken.
.TP
.I http://www.ctan.org/tex-archive/language/
Patterns and support for many other languages
.\"=====================================================================
.SH "SEE ALSO"
Frank Liang and Peter Breitenlohner,
patgen.web.
.PP
Frank Liang,
.IR "Word hy-phen-a-tion by com-puter" ,
STAN-CS-83-977,
Stanford University Ph.D. thesis, 1983,
http://tug.org/docs/liang.
.PP
Donald E. Knuth,
.IR "The \*(OXbook" ,
Addison-Wesley, 1986, ISBN 0-201-13447-0, Appendix H.
.\"=====================================================================
.SH AUTHORS
Frank Liang wrote the first version of this program.  Peter
Breitenlohner made a
substantial revision in 1991 for \*(TX 3.
The first version was published as the appendix to the
.I \*(OXware
technical report. Howard Trickey originally ported it to Unix.
