## -----------------------------------------------------------------------------
library(multiRec)
data(multiRecCVD2)
data(multiRecCVD4)

head(multiRecCVD2)
head(multiRecCVD4)

## -----------------------------------------------------------------------------
fit = multiRec(afib ~ age + male,          # The model for the AF hazard
               hf   ~ age + male + bmi,    # The model for the HF hazard
               data   = multiRecCVD2       # The dataset used
)

## -----------------------------------------------------------------------------
fit

## -----------------------------------------------------------------------------
fit = multiRec(stroke ~ nPrior.hf(),
               afib   ~ age,
               hf     ~ nPrior.stroke(),
               death  ~ age + nPrior.stroke() + nPrior.afib() + nPrior.hf(),
               data      = multiRecCVD4, 
               robust    = TRUE,
               SANN.init = 50
)

## -----------------------------------------------------------------------------
fit

## -----------------------------------------------------------------------------

fit = multiRec(stroke ~ nPrior.hf() + nPrior.afib(),
               afib   ~ nPrior.hf() + nPrior.stroke(),
               hf     ~ nPrior.stroke() + nPrior.afib(),
               death  ~ age + nPrior.stroke()  
                            + nPrior.afib() 
                            + nPrior.hf(~ male, alpha=NA),
               data = multiRecCVD4, 
               robust = TRUE,
               SANN.init = 50,
               method.seed = 1)

## -----------------------------------------------------------------------------
fit

