/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.classfile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.graalvm.visualvm.lib.jfluid.classfile.ClassFileCache;
import org.graalvm.visualvm.lib.jfluid.classfile.ClassLoaderTable;
import org.graalvm.visualvm.lib.jfluid.classfile.DynamicClassInfo;
import org.graalvm.visualvm.lib.jfluid.utils.MiscUtils;

public class ClassPath {
    private static final Random r = new Random(System.currentTimeMillis());
    private ClassFileCache classCache;
    private ClassLoaderTable loaderTable;
    private JarLRUCache zipFileNameToFile;
    private PathEntry[] paths;
    private boolean isCP;

    public ClassPath(String classPath, boolean isCP) {
        this.isCP = isCP;
        ArrayList<PathEntry> vec = new ArrayList<PathEntry>();
        this.zipFileNameToFile = new JarLRUCache();
        StringTokenizer tok = new StringTokenizer(classPath, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            File file;
            String path = tok.nextToken();
            if (path.isEmpty() || !(file = new File(path)).exists()) continue;
            if (file.isDirectory()) {
                vec.add(new Dir(file));
                continue;
            }
            vec.add(new Zip(file.getPath()));
        }
        this.paths = vec.toArray(new PathEntry[0]);
        this.classCache = new ClassFileCache(this);
        this.loaderTable = new ClassLoaderTable();
    }

    public DynamicClassInfo getClassInfoForClass(String className, int classLoaderId) throws IOException, ClassFormatError {
        String slashedClassName = className.replace('.', '/');
        String dirOrJar = this.getLocationForClass(slashedClassName);
        if (dirOrJar == null) {
            return null;
        }
        return new DynamicClassInfo(this, slashedClassName, classLoaderId, dirOrJar);
    }

    public String getLocationForClass(String slashedClassName) {
        String fileName = slashedClassName + (this.isCP ? ".class" : ".java");
        for (PathEntry path : this.paths) {
            String location = path.getLocationForClassFile(fileName);
            if (location == null) continue;
            return location;
        }
        return null;
    }

    public ZipFile getZipFileForName(String zipFileName) throws IOException {
        ZipFile zip = (ZipFile)this.zipFileNameToFile.get(zipFileName);
        if (zip == null) {
            zip = new ZipFile(zipFileName);
            this.zipFileNameToFile.put(zipFileName, zip);
        }
        return zip;
    }

    void addVMSuppliedClassFile(String className, int classLoaderId, byte[] buf) {
        this.classCache.addVMSuppliedClassFile(className, classLoaderId, buf);
    }

    int hasVMSuppliedClassFile(String className, int classLoaderId) {
        return this.classCache.hasVMSuppliedClassFile(className, classLoaderId);
    }

    byte[] getClassFile(String name, String classFileLocation) throws IOException {
        return this.classCache.getClassFile(name, classFileLocation);
    }

    void preloadBytecode(String name, String classFileLocation) {
        this.classCache.preloadBytecode(name, classFileLocation);
    }

    public ClassLoaderTable getClassLoaderTable() {
        return this.loaderTable;
    }

    public void close() {
        Iterator it = this.zipFileNameToFile.values().iterator();
        while (it.hasNext()) {
            try {
                ((ZipFile)it.next()).close();
            }
            catch (IOException iOException) {}
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (PathEntry path : this.paths) {
            buf.append(path instanceof Dir ? ((Dir)path).dir.getAbsolutePath() : ((Zip)path).zipFilePath);
            buf.append(File.pathSeparatorChar);
        }
        return buf.toString();
    }

    private static class JarLRUCache
    extends LinkedHashMap {
        private static final int MAX_CAPACITY = 100;

        private JarLRUCache() {
            super(10, 0.75f, true);
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            if (this.size() > 100) {
                try {
                    ((ZipFile)eldest.getValue()).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }
    }

    private class Zip
    extends PathEntry {
        private String zipFilePath;

        Zip(String path) {
            this.zipFilePath = path;
            this.threshHits = 50 + r.nextInt(20);
        }

        @Override
        String getLocationForClassFile(String fileName) {
            ZipFile zip;
            if (this.entries != null) {
                if (this.entries.contains(fileName)) {
                    return this.zipFilePath;
                }
                return null;
            }
            if (++this.hits >= this.threshHits) {
                this.entries = new HashSet();
                MiscUtils.getAllClassesInJar(this.zipFilePath, false, this.entries);
                return this.getLocationForClassFile(fileName);
            }
            try {
                zip = ClassPath.this.getZipFileForName(this.zipFilePath);
            }
            catch (IOException ex) {
                System.err.println("Warning: CLASSPATH component " + this.zipFilePath + ": " + ex);
                return null;
            }
            ZipEntry entry = zip.getEntry(fileName);
            if (entry != null) {
                return this.zipFilePath;
            }
            return null;
        }
    }

    private static class Dir
    extends PathEntry {
        private File dir;

        Dir(File dirF) {
            this.dir = dirF;
            this.threshHits = 100 + r.nextInt(40);
        }

        @Override
        String getLocationForClassFile(String fileName) {
            if (this.entries != null) {
                if (this.entries.contains(fileName)) {
                    return this.dir.getAbsolutePath();
                }
                return null;
            }
            if (++this.hits >= this.threshHits) {
                this.entries = new HashSet();
                MiscUtils.getAllClassesInDir(this.dir.getAbsolutePath(), "", false, this.entries);
                return this.getLocationForClassFile(fileName);
            }
            File file = new File(this.dir, fileName);
            if (file.exists()) {
                return this.dir.getAbsolutePath();
            }
            return null;
        }
    }

    private static abstract class PathEntry {
        protected HashSet entries;
        protected int hits;
        protected int threshHits;

        private PathEntry() {
        }

        abstract String getLocationForClassFile(String var1);
    }
}

