/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen.shutdown;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShutdownActionComboBox
extends JComboBox<String> {
    private static final String DOMAIN = "org.mediathekview.mv_shutdown_helper";
    private static final String KEY = "shutdownAction";
    private static final String COMMAND = "/usr/bin/defaults";
    private static final List<String> ACTIONS = Arrays.asList("shutdown", "sleep", "restart");
    private static final Logger logger = LogManager.getLogger();

    public ShutdownActionComboBox() {
        super(new DefaultComboBoxModel<String>(ACTIONS.toArray(new String[0])));
        this.setSelectedItem(this.readCurrentAction());
        this.addActionListener(actionEvent -> {
            String selected = (String)this.getSelectedItem();
            if (selected != null) {
                this.writeAction(selected);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readCurrentAction() {
        try {
            ProcessBuilder pb = new ProcessBuilder(COMMAND, "read", DOMAIN, KEY);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            try (InputStreamReader isr = new InputStreamReader(process.getInputStream());
                 BufferedReader reader = new BufferedReader(isr);){
                String line = reader.readLine();
                if (line == null) return "shutdown";
                if (!ACTIONS.contains(line.trim().toLowerCase())) return "shutdown";
                String string = line.trim().toLowerCase();
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "shutdown";
    }

    private void writeAction(String action) {
        try {
            new ProcessBuilder(COMMAND, "write", DOMAIN, KEY, "-string", action).inheritIO().start().waitFor();
        }
        catch (Exception e) {
            System.err.println("Konnte defaults-Wert nicht schreiben: " + e.getMessage());
            logger.error("Failed to write shutdown action", (Throwable)e);
        }
    }
}

