/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import org.linuxsampler.lscp.AbstractParameter;
import org.linuxsampler.lscp.LscpException;
import org.linuxsampler.lscp.ParameterType;
import org.linuxsampler.lscp.Parser;

public class StringListParameter
extends AbstractParameter<String[]> {
    public StringListParameter() {
        this.setType(ParameterType.STRING_LIST);
        this.setMultiplicity(true);
    }

    public StringListParameter(String string) {
        this(string, null);
    }

    public StringListParameter(String string, String[] stringArray) {
        this();
        this.setName(string);
        this.setValue(stringArray);
    }

    protected StringListParameter(String[] stringArray) throws LscpException {
        this();
        this.parseLines(stringArray);
    }

    @Override
    public boolean parse(String string) throws LscpException {
        if (super.parse(string)) {
            return true;
        }
        if (string.startsWith("DEFAULT: ")) {
            this.setDefault(Parser.parseStringList(string.substring("DEFAULT: ".length())));
            return true;
        }
        if (string.startsWith("POSSIBILITIES: ")) {
            string = string.substring("POSSIBILITIES: ".length(), string.length());
            this.setPossibilities((T[])Parser.parseListOfStringLists(string));
            return true;
        }
        return false;
    }

    @Override
    public void parseValue(String string) throws LscpException {
        this.setValue(Parser.parseEscapedStringList(string));
    }

    @Override
    public String getStringValue() {
        String[] stringArray = (String[])this.getValue();
        if (stringArray == null || stringArray.length == 0) {
            return "NONE";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\'').append(stringArray[0]).append('\'');
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(",'").append(stringArray[i]).append('\'');
        }
        return stringBuffer.toString();
    }
}

