/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.cde.ui;

import java.util.List;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.cde.ui.ConstraintSelectComposite;
import org.apache.uima.ruta.cde.ui.ConstraintSelectView;
import org.apache.uima.ruta.cde.utils.ConstraintData;
import org.apache.uima.ruta.cde.utils.ConstraintXMLUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExportConstraintsHandler
implements IHandler {
    public void addHandlerListener(IHandlerListener arg0) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        FileDialog dlg = new FileDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), 8192);
        String[] extensions = new String[]{"*.xml"};
        dlg.setFilterExtensions(extensions);
        String s = dlg.open();
        if (s == null) {
            return Status.CANCEL_STATUS;
        }
        try {
            ConstraintSelectView constraintView = (ConstraintSelectView)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.apache.uima.ruta.cde.ui.ConstraintSelectView");
            ConstraintSelectComposite composite = constraintView.getComposite();
            List<ConstraintData> constraintList = composite.getConstraintList();
            ExportAllConstraintsJob job = new ExportAllConstraintsJob(s, constraintList);
            job.schedule();
        }
        catch (Exception e) {
            RutaAddonsPlugin.error(e);
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener arg0) {
    }

    private class ExportAllConstraintsJob
    extends Job {
        private String outputLocation;
        private List<ConstraintData> constraints;

        ExportAllConstraintsJob(String outputLocation, List<ConstraintData> constraints) {
            super("Exporting constraints");
            this.outputLocation = outputLocation;
            this.constraints = constraints;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                ConstraintXMLUtils.writeConstraints(this.outputLocation, this.constraints);
                IPath path = Path.fromPortableString((String)this.outputLocation);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IFile ifile = root.getFileForLocation(path);
                if (ifile != null) {
                    ifile.getParent().refreshLocal(2, monitor);
                }
            }
            catch (Exception e) {
                RutaAddonsPlugin.error(e);
            }
            return Status.OK_STATUS;
        }
    }
}

