/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.ec;

import io.churchkey.shade.util.Hex;
import io.churchkey.shade.util.Join;
import io.churchkey.shade.util.PrintString;
import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;

public class ECParameterSpecs {
    private ECParameterSpecs() {
    }

    public static boolean equals(ECParameterSpec expected, ECParameterSpec actual) {
        ECField actualField;
        ECField expectedField;
        if (expected.getCofactor() != actual.getCofactor()) {
            return false;
        }
        if (!expected.getOrder().equals(actual.getOrder())) {
            return false;
        }
        if (!expected.getCurve().getA().equals(actual.getCurve().getA())) {
            return false;
        }
        if (!expected.getCurve().getB().equals(actual.getCurve().getB())) {
            return false;
        }
        if (!expected.getGenerator().getAffineX().equals(actual.getGenerator().getAffineX())) {
            return false;
        }
        if (!expected.getGenerator().getAffineY().equals(actual.getGenerator().getAffineY())) {
            return false;
        }
        if (expected.getCurve().getField() instanceof ECFieldFp) {
            expectedField = (ECFieldFp)expected.getCurve().getField();
            actualField = (ECFieldFp)actual.getCurve().getField();
            if (!((ECFieldFp)expectedField).getP().equals(((ECFieldFp)actualField).getP())) {
                return false;
            }
        }
        if (expected.getCurve().getField() instanceof ECFieldF2m && expected.getCurve().getField() instanceof ECFieldF2m) {
            expectedField = (ECFieldF2m)expected.getCurve().getField();
            actualField = (ECFieldF2m)actual.getCurve().getField();
            if (!((ECFieldF2m)expectedField).getReductionPolynomial().equals(((ECFieldF2m)actualField).getReductionPolynomial())) {
                return false;
            }
        }
        return true;
    }

    public static String toString(ECParameterSpec spec) {
        PrintString out = new PrintString();
        String x = ECParameterSpecs.hex(spec.getGenerator().getAffineX());
        String y = ECParameterSpecs.hex(spec.getGenerator().getAffineY());
        String a = ECParameterSpecs.hex(spec.getCurve().getA());
        String b = ECParameterSpecs.hex(spec.getCurve().getB());
        String n = ECParameterSpecs.hex(spec.getOrder());
        int cofactor = spec.getCofactor();
        ECField field = spec.getCurve().getField();
        if (field instanceof ECFieldFp) {
            ECFieldFp fp = (ECFieldFp)field;
            String p = ECParameterSpecs.hex(fp.getP());
            out.printf("prime(\n    \"%s\",\n    \"%s\",\n    \"%s\",\n    \"%s\",\n    \"%s\",\n    \"%s\",\n    %s), %s)\n", p, a, b, x, y, n, cofactor, null);
        } else if (field instanceof ECFieldF2m) {
            ECFieldF2m binary = (ECFieldF2m)field;
            int m = binary.getM();
            ArrayList<Integer> terms = new ArrayList<Integer>();
            for (int i : binary.getMidTermsOfReductionPolynomial()) {
                terms.add(i);
            }
            out.printf("binary(%s, new int[]{%s},\n    \"%s\",\n    \"%s\",\n    \"%s\",\n    \"%s\",\n    \"%s\",\n    %s), %s)\n", m, Join.join(", ", terms), a, b, x, y, n, cofactor, null);
        }
        return out.toString();
    }

    public static String hex(BigInteger bi) {
        return Hex.toString(bi.toByteArray()).toUpperCase();
    }
}

