/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.services;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface PerThreadValue<T> {
    public boolean exists();

    public T get();

    public T get(T var1);

    public T set(T var1);

    default public T computeIfAbsent(Supplier<? extends T> fn) {
        Objects.requireNonNull(fn);
        if (this.exists()) {
            return this.get();
        }
        T newValue = fn.get();
        this.set(newValue);
        return newValue;
    }

    default public T computeIfPresent(Function<? super T, ? extends T> fn) {
        Objects.requireNonNull(fn);
        if (!this.exists()) {
            return null;
        }
        T newValue = fn.apply(this.get());
        this.set(newValue);
        return newValue;
    }

    default public T compute(Function<? super T, ? extends T> fn) {
        Objects.requireNonNull(fn);
        T newValue = fn.apply(this.get());
        this.set(newValue);
        return newValue;
    }

    default public void ifSet(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        if (!this.exists()) {
            return;
        }
        action.accept(this.get());
    }
}

